/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.orthoview;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.fogofwar2.FogManager;
import com.solegendary.reignofnether.guiscreen.TopdownGui;
import com.solegendary.reignofnether.guiscreen.TopdownGuiServerboundPacket;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.minimap.MinimapClientEvents;
import com.solegendary.reignofnether.orthoview.CameraManager;
import com.solegendary.reignofnether.orthoview.CameraShake;
import com.solegendary.reignofnether.orthoview.InputManager;
import com.solegendary.reignofnether.orthoview.LeavesHidingManager;
import com.solegendary.reignofnether.orthoview.VisibilityCulling;
import com.solegendary.reignofnether.player.PlayerServerboundPacket;
import com.solegendary.reignofnether.startpos.StartPosClientEvents;
import com.solegendary.reignofnether.startpos.StartPosServerboundPacket;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unitcontrol.UnitControlManager;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.CameraType;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;

public class OrthoviewClientEvents {
    public static LeafHideMethod hideLeavesMethod = LeafHideMethod.NONE;
    public static int enabledCount = 0;
    public static boolean enabled = false;
    private static final Minecraft MC = Minecraft.m_91087_();

    public static boolean shouldHideLeaves() {
        return hideLeavesMethod != LeafHideMethod.NONE;
    }

    public static void setMinOrthoviewY(double value) {
        CameraManager.setMinOrthoviewY(value);
    }

    public static float getPanSensitivityMult() {
        return CameraManager.getPanSensitivityMult();
    }

    public static void adjustPanSensitivityMult(boolean increase) {
        CameraManager.adjustPanSensitivityMult(increase);
    }

    public static float getMaxPanSensitivity() {
        return 3.0f;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean isCameraMovingByMouse() {
        return InputManager.isCameraMovingByMouse();
    }

    public static float getZoom() {
        return CameraManager.getZoom();
    }

    public static float getCamRotX() {
        return CameraManager.getCamRotX();
    }

    public static float getCamRotY() {
        return CameraManager.getCamRotY();
    }

    public static boolean isCameraLocked() {
        return CameraManager.isCameraLocked();
    }

    public static void lockCam() {
        CameraManager.lockCam();
    }

    public static void unlockCam() {
        CameraManager.unlockCam();
    }

    private static void reset() {
        CameraManager.reset();
        InputManager.reset();
    }

    public static void rotateCam(float x, float y) {
        CameraManager.rotateCam(x, y);
    }

    public static void zoomCam(float zoomAdj) {
        CameraManager.zoomCam(zoomAdj);
    }

    public static void panCam(float x, float y, float z) {
        CameraManager.panCam(x, y, z);
    }

    public static void forceMoveCam(int x, int z, int cameraLockTicks) {
        CameraManager.forceMoveCam(x, z, cameraLockTicks);
    }

    public static void forceMoveCam(Vec3i pos, int cameraLockTicks) {
        CameraManager.forceMoveCam(pos, cameraLockTicks);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (OrthoviewClientEvents.isEnabled() && OrthoviewClientEvents.MC.f_91072_ != null && (OrthoviewClientEvents.MC.f_91072_.m_105295_() == GameType.ADVENTURE || OrthoviewClientEvents.MC.f_91072_.m_105295_() == GameType.SURVIVAL)) {
            OrthoviewClientEvents.toggleEnable();
        }
        if (!OrthoviewClientEvents.isEnabled()) {
            return;
        }
        if (UnitControlManager.shouldSkipOrthoviewUpdates()) {
            if (enabledCount % 60 == 0) {
                System.out.println("[Orthoview] Skipping camera updates due to unit control");
            }
            CameraShake.updateShakes();
            VisibilityCulling.updateCulling();
            LeavesHidingManager.tick();
            return;
        }
        CameraManager.updateCamera();
        CameraShake.updateShakes();
        VisibilityCulling.updateCulling();
        LeavesHidingManager.tick();
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) throws NoSuchFieldException {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || !OrthoviewClientEvents.isEnabled()) {
            return;
        }
        CameraManager.updateRotation();
    }

    public static void toggleEnable() {
        if (OrthoviewClientEvents.MC.f_91073_ == null || OrthoviewClientEvents.MC.f_91074_ == null) {
            return;
        }
        for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
            if (!(building instanceof RangeIndicator)) continue;
            RangeIndicator ri = (RangeIndicator)((Object)building);
            ri.updateBorderBps();
        }
        boolean bl = enabled = !enabled;
        if (enabled) {
            OrthoviewClientEvents.MC.f_91066_.f_92030_ = TutorialSteps.NONE;
            MC.m_91301_().m_120594_();
            ++enabledCount;
            PlayerServerboundPacket.enableOrthoview();
            MinimapClientEvents.setMapCentre(OrthoviewClientEvents.MC.f_91074_.m_20185_(), OrthoviewClientEvents.MC.f_91074_.m_20189_());
            PlayerServerboundPacket.teleportPlayer(OrthoviewClientEvents.MC.f_91074_.m_20185_(), CameraManager.orthoviewPlayerBaseY, OrthoviewClientEvents.MC.f_91074_.m_20189_());
            TopdownGuiServerboundPacket.openTopdownGui(OrthoviewClientEvents.MC.f_91074_.m_19879_());
            OrthoviewClientEvents.MC.f_91066_.m_232050_().m_231514_((Object)CloudStatus.OFF);
            OrthoviewClientEvents.MC.f_91066_.f_92062_ = false;
            OrthoviewClientEvents.MC.f_91066_.m_92157_(CameraType.FIRST_PERSON);
            OrthoviewClientEvents.switchToEasyIfPeaceful();
        } else {
            PlayerServerboundPacket.disableOrthoview();
            TopdownGuiServerboundPacket.closeTopdownGui(OrthoviewClientEvents.MC.f_91074_.m_19879_());
            if (StartPosClientEvents.hasReservedPos()) {
                StartPosClientEvents.selectedFaction = Faction.NONE;
                StartPosServerboundPacket.unreservePos(StartPosClientEvents.getPos().pos);
            }
        }
        TutorialClientEvents.updateStage();
    }

    public static void centreCameraOnPos(BlockPos bp) {
        CameraManager.centreCameraOnPos(bp);
    }

    public static void centreCameraOnPos(Vec3 pos) {
        CameraManager.centreCameraOnPos(pos);
    }

    @SubscribeEvent
    public static void onRenderArm(RenderArmEvent evt) {
        if (OrthoviewClientEvents.isEnabled()) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent evt) {
        if (OrthoviewClientEvents.isEnabled()) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInput(InputEvent.Key evt) {
        if (evt.getAction() == 1) {
            if (evt.getKey() == Keybindings.getFnum((int)12).key) {
                OrthoviewClientEvents.tryToToggleEnable();
            } else if (evt.getKey() == Keybindings.reset.key) {
                OrthoviewClientEvents.reset();
            }
        }
    }

    public static void fixedRotateCam(boolean clockwise) {
        CameraManager.fixedRotateCam(clockwise);
    }

    public static void tryToToggleEnable() {
        if (!OrthoviewClientEvents.isCameraLocked() && OrthoviewClientEvents.MC.f_91072_ != null) {
            if (OrthoviewClientEvents.MC.f_91074_ != null && (OrthoviewClientEvents.MC.f_91072_.m_105295_() == GameType.ADVENTURE || OrthoviewClientEvents.MC.f_91072_.m_105295_() == GameType.SURVIVAL)) {
                OrthoviewClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)I18n.m_118938_((String)"hud.orthoview.reignofnether.ortho_error", (Object[])new Object[0])));
            } else {
                OrthoviewClientEvents.toggleEnable();
            }
        }
    }

    public static Button getLeavesHidingButton() {
        return new Button("Hide Leaves Method", 14, switch (hideLeavesMethod) {
            default -> throw new IncompatibleClassChangeError();
            case LeafHideMethod.NONE -> new ResourceLocation("reignofnether", "textures/icons/blocks/leaves.png");
            case LeafHideMethod.AROUND_UNITS_AND_CURSOR -> new ResourceLocation("reignofnether", "textures/icons/blocks/lime_stained_glass.png");
            case LeafHideMethod.ALL -> new ResourceLocation("reignofnether", "textures/icons/blocks/glass.png");
        }, new ResourceLocation("reignofnether", "textures/hud/icon_frame.png"), null, () -> false, () -> !TutorialClientEvents.isAtOrPastStage(TutorialStage.MINIMAP_CLICK) || !MinimapClientEvents.isLargeMap(), () -> true, () -> {
            FogManager.forceUpdate();
            LeavesHidingManager.onFogUpdate();
            UnitClientEvents.windowUpdateTicks = 0;
            if (hideLeavesMethod == LeafHideMethod.NONE) {
                hideLeavesMethod = LeafHideMethod.AROUND_UNITS_AND_CURSOR;
            } else if (hideLeavesMethod == LeafHideMethod.AROUND_UNITS_AND_CURSOR) {
                hideLeavesMethod = LeafHideMethod.ALL;
            } else if (hideLeavesMethod == LeafHideMethod.ALL) {
                hideLeavesMethod = LeafHideMethod.NONE;
            }
        }, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.orthoview.reignofnether.hiding_leaves_around", (Object[])new Object[0]), hideLeavesMethod == LeafHideMethod.AROUND_UNITS_AND_CURSOR), MiscUtil.fcs(I18n.m_118938_((String)"hud.orthoview.reignofnether.hiding_leaves_all", (Object[])new Object[0]), hideLeavesMethod == LeafHideMethod.ALL), MiscUtil.fcs(I18n.m_118938_((String)"hud.orthoview.reignofnether.disabled_hiding_leaves", (Object[])new Object[0]), hideLeavesMethod == LeafHideMethod.NONE)));
    }

    private static void switchToEasyIfPeaceful() {
        Difficulty currentDifficulty;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.m_91092_() != null && (currentDifficulty = minecraft.f_91073_.m_46791_()) == Difficulty.PEACEFUL) {
            minecraft.m_91092_().m_129827_(Difficulty.EASY, true);
            HudClientEvents.showTemporaryMessage("RTS units cannot spawn in Peaceful. Your difficulty has been set to Easy.");
        }
    }

    @SubscribeEvent
    public static void onMouseScroll(ScreenEvent.MouseScrolled evt) {
        InputManager.handleMouseScroll(evt);
    }

    @SubscribeEvent
    public static void onDrawScreen(ScreenEvent.Render evt) {
        if (!enabled || !(evt.getScreen() instanceof TopdownGui)) {
            return;
        }
        InputManager.handleScreenInput();
        CameraManager.applyRotationToPlayer();
    }

    @SubscribeEvent
    public static void onRenderBlockOverlay(RenderBlockScreenEffectEvent evt) {
        if (enabled) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Post evt) {
        InputManager.handleMouseClick(evt);
    }

    @SubscribeEvent
    public static void onMouseRelease(ScreenEvent.MouseButtonReleased evt) {
        InputManager.handleMouseRelease(evt);
    }

    @SubscribeEvent
    public static void onMouseDrag(ScreenEvent.MouseDragged evt) {
        InputManager.handleMouseDrag(evt);
    }

    @SubscribeEvent
    public static void onPlayerRender(RenderPlayerEvent.Pre evt) {
        if (enabled && (evt.getEntity().m_5833_() || evt.getEntity().m_7500_())) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFovModifier(ViewportEvent.ComputeFov evt) {
        if (enabled) {
            evt.setFOV(180.0);
        }
    }

    public static Matrix4f getOrthographicProjection() {
        int width = MC.m_91268_().m_85443_();
        int height = MC.m_91268_().m_85444_();
        float near = -3000.0f;
        float far = 3000.0f;
        float zoomFinal = CameraManager.getZoom();
        float wView = zoomFinal / (float)height * (float)width;
        float left = -wView / 2.0f;
        float rgt = wView / 2.0f;
        float top = zoomFinal / 2.0f;
        float bot = -zoomFinal / 2.0f;
        Matrix4f m1 = new Matrix4f(2.0f / (rgt - left), 0.0f, 0.0f, -(rgt + left) / (rgt - left), 0.0f, 2.0f / (top - bot), 0.0f, -(top + bot) / (top - bot), 0.0f, 0.0f, -2.0f / (far - near), -(far + near) / (far - near), 0.0f, 0.0f, 0.0f, 1.0f);
        return m1;
    }

    public static enum LeafHideMethod {
        NONE,
        AROUND_UNITS_AND_CURSOR,
        ALL;

    }
}

