/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.orthoview;

import com.solegendary.reignofnether.config.ReignOfNetherCommonConfigs;
import com.solegendary.reignofnether.orthoview.CameraBounds;
import com.solegendary.reignofnether.orthoview.CameraCollision;
import com.solegendary.reignofnether.orthoview.CameraManager;
import com.solegendary.reignofnether.orthoview.CameraShake;
import com.solegendary.reignofnether.orthoview.CameraTransitions;
import com.solegendary.reignofnether.orthoview.TerrainFollowing;
import com.solegendary.reignofnether.orthoview.VisibilityCulling;
import com.solegendary.reignofnether.player.PlayerServerboundPacket;
import com.solegendary.reignofnether.util.MyMath;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class RTSCameraController {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final float ZOOM_MIN = 10.0f;
    private static final float ZOOM_MAX = 90.0f;
    private static final float ZOOM_DEFAULT = 30.0f;
    private static final float YAW_DEFAULT = 135.0f;
    private static final float PITCH_DEFAULT = -45.0f;
    private static float zoom = 30.0f;
    private static float yaw = 135.0f;
    private static float pitch = -45.0f;
    private static float yawAdj = 0.0f;
    private static float pitchAdj = 0.0f;
    private static Vec3 lastPos = Vec3.f_82478_;
    private static Vec3 emaVel = Vec3.f_82478_;
    private static final double EMA_ALPHA = 0.25;
    private static final double LOOKAHEAD_TICKS = 2.0;
    private static boolean initialized = false;
    private static double verticalVelocity = 0.0;
    private static final double SPRING_STIFFNESS = 0.18;
    private static final double SPRING_DAMPING = 0.65;
    private static final double MAX_VERTICAL_STEP = 2.5;
    private static double targetHeight = 100.0;
    private static double filteredTargetHeight = 100.0;
    private static boolean cameraLocked = false;
    private static int cameraLockTicksLeft = 0;
    private static double minOrthoviewY = 0.0;
    private static double minHeightFloor = 0.0;
    private static float panSensitivityMult = 1.0f;
    public static final float MAX_PAN_SENSITIVITY = 3.0f;
    private static final int SMOOTH_PAN_DURATION = 30;
    private static final int SMOOTH_ZOOM_DURATION = 15;
    private static final int SMOOTH_ROT_DURATION = 25;
    private static boolean smoothPanActive = false;
    private static int smoothPanTicksLeft = 0;
    private static float smoothPanStartX = 0.0f;
    private static float smoothPanStartZ = 0.0f;
    private static float smoothPanTargetX = 0.0f;
    private static float smoothPanTargetZ = 0.0f;
    private static CameraTransitions.EasingType smoothPanEasing = CameraTransitions.EasingType.EASE_OUT_CUBIC;
    private static boolean smoothZoomActive = false;
    private static int smoothZoomTicksLeft = 0;
    private static float smoothZoomStart = 0.0f;
    private static float smoothZoomTarget = 0.0f;
    private static CameraTransitions.EasingType smoothZoomEasing = CameraTransitions.EasingType.EASE_IN_OUT_QUAD;
    private static boolean smoothRotActive = false;
    private static int smoothRotTicksLeft = 0;
    private static float smoothRotStartYaw = 0.0f;
    private static float smoothRotTargetYaw = 0.0f;
    private static CameraTransitions.EasingType smoothRotEasing = CameraTransitions.EasingType.EASE_IN_OUT_CUBIC;
    private static final double SPEED_FOR_MAX_PRED_WEIGHT = 0.8;
    private static final double MAX_UP_PER_TICK = 4.5;
    private static final double MAX_DOWN_PER_TICK = 3.0;
    private static final double MAX_ACCEL_UP = 1.2;
    private static final double MAX_ACCEL_DOWN = 1.2;
    private static final double ERROR_STIFFNESS_SCALE = 48.0;
    private static final double ERROR_STIFFNESS_MULT = 2.0;
    private static final double ERROR_DAMPING_MULT = 2.0;
    private static final double MAX_SLOPE_UP_PER_BLOCK = 1.4;
    private static final double MAX_SLOPE_DOWN_PER_BLOCK = 1.1;

    public static void reset() {
        zoom = 30.0f;
        yaw = 135.0f;
        pitch = -45.0f;
        yawAdj = 0.0f;
        pitchAdj = 0.0f;
        lastPos = Vec3.f_82478_;
        emaVel = Vec3.f_82478_;
        verticalVelocity = 0.0;
        targetHeight = 100.0;
        filteredTargetHeight = 100.0;
        minHeightFloor = 0.0;
        initialized = false;
        CameraCollision.clearCache();
        VisibilityCulling.clearCache();
        TerrainFollowing.clearCache();
    }

    public static void update() {
        if (RTSCameraController.MC.f_91074_ == null || RTSCameraController.MC.f_91073_ == null) {
            return;
        }
        if (!initialized) {
            lastPos = RTSCameraController.MC.f_91074_.m_20182_();
            yaw = -RTSCameraController.MC.f_91074_.m_146908_();
            initialized = true;
        }
        Vec3 pos = RTSCameraController.MC.f_91074_.m_20182_();
        Vec3 instVel = pos.m_82546_(lastPos);
        emaVel = new Vec3(RTSCameraController.lerp(RTSCameraController.emaVel.f_82479_, instVel.f_82479_, 0.25), RTSCameraController.lerp(RTSCameraController.emaVel.f_82480_, instVel.f_82480_, 0.25), RTSCameraController.lerp(RTSCameraController.emaVel.f_82481_, instVel.f_82481_, 0.25));
        lastPos = pos;
        if (cameraLockTicksLeft > 0) {
            --cameraLockTicksLeft;
        }
        double speedXZ = Math.hypot(RTSCameraController.emaVel.f_82479_, RTSCameraController.emaVel.f_82481_);
        double cfgLookaheadScale = (Double)ReignOfNetherCommonConfigs.EXP_CAM_LOOKAHEAD_SPEED_SCALE.get();
        double lookaheadTicks = 2.0 + RTSCameraController.clamp(speedXZ * cfgLookaheadScale, 0.0, 3.0);
        Vec3 futurePos = pos.m_82520_(RTSCameraController.emaVel.f_82479_ * lookaheadTicks, 0.0, RTSCameraController.emaVel.f_82481_ * lookaheadTicks);
        double optimal = TerrainFollowing.calculateOptimalHeight(futurePos);
        double predicted = TerrainFollowing.predictHeight(pos, emaVel);
        double minH = TerrainFollowing.getMinimumHeight(futurePos);
        double cfgSpeedForMaxPred = (Double)ReignOfNetherCommonConfigs.EXP_CAM_SPEED_FOR_MAX_PRED.get();
        double predWeight = RTSCameraController.clamp(speedXZ / cfgSpeedForMaxPred, 0.0, 1.0);
        double desiredMixed = RTSCameraController.lerp(optimal, predicted, predWeight);
        if (minHeightFloor <= 0.0) {
            minHeightFloor = Math.max(minH, minOrthoviewY);
        } else {
            double baseDrop = (Double)ReignOfNetherCommonConfigs.EXP_CAM_FLOOR_DROP_BASE.get();
            double speedDropScale = (Double)ReignOfNetherCommonConfigs.EXP_CAM_FLOOR_DROP_SPEED_SCALE.get();
            double downStep = baseDrop + speedXZ * speedDropScale;
            minHeightFloor = Math.max(Math.max(minH, minOrthoviewY), minHeightFloor - downStep);
        }
        double desiredClamped = Math.max(desiredMixed, minHeightFloor);
        double cfgMaxUp = (Double)ReignOfNetherCommonConfigs.EXP_CAM_MAX_UP_PER_TICK.get();
        double cfgMaxDown = (Double)ReignOfNetherCommonConfigs.EXP_CAM_MAX_DOWN_PER_TICK.get();
        double riseCap = cfgMaxUp + speedXZ * 1.0;
        double fallCap = cfgMaxDown + speedXZ * 0.6;
        double deltaTarget = desiredClamped - filteredTargetHeight;
        deltaTarget = RTSCameraController.clamp(deltaTarget, -fallCap, riseCap);
        targetHeight = filteredTargetHeight += deltaTarget;
        double currentY = RTSCameraController.MC.f_91074_.m_20186_();
        double delta = targetHeight - currentY;
        double stiffMult = 1.0 + Math.min(Math.abs(delta) / 48.0, 2.0);
        double dampMult = 1.0 + Math.min(Math.abs(delta) / 48.0, 2.0);
        double baseK = (Double)ReignOfNetherCommonConfigs.EXP_CAM_STIFFNESS.get();
        double baseD = (Double)ReignOfNetherCommonConfigs.EXP_CAM_DAMPING.get();
        double k = baseK * stiffMult;
        double d = baseD * dampMult;
        double accel = k * delta - d * verticalVelocity;
        accel = RTSCameraController.clamp(accel, -1.2, 1.2);
        double stepMaxUp = cfgMaxUp + speedXZ * 1.0;
        double stepMaxDown = cfgMaxDown + speedXZ * 0.6;
        double step = RTSCameraController.clamp(verticalVelocity += accel, -stepMaxDown, stepMaxUp);
        double slopeLimitUp = (Double)ReignOfNetherCommonConfigs.EXP_CAM_SLOPE_UP_PER_BLOCK.get() * speedXZ;
        double slopeLimitDown = (Double)ReignOfNetherCommonConfigs.EXP_CAM_SLOPE_DOWN_PER_BLOCK.get() * speedXZ;
        step = RTSCameraController.clamp(step, -slopeLimitDown, slopeLimitUp);
        if (Math.abs(step) > 0.001) {
            Vec3 move = new Vec3(0.0, step, 0.0);
            Vec3 bounded = CameraBounds.applyCameraBounds(RTSCameraController.MC.f_91074_.m_20182_(), move);
            Vec3 safe = CameraCollision.checkCameraCollision(RTSCameraController.MC.f_91074_.m_20182_(), bounded);
            RTSCameraController.MC.f_91074_.m_6478_(MoverType.SELF, safe);
        }
        if (smoothPanActive && smoothPanTicksLeft > 0) {
            float progress = 1.0f - (float)smoothPanTicksLeft / 30.0f;
            float[] posLerp = CameraTransitions.lerp2D(smoothPanStartX, smoothPanStartZ, smoothPanTargetX, smoothPanTargetZ, progress, smoothPanEasing);
            float deltaX = posLerp[0] - (float)RTSCameraController.MC.f_91074_.m_20185_();
            float deltaZ = posLerp[1] - (float)RTSCameraController.MC.f_91074_.m_20189_();
            Vec3 intended = new Vec3((double)deltaX, 0.0, (double)deltaZ);
            Vec3 safe = CameraCollision.checkCameraCollision(RTSCameraController.MC.f_91074_.m_20182_(), intended);
            RTSCameraController.MC.f_91074_.m_6478_(MoverType.SELF, safe);
            if (--smoothPanTicksLeft <= 0) {
                smoothPanActive = false;
            }
        }
        if (smoothZoomActive && smoothZoomTicksLeft > 0) {
            float progress = 1.0f - (float)smoothZoomTicksLeft / 15.0f;
            zoom = CameraTransitions.lerp(smoothZoomStart, smoothZoomTarget, progress, smoothZoomEasing);
            if (--smoothZoomTicksLeft <= 0) {
                smoothZoomActive = false;
            }
        }
        if (smoothRotActive && smoothRotTicksLeft > 0) {
            float progress = 1.0f - (float)smoothRotTicksLeft / 25.0f;
            float diff = RTSCameraController.wrapDegrees180(smoothRotTargetYaw - smoothRotStartYaw);
            yaw = smoothRotStartYaw + CameraTransitions.lerp(0.0f, diff, progress, smoothRotEasing);
            yaw = RTSCameraController.wrapDegrees360(yaw);
            if (--smoothRotTicksLeft <= 0) {
                smoothRotActive = false;
            }
        }
    }

    public static void updateOrthoviewY() {
        if (RTSCameraController.MC.f_91074_ == null) {
            return;
        }
        Vec3 pos = RTSCameraController.MC.f_91074_.m_20182_();
        Vec3 futurePos = pos.m_82520_(RTSCameraController.emaVel.f_82479_ * 2.0, 0.0, RTSCameraController.emaVel.f_82481_ * 2.0);
        double predictedHeight = TerrainFollowing.predictHeight(pos, emaVel);
        double optimalHeight = TerrainFollowing.calculateOptimalHeight(futurePos);
        double minimumHeight = TerrainFollowing.getMinimumHeight(futurePos);
        double base = emaVel.m_82556_() > 0.01 ? predictedHeight : optimalHeight;
        CameraManager.orthoviewPlayerBaseY = Math.max(base, minOrthoviewY);
        CameraManager.orthoviewPlayerMaxY = Math.max(minimumHeight + 60.0, CameraManager.orthoviewPlayerBaseY + 30.0);
    }

    public static void panCam(float x, float y, float z) {
        if (RTSCameraController.MC.f_91074_ == null) {
            return;
        }
        if (RTSCameraController.isCameraLocked()) {
            return;
        }
        Vec2 xz = MyMath.rotateCoords(x, z, RTSCameraController.getExternalCamRotX());
        float shakeX = CameraShake.getShakeX();
        float shakeY = CameraShake.getShakeY();
        float shakeZ = CameraShake.getShakeZ();
        Vec3 intended = new Vec3((double)(xz.f_82470_ + shakeX), (double)(y + shakeY), (double)(xz.f_82471_ + shakeZ));
        Vec3 bounded = CameraBounds.applyCameraBounds(RTSCameraController.MC.f_91074_.m_20182_(), intended);
        Vec3 safe = CameraCollision.checkCameraCollision(RTSCameraController.MC.f_91074_.m_20182_(), bounded);
        RTSCameraController.MC.f_91074_.m_6478_(MoverType.SELF, safe);
    }

    public static void zoomCam(float zoomAdj) {
        if (RTSCameraController.isCameraLocked()) {
            return;
        }
        float newZoom = zoom + zoomAdj;
        zoom = Math.max(10.0f, Math.min(90.0f, newZoom));
    }

    public static void smoothZoomCam(float zoomAdj) {
        float target = Math.max(10.0f, Math.min(90.0f, zoom + zoomAdj));
        RTSCameraController.smoothZoomTo(target, CameraTransitions.CameraMovementType.ZOOM);
    }

    public static void rotateCam(float x, float y) {
        if (RTSCameraController.isCameraLocked()) {
            return;
        }
        if ((yaw += x) >= 360.0f) {
            yaw -= 360.0f;
        }
        if (yaw <= -360.0f) {
            yaw += 360.0f;
        }
    }

    public static void setRotAdj(float adjYaw, float adjPitch) {
        yawAdj = adjYaw;
        pitchAdj = adjPitch;
    }

    public static void commitRotAdj() {
        RTSCameraController.rotateCam(yawAdj, pitchAdj);
        yawAdj = 0.0f;
        pitchAdj = 0.0f;
    }

    public static void applyRotationToPlayer() {
        if (RTSCameraController.MC.f_91074_ == null) {
            return;
        }
        RTSCameraController.MC.f_91074_.m_146926_(-(pitch + pitchAdj));
        RTSCameraController.MC.f_91074_.m_146922_(-(yaw + yawAdj));
    }

    public static float getExternalZoom() {
        return zoom;
    }

    public static float getExternalCamRotX() {
        return -(yaw + yawAdj);
    }

    public static float getExternalCamRotY() {
        return -(pitch + pitchAdj);
    }

    public static boolean isCameraLocked() {
        return cameraLocked || cameraLockTicksLeft > 0;
    }

    public static void lockCam() {
        cameraLocked = true;
    }

    public static void unlockCam() {
        cameraLocked = false;
    }

    public static void updateRotation() {
    }

    public static void smoothPanTo(float targetX, float targetZ, CameraTransitions.CameraMovementType movementType) {
        if (RTSCameraController.MC.f_91074_ == null) {
            return;
        }
        smoothPanActive = true;
        smoothPanTicksLeft = 30;
        smoothPanStartX = (float)RTSCameraController.MC.f_91074_.m_20185_();
        smoothPanStartZ = (float)RTSCameraController.MC.f_91074_.m_20189_();
        smoothPanTargetX = targetX;
        smoothPanTargetZ = targetZ;
        smoothPanEasing = CameraTransitions.getRecommendedEasing(movementType);
    }

    public static void smoothZoomTo(float targetZoom, CameraTransitions.CameraMovementType movementType) {
        smoothZoomActive = true;
        smoothZoomTicksLeft = 15;
        smoothZoomStart = zoom;
        smoothZoomTarget = Math.max(10.0f, Math.min(90.0f, targetZoom));
        smoothZoomEasing = CameraTransitions.getRecommendedEasing(movementType);
    }

    public static void smoothRotateTo(float targetRotX, CameraTransitions.CameraMovementType movementType) {
        float targetYaw = -targetRotX;
        smoothRotActive = true;
        smoothRotTicksLeft = 25;
        smoothRotStartYaw = yaw;
        smoothRotTargetYaw = targetYaw;
        smoothRotEasing = CameraTransitions.getRecommendedEasing(movementType);
    }

    public static void smoothCenterCameraOnPos(Vec3 pos, CameraTransitions.CameraMovementType movementType) {
        if (RTSCameraController.MC.f_91074_ == null) {
            return;
        }
        Vec2 XZRotated = MyMath.rotateCoords(0.0f, -20.0f, RTSCameraController.getExternalCamRotX());
        float offset = (float)(Math.sqrt(RTSCameraController.getExternalZoom()) / Math.sqrt(90.0));
        int yDiff = (int)(RTSCameraController.MC.f_91074_.m_20186_() - pos.f_82480_) - 40;
        Vec2 XZRotatedOffset = MyMath.rotateCoords(0.0f, -(offset * 35.0f) - (float)yDiff, RTSCameraController.getExternalCamRotX());
        float targetX = (float)(pos.f_82479_ + (double)XZRotated.f_82470_ + (double)XZRotatedOffset.f_82470_);
        float targetZ = (float)(pos.f_82481_ + (double)XZRotated.f_82471_ + (double)XZRotatedOffset.f_82471_);
        RTSCameraController.smoothPanTo(targetX, targetZ, movementType);
    }

    public static void smoothCenterCameraOnPos(BlockPos bp, CameraTransitions.CameraMovementType movementType) {
        RTSCameraController.smoothCenterCameraOnPos(new Vec3((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_()), movementType);
    }

    public static void centreCameraOnPos(BlockPos bp) {
        RTSCameraController.centreCameraOnPos(new Vec3((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_()));
    }

    public static void centreCameraOnPos(Vec3 pos) {
        if (RTSCameraController.MC.f_91074_ == null) {
            return;
        }
        Vec2 XZRotated = MyMath.rotateCoords(0.0f, -20.0f, RTSCameraController.getExternalCamRotX());
        float offset = (float)(Math.sqrt(RTSCameraController.getExternalZoom()) / Math.sqrt(90.0));
        int yDiff = (int)(RTSCameraController.MC.f_91074_.m_20186_() - pos.f_82480_) - 40;
        Vec2 XZRotatedOffset = MyMath.rotateCoords(0.0f, -(offset * 35.0f) - (float)yDiff, RTSCameraController.getExternalCamRotX());
        PlayerServerboundPacket.teleportPlayer(pos.f_82479_ + (double)XZRotated.f_82470_ + (double)XZRotatedOffset.f_82470_, RTSCameraController.MC.f_91074_.m_20186_(), pos.f_82481_ + (double)XZRotated.f_82471_ + (double)XZRotatedOffset.f_82471_);
    }

    public static void fixedRotateCam(boolean clockwise) {
        float step = clockwise ? 90.0f : -90.0f;
        RTSCameraController.smoothRotateTo(-(RTSCameraController.getExternalCamRotX() - step), CameraTransitions.CameraMovementType.ROTATION);
    }

    public static void forceMoveCam(int x, int z, int cameraLockTicks) {
        if (RTSCameraController.MC.f_91074_ == null) {
            return;
        }
        PlayerServerboundPacket.teleportPlayer(Double.valueOf(x), RTSCameraController.MC.f_91074_.m_20186_(), Double.valueOf(z));
        cameraLockTicksLeft = Math.max(cameraLockTicks, 0);
    }

    public static void forceMoveCam(Vec3i pos, int cameraLockTicks) {
        RTSCameraController.forceMoveCam(pos.m_123341_(), pos.m_123343_(), cameraLockTicks);
    }

    public static float getEdgeCamPanSensitivity() {
        return (float)(Math.sqrt(RTSCameraController.getExternalZoom()) / Math.sqrt(90.0)) * panSensitivityMult;
    }

    public static float getPanSensitivityMult() {
        return panSensitivityMult;
    }

    public static void adjustPanSensitivityMult(boolean increase) {
        if (increase && (float)Math.round(panSensitivityMult * 10.0f) < 30.0f) {
            panSensitivityMult += 0.1f;
        } else if (!increase && Math.round(panSensitivityMult * 10.0f) > 1) {
            panSensitivityMult -= 0.1f;
        }
    }

    public static void setMinOrthoviewY(double value) {
        minOrthoviewY = value;
        if (RTSCameraController.MC.f_91074_ != null && RTSCameraController.MC.f_91073_ != null && RTSCameraController.MC.f_91074_.m_20186_() < value + 15.0) {
            RTSCameraController.MC.f_91074_.m_6478_(MoverType.SELF, new Vec3(0.0, minOrthoviewY - RTSCameraController.MC.f_91074_.m_20186_() + 15.0, 0.0));
        }
    }

    public static void setTerrainFollowingSmooth(boolean enabled) {
        TerrainFollowing.setHeightTransitionsEnabled(enabled);
    }

    public static void updateCameraPosition(Vec3 newPos) {
        Vec3 delta = newPos.m_82546_(lastPos);
        emaVel = new Vec3(RTSCameraController.lerp(RTSCameraController.emaVel.f_82479_, delta.f_82479_, 0.25), RTSCameraController.lerp(RTSCameraController.emaVel.f_82480_, delta.f_82480_, 0.25), RTSCameraController.lerp(RTSCameraController.emaVel.f_82481_, delta.f_82481_, 0.25));
        lastPos = newPos;
    }

    public static Vec3 getEstimatedVelocity() {
        return emaVel;
    }

    private static double lerp(double a, double b, double alpha) {
        return a + (b - a) * alpha;
    }

    private static double clamp(double v, double min, double max) {
        return Math.max(min, Math.min(max, v));
    }

    private static float wrapDegrees360(float deg) {
        float out = deg % 360.0f;
        if (out < 0.0f) {
            out += 360.0f;
        }
        return out;
    }

    private static float wrapDegrees180(float deg) {
        float out = deg % 360.0f;
        if (out >= 180.0f) {
            out -= 360.0f;
        }
        if (out < -180.0f) {
            out += 360.0f;
        }
        return out;
    }
}

