/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.orthoview;

import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.fogofwar2.FogManager;
import com.solegendary.reignofnether.orthoview.CameraManager;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.orthoview.OrthoviewErrorHandler;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VisibilityCulling {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static double renderDistance = 200.0;
    private static double entityCullDistance = 150.0;
    private static double buildingCullDistance = 250.0;
    private static double particleCullDistance = 100.0;
    private static boolean enableDistanceCulling = true;
    private static boolean enableFrustumCulling = true;
    private static boolean enableFogOfWarCulling = true;
    private static boolean enableChunkCulling = true;
    private static boolean enableLevelOfDetail = true;
    private static boolean enableTerrainOcclusion = true;
    private static double highDetailDistance = 50.0;
    private static double mediumDetailDistance = 100.0;
    private static double lowDetailDistance = 150.0;
    private static final ConcurrentHashMap<ChunkPos, CullingData> chunkCullingCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, EntityCullingData> entityCullingCache = new ConcurrentHashMap();
    private static long lastCacheUpdate = 0L;
    private static final long CACHE_UPDATE_INTERVAL = 100L;
    private static CameraFrustum currentFrustum;
    private static OrthoBoxFrustum currentOrthoFrustum;
    private static long lastFrustumUpdate;
    private static final long FRUSTUM_UPDATE_INTERVAL = 50L;

    public static void updateCameraFrustum() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastFrustumUpdate < 50L) {
            return;
        }
        lastFrustumUpdate = currentTime;
        OrthoviewErrorHandler.safeExecute(() -> {
            if (VisibilityCulling.MC.f_91074_ == null || !OrthoviewClientEvents.isEnabled()) {
                currentFrustum = null;
                return;
            }
            Vec3 cameraPos = VisibilityCulling.MC.f_91074_.m_20182_();
            float zoom = CameraManager.getZoom();
            int winW = MC.m_91268_().m_85445_();
            int winH = MC.m_91268_().m_85446_();
            double halfHeight = Math.max(1.0, (double)zoom * 0.5);
            double halfWidth = halfHeight * ((double)winW / (double)Math.max(1, winH));
            double viewRadius = Math.max(renderDistance, Math.max(halfWidth, halfHeight));
            AABB viewBounds = new AABB(cameraPos.f_82479_ - viewRadius, cameraPos.f_82480_ - viewRadius, cameraPos.f_82481_ - viewRadius, cameraPos.f_82479_ + viewRadius, cameraPos.f_82480_ + viewRadius, cameraPos.f_82481_ + viewRadius);
            currentFrustum = new CameraFrustum(cameraPos, viewBounds, 1.0, renderDistance, CameraManager.getCamRotX(), CameraManager.getCamRotY());
            double pad = 2.0;
            currentOrthoFrustum = new OrthoBoxFrustum(cameraPos, CameraManager.getCamRotX(), halfWidth + pad, halfHeight + pad);
        }, OrthoviewErrorHandler.ErrorType.COORDINATE_CALCULATION_ERROR, "camera frustum update");
    }

    public static CullingResult checkEntityVisibility(Entity entity) {
        if (!(enableDistanceCulling || enableFrustumCulling || enableFogOfWarCulling)) {
            return CullingResult.VISIBLE_HIGH_DETAIL;
        }
        return OrthoviewErrorHandler.safeExecute(() -> {
            DetailLevel detailLevel;
            CullingResult result;
            if (VisibilityCulling.MC.f_91074_ == null || entity == null) {
                return CullingResult.CULLED_OTHER;
            }
            int entityId = entity.m_19879_();
            EntityCullingData cached = entityCullingCache.get(entityId);
            if (cached != null && !cached.isExpired()) {
                return cached.result;
            }
            Vec3 entityPos = entity.m_20182_();
            Vec3 cameraPos = VisibilityCulling.MC.f_91074_.m_20182_();
            double distance = cameraPos.m_82554_(entityPos);
            if (enableDistanceCulling && distance > entityCullDistance) {
                EntityCullingData cullingData = new EntityCullingData(CullingResult.CULLED_DISTANCE, DetailLevel.MINIMAL);
                entityCullingCache.put(entityId, cullingData);
                return CullingResult.CULLED_DISTANCE;
            }
            if (enableFrustumCulling && currentOrthoFrustum != null && !currentOrthoFrustum.containsPoint(entityPos)) {
                EntityCullingData cullingData = new EntityCullingData(CullingResult.CULLED_FRUSTUM, DetailLevel.MINIMAL);
                entityCullingCache.put(entityId, cullingData);
                return CullingResult.CULLED_FRUSTUM;
            }
            if (enableTerrainOcclusion && VisibilityCulling.isOccludedByTerrain(VisibilityCulling.MC.f_91074_.m_20182_(), entityPos)) {
                EntityCullingData cullingData = new EntityCullingData(CullingResult.CULLED_OTHER, DetailLevel.MINIMAL);
                entityCullingCache.put(entityId, cullingData);
                return CullingResult.CULLED_OTHER;
            }
            if (enableFogOfWarCulling && !FogManager.isEntityVisible(entity)) {
                EntityCullingData cullingData = new EntityCullingData(CullingResult.CULLED_FOG_OF_WAR, DetailLevel.MINIMAL);
                entityCullingCache.put(entityId, cullingData);
                return CullingResult.CULLED_FOG_OF_WAR;
            }
            if (distance <= highDetailDistance) {
                result = CullingResult.VISIBLE_HIGH_DETAIL;
                detailLevel = DetailLevel.HIGH;
            } else if (distance <= mediumDetailDistance) {
                result = CullingResult.VISIBLE_MEDIUM_DETAIL;
                detailLevel = DetailLevel.MEDIUM;
            } else {
                result = CullingResult.VISIBLE_LOW_DETAIL;
                detailLevel = DetailLevel.LOW;
            }
            EntityCullingData cullingData = new EntityCullingData(result, detailLevel);
            entityCullingCache.put(entityId, cullingData);
            return result;
        }, CullingResult.VISIBLE_HIGH_DETAIL, OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "entity visibility check");
    }

    public static CullingResult checkBuildingVisibility(BuildingPlacement building) {
        if (!(enableDistanceCulling || enableFrustumCulling || enableFogOfWarCulling)) {
            return CullingResult.VISIBLE_HIGH_DETAIL;
        }
        return OrthoviewErrorHandler.safeExecute(() -> {
            if (VisibilityCulling.MC.f_91074_ == null || building == null) {
                return CullingResult.CULLED_OTHER;
            }
            Vec3 cameraPos = VisibilityCulling.MC.f_91074_.m_20182_();
            Vec3 buildingCenter = Vec3.m_82512_((Vec3i)building.centrePos);
            double distance = cameraPos.m_82554_(buildingCenter);
            if (enableDistanceCulling && distance > buildingCullDistance) {
                return CullingResult.CULLED_DISTANCE;
            }
            AABB buildingBounds = new AABB((double)building.minCorner.m_123341_(), (double)building.minCorner.m_123342_(), (double)building.minCorner.m_123343_(), (double)(building.maxCorner.m_123341_() + 1), (double)(building.maxCorner.m_123342_() + 1), (double)(building.maxCorner.m_123343_() + 1));
            if (enableFrustumCulling && currentOrthoFrustum != null && !currentOrthoFrustum.intersectsAABB(buildingBounds)) {
                return CullingResult.CULLED_FRUSTUM;
            }
            if (enableTerrainOcclusion && VisibilityCulling.isOccludedByTerrain(cameraPos, buildingCenter)) {
                return CullingResult.CULLED_OTHER;
            }
            if (enableFogOfWarCulling) {
                BlockPos[] samplePositions = new BlockPos[]{building.centrePos, building.minCorner, building.maxCorner, new BlockPos((building.minCorner.m_123341_() + building.maxCorner.m_123341_()) / 2, building.minCorner.m_123342_(), (building.minCorner.m_123343_() + building.maxCorner.m_123343_()) / 2)};
                boolean anyVisible = false;
                for (BlockPos pos : samplePositions) {
                    float brightness = FogManager.getPositionBrightness(pos);
                    if (!(brightness > 0.35f)) continue;
                    anyVisible = true;
                    break;
                }
                if (!anyVisible) {
                    return CullingResult.CULLED_FOG_OF_WAR;
                }
            }
            if (distance <= highDetailDistance) {
                return CullingResult.VISIBLE_HIGH_DETAIL;
            }
            if (distance <= mediumDetailDistance) {
                return CullingResult.VISIBLE_MEDIUM_DETAIL;
            }
            return CullingResult.VISIBLE_LOW_DETAIL;
        }, CullingResult.VISIBLE_HIGH_DETAIL, OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "building visibility check");
    }

    private static boolean isOccludedByTerrain(Vec3 from, Vec3 to) {
        if (VisibilityCulling.MC.f_91073_ == null) {
            return false;
        }
        Vec3 dir = to.m_82546_(from);
        double distXZ = Math.hypot(dir.f_82479_, dir.f_82481_);
        if (distXZ < 8.0) {
            return false;
        }
        int steps = (int)Math.min(96.0, Math.max(8.0, distXZ / 2.0));
        double buffer = 1.25;
        for (int i = 1; i < steps; ++i) {
            int sz;
            double t = (double)i / (double)steps;
            Vec3 p = from.m_82549_(dir.m_82490_(t));
            int sx = (int)Math.floor(p.f_82479_);
            int topY = MiscUtil.getHighestNonAirBlock((Level)VisibilityCulling.MC.f_91073_, new BlockPos(sx, 0, sz = (int)Math.floor(p.f_82481_)), false).m_123342_();
            if (!((double)topY > p.f_82480_ - buffer)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldRenderChunk(ChunkPos chunkPos) {
        if (!enableChunkCulling) {
            return true;
        }
        return OrthoviewErrorHandler.safeExecute(() -> {
            Vec3 chunkCenter;
            if (VisibilityCulling.MC.f_91074_ == null) {
                return false;
            }
            CullingData cached = chunkCullingCache.get(chunkPos);
            if (cached != null && !cached.isExpired()) {
                return cached.visible;
            }
            Vec3 cameraPos = VisibilityCulling.MC.f_91074_.m_20182_();
            double distance = cameraPos.m_82554_(chunkCenter = new Vec3((double)chunkPos.m_151390_(), cameraPos.f_82480_, (double)chunkPos.m_151393_()));
            boolean visible = distance <= renderDistance;
            DetailLevel detailLevel = VisibilityCulling.getDetailLevelForDistance(distance);
            CullingData cullingData = new CullingData(visible, distance, detailLevel);
            chunkCullingCache.put(chunkPos, cullingData);
            return visible;
        }, true, OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "chunk visibility check");
    }

    public static DetailLevel getDetailLevelForDistance(double distance) {
        if (distance <= highDetailDistance) {
            return DetailLevel.HIGH;
        }
        if (distance <= mediumDetailDistance) {
            return DetailLevel.MEDIUM;
        }
        if (distance <= lowDetailDistance) {
            return DetailLevel.LOW;
        }
        return DetailLevel.MINIMAL;
    }

    public static boolean shouldRenderParticles(Vec3 particlePos) {
        if (!enableDistanceCulling) {
            return true;
        }
        return OrthoviewErrorHandler.safeExecute(() -> {
            if (VisibilityCulling.MC.f_91074_ == null) {
                return false;
            }
            double distance = VisibilityCulling.MC.f_91074_.m_20182_().m_82554_(particlePos);
            return distance <= particleCullDistance;
        }, true, OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "particle visibility check");
    }

    public static void updateCulling() {
        long currentTime = System.currentTimeMillis();
        VisibilityCulling.updateCameraFrustum();
        if (currentTime - lastCacheUpdate > 100L) {
            VisibilityCulling.cleanupCache();
            lastCacheUpdate = currentTime;
        }
    }

    private static void cleanupCache() {
        chunkCullingCache.entrySet().removeIf(entry -> ((CullingData)entry.getValue()).isExpired());
        entityCullingCache.entrySet().removeIf(entry -> ((EntityCullingData)entry.getValue()).isExpired());
        if (chunkCullingCache.size() > 1000) {
            chunkCullingCache.clear();
        }
        if (entityCullingCache.size() > 2000) {
            entityCullingCache.clear();
        }
    }

    public static void clearCache() {
        chunkCullingCache.clear();
        entityCullingCache.clear();
        currentFrustum = null;
    }

    public static String getCullingStatistics() {
        return String.format("Visibility Culling: %d chunks cached, %d entities cached, Distances: Entity=%.0f, Building=%.0f, Render=%.0f", chunkCullingCache.size(), entityCullingCache.size(), entityCullDistance, buildingCullDistance, renderDistance);
    }

    public static void setRenderDistance(double distance) {
        renderDistance = Math.max(50.0, Math.min(500.0, distance));
        VisibilityCulling.clearCache();
    }

    public static void setEntityCullDistance(double distance) {
        entityCullDistance = Math.max(20.0, Math.min(300.0, distance));
        VisibilityCulling.clearCache();
    }

    public static void setBuildingCullDistance(double distance) {
        buildingCullDistance = Math.max(50.0, Math.min(400.0, distance));
        VisibilityCulling.clearCache();
    }

    public static void setParticleCullDistance(double distance) {
        particleCullDistance = Math.max(20.0, Math.min(200.0, distance));
    }

    public static void setDistanceCullingEnabled(boolean enabled) {
        enableDistanceCulling = enabled;
        if (!enabled) {
            VisibilityCulling.clearCache();
        }
    }

    public static void setFrustumCullingEnabled(boolean enabled) {
        enableFrustumCulling = enabled;
        if (!enabled) {
            VisibilityCulling.clearCache();
        }
    }

    public static void setFogOfWarCullingEnabled(boolean enabled) {
        enableFogOfWarCulling = enabled;
        if (!enabled) {
            VisibilityCulling.clearCache();
        }
    }

    public static void setChunkCullingEnabled(boolean enabled) {
        enableChunkCulling = enabled;
        if (!enabled) {
            VisibilityCulling.clearCache();
        }
    }

    public static void setLevelOfDetailEnabled(boolean enabled) {
        enableLevelOfDetail = enabled;
        if (!enabled) {
            VisibilityCulling.clearCache();
        }
    }

    public static void setTerrainOcclusionEnabled(boolean enabled) {
        enableTerrainOcclusion = enabled;
        if (!enabled) {
            VisibilityCulling.clearCache();
        }
    }

    public static void setDetailDistances(double high, double medium, double low) {
        highDetailDistance = Math.max(10.0, high);
        mediumDetailDistance = Math.max(highDetailDistance, medium);
        lowDetailDistance = Math.max(mediumDetailDistance, low);
        VisibilityCulling.clearCache();
    }

    public static boolean isCullingEnabled() {
        return enableDistanceCulling || enableFrustumCulling || enableFogOfWarCulling || enableChunkCulling;
    }

    public static double getRenderDistance() {
        return renderDistance;
    }

    public static int getVisibleChunkCount() {
        return (int)chunkCullingCache.values().stream().filter(data -> data.visible).count();
    }

    public static List<ChunkPos> getVisibleChunks() {
        return OrthoviewErrorHandler.safeExecute(() -> {
            ArrayList<ChunkPos> visibleChunks = new ArrayList<ChunkPos>();
            for (Map.Entry<ChunkPos, CullingData> entry : chunkCullingCache.entrySet()) {
                if (!entry.getValue().visible || entry.getValue().isExpired()) continue;
                visibleChunks.add(entry.getKey());
            }
            return visibleChunks;
        }, new ArrayList(), OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "visible chunks list");
    }

    public static boolean shouldRenderAnyBuildings() {
        return OrthoviewErrorHandler.safeExecute(() -> {
            if (!VisibilityCulling.isCullingEnabled()) {
                return true;
            }
            for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
                CullingResult result = VisibilityCulling.checkBuildingVisibility(building);
                if (result == CullingResult.CULLED_DISTANCE || result == CullingResult.CULLED_FRUSTUM || result == CullingResult.CULLED_FOG_OF_WAR) continue;
                return true;
            }
            return false;
        }, true, OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "building render check");
    }

    public static List<BuildingRenderInfo> getVisibleBuildings() {
        return OrthoviewErrorHandler.safeExecute(() -> {
            ArrayList<BuildingRenderInfo> visibleBuildings = new ArrayList<BuildingRenderInfo>();
            for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
                CullingResult result = VisibilityCulling.checkBuildingVisibility(building);
                if (result == CullingResult.CULLED_DISTANCE || result == CullingResult.CULLED_FRUSTUM || result == CullingResult.CULLED_FOG_OF_WAR || result == CullingResult.CULLED_OTHER) continue;
                DetailLevel detail = VisibilityCulling.getDetailLevelFromCullingResult(result);
                visibleBuildings.add(new BuildingRenderInfo(building, detail, result));
            }
            return visibleBuildings;
        }, new ArrayList(), OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "visible buildings list");
    }

    public static List<EntityRenderInfo> getVisibleEntities(List<Entity> entities) {
        return OrthoviewErrorHandler.safeExecute(() -> {
            ArrayList<EntityRenderInfo> visibleEntities = new ArrayList<EntityRenderInfo>();
            for (Entity entity : entities) {
                CullingResult result = VisibilityCulling.checkEntityVisibility(entity);
                if (result == CullingResult.CULLED_DISTANCE || result == CullingResult.CULLED_FRUSTUM || result == CullingResult.CULLED_FOG_OF_WAR || result == CullingResult.CULLED_OTHER) continue;
                DetailLevel detail = VisibilityCulling.getDetailLevelFromCullingResult(result);
                visibleEntities.add(new EntityRenderInfo(entity, detail, result));
            }
            return visibleEntities;
        }, new ArrayList(), OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "visible entities list");
    }

    private static DetailLevel getDetailLevelFromCullingResult(CullingResult result) {
        switch (result) {
            case VISIBLE_HIGH_DETAIL: {
                return DetailLevel.HIGH;
            }
            case VISIBLE_MEDIUM_DETAIL: {
                return DetailLevel.MEDIUM;
            }
            case VISIBLE_LOW_DETAIL: {
                return DetailLevel.LOW;
            }
        }
        return DetailLevel.MINIMAL;
    }

    public static boolean shouldRenderObject(Vec3 position, double objectRadius) {
        return OrthoviewErrorHandler.safeExecute(() -> {
            BlockPos blockPos;
            float brightness;
            AABB objectBounds;
            double distance;
            if (!VisibilityCulling.isCullingEnabled() || VisibilityCulling.MC.f_91074_ == null) {
                return true;
            }
            if (enableDistanceCulling && (distance = VisibilityCulling.MC.f_91074_.m_20182_().m_82554_(position)) > renderDistance + objectRadius) {
                return false;
            }
            if (enableFrustumCulling && currentFrustum != null && !currentFrustum.isInFrustum(objectBounds = new AABB(position.f_82479_ - objectRadius, position.f_82480_ - objectRadius, position.f_82481_ - objectRadius, position.f_82479_ + objectRadius, position.f_82480_ + objectRadius, position.f_82481_ + objectRadius))) {
                return false;
            }
            if (enableFogOfWarCulling && (brightness = FogManager.getPositionBrightness(blockPos = new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_))) <= 0.1f) {
                return false;
            }
            return true;
        }, true, OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "object visibility check");
    }

    public static Map<ChunkPos, Boolean> shouldRenderChunks(List<ChunkPos> chunks) {
        return OrthoviewErrorHandler.safeExecute(() -> {
            HashMap<ChunkPos, Boolean> results = new HashMap<ChunkPos, Boolean>();
            for (ChunkPos chunk : chunks) {
                results.put(chunk, VisibilityCulling.shouldRenderChunk(chunk));
            }
            return results;
        }, new HashMap(), OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "batch chunk visibility check");
    }

    public static CullingStatistics getCullingPerformanceStats() {
        return OrthoviewErrorHandler.safeExecute(() -> {
            int visibleChunks = VisibilityCulling.getVisibleChunkCount();
            int totalCachedChunks = chunkCullingCache.size();
            int totalCachedEntities = entityCullingCache.size();
            long totalChecks = totalCachedEntities + totalCachedChunks;
            double cacheEfficiency = totalChecks > 0L ? (double)(totalCachedChunks + totalCachedEntities) / (double)totalChecks : 0.0;
            return new CullingStatistics(visibleChunks, totalCachedChunks, totalCachedEntities, cacheEfficiency, renderDistance, VisibilityCulling.isCullingEnabled(), enableDistanceCulling, enableFrustumCulling, enableFogOfWarCulling, enableChunkCulling, enableLevelOfDetail);
        }, new CullingStatistics(), OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "culling statistics");
    }

    public static void forceRefreshAllCaches() {
        OrthoviewErrorHandler.safeExecute(() -> {
            chunkCullingCache.clear();
            entityCullingCache.clear();
            currentFrustum = null;
            VisibilityCulling.updateCameraFrustum();
        }, OrthoviewErrorHandler.ErrorType.RENDERING_ERROR, "cache refresh");
    }

    static {
        lastFrustumUpdate = 0L;
    }

    public static enum CullingResult {
        VISIBLE_HIGH_DETAIL,
        VISIBLE_MEDIUM_DETAIL,
        VISIBLE_LOW_DETAIL,
        CULLED_DISTANCE,
        CULLED_FRUSTUM,
        CULLED_FOG_OF_WAR,
        CULLED_CHUNK,
        CULLED_OTHER;

    }

    public static enum DetailLevel {
        HIGH,
        MEDIUM,
        LOW,
        MINIMAL;

    }

    private static class CameraFrustum {
        final Vec3 cameraPos;
        final AABB viewBounds;
        final double nearPlane;
        final double farPlane;
        final float cameraRotX;
        final float cameraRotY;

        CameraFrustum(Vec3 cameraPos, AABB bounds, double near, double far, float rotX, float rotY) {
            this.cameraPos = cameraPos;
            this.viewBounds = bounds;
            this.nearPlane = near;
            this.farPlane = far;
            this.cameraRotX = rotX;
            this.cameraRotY = rotY;
        }

        boolean isInFrustum(Vec3 position) {
            return this.viewBounds.m_82390_(position);
        }

        boolean isInFrustum(AABB boundingBox) {
            return this.viewBounds.m_82381_(boundingBox);
        }
    }

    public static class CullingStatistics {
        public final int visibleChunks;
        public final int cachedChunks;
        public final int cachedEntities;
        public final double cacheEfficiency;
        public final double renderDistance;
        public final boolean cullingEnabled;
        public final boolean distanceCulling;
        public final boolean frustumCulling;
        public final boolean fogOfWarCulling;
        public final boolean chunkCulling;
        public final boolean levelOfDetail;

        public CullingStatistics() {
            this(0, 0, 0, 0.0, 0.0, false, false, false, false, false, false);
        }

        public CullingStatistics(int visibleChunks, int cachedChunks, int cachedEntities, double cacheEfficiency, double renderDistance, boolean cullingEnabled, boolean distanceCulling, boolean frustumCulling, boolean fogOfWarCulling, boolean chunkCulling, boolean levelOfDetail) {
            this.visibleChunks = visibleChunks;
            this.cachedChunks = cachedChunks;
            this.cachedEntities = cachedEntities;
            this.cacheEfficiency = cacheEfficiency;
            this.renderDistance = renderDistance;
            this.cullingEnabled = cullingEnabled;
            this.distanceCulling = distanceCulling;
            this.frustumCulling = frustumCulling;
            this.fogOfWarCulling = fogOfWarCulling;
            this.chunkCulling = chunkCulling;
            this.levelOfDetail = levelOfDetail;
        }

        public String toString() {
            return String.format("CullingStats{visible=%d, cached=%d/%d, efficiency=%.1f%%, distance=%.0f, enabled=%s}", this.visibleChunks, this.cachedChunks, this.cachedEntities, this.cacheEfficiency * 100.0, this.renderDistance, this.cullingEnabled);
        }
    }

    public static class EntityRenderInfo {
        public final Entity entity;
        public final DetailLevel detailLevel;
        public final CullingResult cullingResult;

        public EntityRenderInfo(Entity entity, DetailLevel detail, CullingResult result) {
            this.entity = entity;
            this.detailLevel = detail;
            this.cullingResult = result;
        }
    }

    public static class BuildingRenderInfo {
        public final BuildingPlacement building;
        public final DetailLevel detailLevel;
        public final CullingResult cullingResult;

        public BuildingRenderInfo(BuildingPlacement building, DetailLevel detail, CullingResult result) {
            this.building = building;
            this.detailLevel = detail;
            this.cullingResult = result;
        }
    }

    private static class CullingData {
        final boolean visible;
        final double distanceFromCamera;
        final DetailLevel detailLevel;
        final long timestamp;

        CullingData(boolean visible, double distance, DetailLevel detail) {
            this.visible = visible;
            this.distanceFromCamera = distance;
            this.detailLevel = detail;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 100L;
        }
    }

    private static class EntityCullingData {
        final CullingResult result;
        final DetailLevel detailLevel;
        final long timestamp;

        EntityCullingData(CullingResult result, DetailLevel detail) {
            this.result = result;
            this.detailLevel = detail;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 100L;
        }
    }

    private static class OrthoBoxFrustum {
        final Vec3 center;
        final Vec3 axisForward;
        final Vec3 axisRight;
        final double halfWidth;
        final double halfHeight;

        OrthoBoxFrustum(Vec3 center, float yawDegrees, double halfWidth, double halfHeight) {
            this.center = center;
            double yawRad = Math.toRadians(yawDegrees);
            this.axisForward = new Vec3(-Math.sin(yawRad), 0.0, Math.cos(yawRad));
            this.axisRight = new Vec3(this.axisForward.f_82481_, 0.0, -this.axisForward.f_82479_);
            this.halfWidth = halfWidth;
            this.halfHeight = halfHeight;
        }

        boolean containsPoint(Vec3 p) {
            Vec3 d = p.m_82546_(this.center);
            double u = d.m_82526_(this.axisRight);
            double v = d.m_82526_(this.axisForward);
            return Math.abs(u) <= this.halfWidth && Math.abs(v) <= this.halfHeight;
        }

        boolean intersectsAABB(AABB box) {
            for (double x : new double[]{box.f_82288_, box.f_82291_}) {
                for (double z : new double[]{box.f_82290_, box.f_82293_}) {
                    if (!this.containsPoint(new Vec3(x, this.center.f_82480_, z))) continue;
                    return true;
                }
            }
            return this.containsPoint(new Vec3((box.f_82288_ + box.f_82291_) * 0.5, this.center.f_82480_, (box.f_82290_ + box.f_82293_) * 0.5));
        }
    }
}

