/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.player;

import com.solegendary.reignofnether.player.PlayerAction;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.util.Faction;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PlayerClientboundPacket {
    PlayerAction playerAction;
    String playerName;
    Long value;
    Faction faction;

    public static void enableRTSStatus(String playerName, Faction faction) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PlayerClientboundPacket(PlayerAction.ENABLE_RTS, playerName, 0L, faction));
    }

    public static void disableRTSStatus(String playerName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PlayerClientboundPacket(PlayerAction.DISABLE_RTS, playerName, 0L, Faction.NONE));
    }

    public static void defeat(String playerName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PlayerClientboundPacket(PlayerAction.DEFEAT, playerName, 0L, Faction.NONE));
    }

    public static void victory(String playerName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PlayerClientboundPacket(PlayerAction.VICTORY, playerName, 0L, Faction.NONE));
    }

    public static void resetRTS(boolean hard) {
        if (hard) {
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PlayerClientboundPacket(PlayerAction.RESET_RTS_HARD, "", 0L, Faction.NONE));
        } else {
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PlayerClientboundPacket(PlayerAction.RESET_RTS, "", 0L, Faction.NONE));
        }
    }

    public static void syncRtsGameTime(Long rtsGameTicks) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PlayerClientboundPacket(PlayerAction.SYNC_RTS_GAME_TIME, "", rtsGameTicks, Faction.NONE));
    }

    public static void lockRTS(String playerName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PlayerClientboundPacket(PlayerAction.LOCK_RTS, playerName, 0L, Faction.NONE));
    }

    public static void unlockRTS(String playerName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PlayerClientboundPacket(PlayerAction.UNLOCK_RTS, playerName, 0L, Faction.NONE));
    }

    public static void disableStartRTS(String playerName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PlayerClientboundPacket(PlayerAction.DISABLE_START_RTS, playerName, 0L, Faction.NONE));
    }

    public static void enableStartRTS(String playerName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PlayerClientboundPacket(PlayerAction.ENABLE_START_RTS, playerName, 0L, Faction.NONE));
    }

    public static void syncBeaconOwnerTicks(String playerName, long ticks) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PlayerClientboundPacket(PlayerAction.SYNC_BEACON_OWNER_TICKS, playerName, ticks, Faction.NONE));
    }

    public PlayerClientboundPacket(PlayerAction playerAction, String playerName, Long value, Faction faction) {
        this.playerAction = playerAction;
        this.playerName = playerName;
        this.value = value;
        this.faction = faction;
    }

    public PlayerClientboundPacket(FriendlyByteBuf buffer) {
        this.playerAction = (PlayerAction)buffer.m_130066_(PlayerAction.class);
        this.playerName = buffer.m_130277_();
        this.value = buffer.readLong();
        this.faction = (Faction)buffer.m_130066_(Faction.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.playerAction);
        buffer.m_130070_(this.playerName);
        buffer.writeLong(this.value.longValue());
        buffer.m_130068_((Enum)this.faction);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            switch (this.playerAction) {
                case DEFEAT: {
                    PlayerClientEvents.defeat(this.playerName);
                    break;
                }
                case VICTORY: {
                    PlayerClientEvents.victory(this.playerName);
                    break;
                }
                case DISABLE_RTS: {
                    PlayerClientEvents.disableRTS(this.playerName);
                    break;
                }
                case ENABLE_RTS: {
                    PlayerClientEvents.enableRTS(this.playerName, this.faction);
                    break;
                }
                case RESET_RTS: {
                    PlayerClientEvents.resetRTS(false);
                    break;
                }
                case RESET_RTS_HARD: {
                    PlayerClientEvents.resetRTS(true);
                    break;
                }
                case SYNC_RTS_GAME_TIME: {
                    PlayerClientEvents.syncRtsGameTime(this.value);
                    break;
                }
                case LOCK_RTS: {
                    PlayerClientEvents.setRTSLock(true);
                    break;
                }
                case UNLOCK_RTS: {
                    PlayerClientEvents.setRTSLock(false);
                    break;
                }
                case ENABLE_START_RTS: {
                    PlayerClientEvents.setCanStartRTS(true);
                    break;
                }
                case DISABLE_START_RTS: {
                    PlayerClientEvents.setCanStartRTS(false);
                    break;
                }
                case SYNC_BEACON_OWNER_TICKS: {
                    PlayerClientEvents.syncBeaconOwnerTicks(this.playerName, this.value);
                }
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

