/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.player;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.gamemode.ClientGameModeHelper;
import com.solegendary.reignofnether.gamemode.GameModeServerboundPacket;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.player.PlayerAction;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.startpos.StartPosServerEvents;
import com.solegendary.reignofnether.util.Faction;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class PlayerServerboundPacket {
    PlayerAction action;
    public int playerId;
    public double x;
    public double y;
    public double z;
    public ResourceLocation factionId;

    public static void teleportPlayer(Double x, Double y, Double z) {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ != null) {
            PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(PlayerAction.TELEPORT, MC.f_91074_.m_19879_(), x, y, z));
        }
    }

    public static void startRTS(ResourceLocation factionId, Double x, Double y, Double z) {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ != null && MC.f_91073_ != null) {
            BlockState bs = MC.f_91073_.m_8055_(new BlockPos(x.intValue(), y.intValue(), z.intValue()));
            if (!bs.m_60819_().m_76178_()) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"hud.reignofnether.invalid_start_location", (Object[])new Object[0]));
                return;
            }
            PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(PlayerAction.START_RTS_FACTION, MC.f_91074_.m_19879_(), x, y, z, factionId));
            GameModeServerboundPacket.setAndLockAllClientGameModes(ClientGameModeHelper.gameMode);
        }
    }

    public static void enableOrthoview() {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ != null) {
            PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(PlayerAction.ENABLE_ORTHOVIEW, MC.f_91074_.m_19879_(), 0.0, 0.0, 0.0));
        }
    }

    public static void disableOrthoview() {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ != null) {
            PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(PlayerAction.DISABLE_ORTHOVIEW, MC.f_91074_.m_19879_(), 0.0, 0.0, 0.0));
        }
    }

    public static void startRTS(Faction faction, Double x, Double y, Double z) {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ != null && MC.f_91073_ != null) {
            BlockState bs = MC.f_91073_.m_8055_(new BlockPos(x.intValue(), y.intValue(), z.intValue()));
            if (!bs.m_60819_().m_76178_() && faction != Faction.NONE) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"hud.reignofnether.invalid_start_location", (Object[])new Object[0]));
                return;
            }
            PlayerAction playerAction = switch (faction) {
                default -> throw new IncompatibleClassChangeError();
                case Faction.VILLAGERS -> PlayerAction.START_RTS_VILLAGERS;
                case Faction.MONSTERS -> PlayerAction.START_RTS_MONSTERS;
                case Faction.PIGLINS -> PlayerAction.START_RTS_PIGLINS;
                case Faction.NONE -> PlayerAction.START_RTS_SANDBOX;
            };
            PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(playerAction, MC.f_91074_.m_19879_(), x, y, z));
            GameModeServerboundPacket.setAndLockAllClientGameModes(ClientGameModeHelper.gameMode);
        }
    }

    public static void startRTSEveryone() {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ != null && MC.f_91073_ != null) {
            GameModeServerboundPacket.setAndLockAllClientGameModes(ClientGameModeHelper.gameMode);
            PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(PlayerAction.START_RTS_EVERYONE, MC.f_91074_.m_19879_(), 0.0, 0.0, 0.0));
        }
    }

    public static void cancelStartRTSEveryone() {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ != null && MC.f_91073_ != null) {
            PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(PlayerAction.CANCEL_START_RTS_EVERYONE, MC.f_91074_.m_19879_(), 0.0, 0.0, 0.0));
        }
    }

    public static void resetRTS() {
        PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(PlayerAction.RESET_RTS, -1, 0.0, 0.0, 0.0));
    }

    public static void resetRTSHard() {
        PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(PlayerAction.RESET_RTS_HARD, -1, 0.0, 0.0, 0.0));
    }

    public static void surrender() {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ != null) {
            PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(PlayerAction.DEFEAT, MC.f_91074_.m_19879_(), 0.0, 0.0, 0.0));
        }
    }

    public static void lockRTS() {
        PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(PlayerAction.LOCK_RTS, -1, 0.0, 0.0, 0.0));
    }

    public static void unlockRTS() {
        PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(PlayerAction.UNLOCK_RTS, -1, 0.0, 0.0, 0.0));
    }

    public static void enableRTSSyncing() {
        PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(PlayerAction.ENABLE_RTS_SYNCING, -1, 0.0, 0.0, 0.0));
    }

    public static void disableRTSSyncing() {
        PacketHandler.INSTANCE.sendToServer((Object)new PlayerServerboundPacket(PlayerAction.DISABLE_RTS_SYNCING, -1, 0.0, 0.0, 0.0));
    }

    public PlayerServerboundPacket(PlayerAction action, int playerId, Double x, Double y, Double z) {
        this.action = action;
        this.playerId = playerId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PlayerServerboundPacket(PlayerAction action, int playerId, Double x, Double y, Double z, ResourceLocation factionId) {
        this.action = action;
        this.playerId = playerId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.factionId = factionId;
    }

    public PlayerServerboundPacket(FriendlyByteBuf buffer) {
        this.action = (PlayerAction)buffer.m_130066_(PlayerAction.class);
        this.playerId = buffer.readInt();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        if (this.action == PlayerAction.START_RTS_FACTION) {
            this.factionId = buffer.m_130281_();
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.writeInt(this.playerId);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        if (this.action == PlayerAction.START_RTS_FACTION) {
            buffer.m_130085_(this.factionId);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                ReignOfNether.LOGGER.warn("PlayerServerboundPacket: Sender was null");
                success.set(false);
                return;
            }
            if (this.playerId != -1 && player.m_19879_() != this.playerId) {
                ReignOfNether.LOGGER.warn("PlayerServerboundPacket: Tried to process packet from " + String.valueOf(player.m_7755_()) + " for id: " + this.playerId);
                success.set(false);
                return;
            }
            switch (this.action) {
                case TELEPORT: {
                    PlayerServerEvents.movePlayer(this.playerId, this.x, this.y, this.z);
                    break;
                }
                case ENABLE_ORTHOVIEW: {
                    PlayerServerEvents.enableOrthoview(this.playerId);
                    break;
                }
                case DISABLE_ORTHOVIEW: {
                    PlayerServerEvents.disableOrthoview(this.playerId);
                    break;
                }
                case START_RTS_VILLAGERS: {
                    PlayerServerEvents.startRTS(this.playerId, new Vec3(this.x, this.y, this.z), Faction.VILLAGERS);
                    break;
                }
                case START_RTS_MONSTERS: {
                    PlayerServerEvents.startRTS(this.playerId, new Vec3(this.x, this.y, this.z), Faction.MONSTERS);
                    break;
                }
                case START_RTS_PIGLINS: {
                    PlayerServerEvents.startRTS(this.playerId, new Vec3(this.x, this.y, this.z), Faction.PIGLINS);
                    break;
                }
                case START_RTS_FACTION: {
                    PlayerServerEvents.startRTS(this.playerId, new Vec3(this.x, this.y, this.z), this.factionId);
                    break;
                }
                case START_RTS_SANDBOX: {
                    PlayerServerEvents.startRTS(this.playerId, new Vec3(this.x, this.y, this.z), Faction.NONE);
                    break;
                }
                case START_RTS_EVERYONE: {
                    StartPosServerEvents.startGameCountdown();
                    break;
                }
                case CANCEL_START_RTS_EVERYONE: {
                    StartPosServerEvents.cancelStartGameCountdown(false);
                    break;
                }
                case DEFEAT: {
                    PlayerServerEvents.defeat(this.playerId, Component.m_237115_((String)"server.reignofnether.surrendered").getString());
                    break;
                }
                case RESET_RTS: {
                    PlayerServerEvents.resetRTS(false);
                    break;
                }
                case RESET_RTS_HARD: {
                    PlayerServerEvents.resetRTS(true);
                    break;
                }
                case LOCK_RTS: {
                    PlayerServerEvents.setRTSLock(true);
                    break;
                }
                case UNLOCK_RTS: {
                    PlayerServerEvents.setRTSLock(false);
                    break;
                }
                case ENABLE_RTS_SYNCING: {
                    PlayerServerEvents.setRTSSyncingEnabled(true);
                    break;
                }
                case DISABLE_RTS_SYNCING: {
                    PlayerServerEvents.setRTSSyncingEnabled(false);
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

