/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.player;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.player.RTSPlayer;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;

public class RTSPlayerSaveData
extends SavedData {
    public final ArrayList<RTSPlayer> rtsPlayers = new ArrayList();

    private static RTSPlayerSaveData create() {
        return new RTSPlayerSaveData();
    }

    @Nonnull
    public static RTSPlayerSaveData getInstance(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return RTSPlayerSaveData.create();
        }
        return (RTSPlayerSaveData)server.m_129783_().m_8895_().m_164861_(RTSPlayerSaveData::load, RTSPlayerSaveData::create, "saved-rtsplayer-data");
    }

    public static RTSPlayerSaveData load(CompoundTag tag) {
        ReignOfNether.LOGGER.info("RTSPlayerSaveData.load");
        RTSPlayerSaveData data = RTSPlayerSaveData.create();
        ListTag ltag = (ListTag)tag.m_128423_("rtsplayers");
        if (ltag != null) {
            for (Tag ctag : ltag) {
                CompoundTag ptag = (CompoundTag)ctag;
                String name = ptag.m_128461_("name");
                int id = ptag.m_128451_("id");
                int ticksWithoutCapitol = ptag.m_128451_("ticksWithoutCapitol");
                int beaconOwnerTicks = ptag.m_128451_("beaconOwnerTicks");
                Faction faction = Faction.valueOf(ptag.m_128461_("faction"));
                ResourceLocation customFactionId = null;
                if (ptag.m_128441_("customFactionId")) {
                    try {
                        customFactionId = new ResourceLocation(ptag.m_128461_("customFactionId"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (customFactionId != null) {
                    data.rtsPlayers.add(RTSPlayer.getFromSaveCustom(name, id, ticksWithoutCapitol, faction, beaconOwnerTicks, customFactionId));
                } else {
                    data.rtsPlayers.add(RTSPlayer.getFromSave(name, id, ticksWithoutCapitol, faction, beaconOwnerTicks));
                }
                ReignOfNether.LOGGER.info("RTSPlayerSaveData.load: " + name + "|" + id + "|" + String.valueOf((Object)faction));
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.rtsPlayers.forEach(p -> {
            CompoundTag cTag = new CompoundTag();
            cTag.m_128359_("name", p.name);
            cTag.m_128405_("id", p.id);
            cTag.m_128405_("ticksWithoutCapitol", p.ticksWithoutCapitol);
            cTag.m_128405_("beaconOwnerTicks", p.beaconOwnerTicks);
            cTag.m_128359_("faction", p.faction.name());
            if (p.customFactionId != null) {
                cTag.m_128359_("customFactionId", p.customFactionId.toString());
            }
            list.add((Object)cTag);
        });
        tag.m_128365_("rtsplayers", (Tag)list);
        return tag;
    }

    public void save() {
        this.m_77762_();
    }
}

