/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.research.ResearchClientboundPacket;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ResearchServerboundPacket {
    public String playerName;
    public String itemName;
    public boolean add;
    public boolean isCheat;
    public int value;

    public static void addCheat(String playerName, String itemName) {
        PacketHandler.INSTANCE.sendToServer((Object)new ResearchServerboundPacket(playerName, itemName, true, true, 0));
    }

    public static void removeCheat(String playerName, String itemName) {
        PacketHandler.INSTANCE.sendToServer((Object)new ResearchServerboundPacket(playerName, itemName, false, true, 0));
    }

    public ResearchServerboundPacket(String playerName, String itemName, boolean add, boolean isCheat, int value) {
        this.playerName = playerName;
        this.itemName = itemName;
        this.add = add;
        this.isCheat = isCheat;
        this.value = value;
    }

    public ResearchServerboundPacket(FriendlyByteBuf buffer) {
        this.playerName = buffer.m_130277_();
        this.itemName = buffer.m_130277_();
        this.add = buffer.readBoolean();
        this.isCheat = buffer.readBoolean();
        this.value = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.playerName);
        buffer.m_130070_(this.itemName);
        buffer.writeBoolean(this.add);
        buffer.writeBoolean(this.isCheat);
        buffer.writeInt(this.value);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                ReignOfNether.LOGGER.warn("ResearchServerboundPacket (cheats): Sender was null");
                success.set(false);
                return;
            }
            if (!player.m_7755_().getString().equals(this.playerName)) {
                ReignOfNether.LOGGER.warn("ResearchServerboundPacket (cheats): Tried to process packet from " + String.valueOf(player.m_7755_()) + " for id: " + this.playerName);
                success.set(false);
                return;
            }
            if (this.isCheat) {
                if (!player.m_20310_(4)) {
                    ReignOfNether.LOGGER.warn("ResearchServerboundPacket (cheats): Tried to process packet from " + String.valueOf(player.m_7755_()) + " with insufficient permissions");
                    success.set(false);
                    return;
                }
                if (this.add) {
                    ResearchServerEvents.addCheat(this.playerName, this.itemName);
                    ResearchClientboundPacket.addCheat(this.playerName, this.itemName);
                } else {
                    ResearchServerEvents.removeCheat(this.playerName, this.itemName);
                    ResearchClientboundPacket.removeCheat(this.playerName, this.itemName);
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

