/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research.researchItems;

import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.buildings.villagers.Library;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ResearchGrandLibrary
extends ProductionItem {
    public static final String itemName = "Grand Library";
    public static final ResourceCost cost = ResourceCosts.RESEARCH_GRAND_LIBRARY;

    public ResearchGrandLibrary() {
        super(cost);
        this.onComplete = (level, placement) -> {
            if (placement.getBuilding() instanceof Library) {
                placement.changeStructure("library_grand");
            }
        };
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    @Override
    public Button getStartButton(ProductionPlacement prodBuilding, Keybinding hotkey) {
        return new Button(itemName, 14, new ResourceLocation("minecraft", "textures/block/bookshelf.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), hotkey, () -> false, () -> ProductionItems.RESEARCH_GRAND_LIBRARY.itemIsBeingProducedAt(prodBuilding) || prodBuilding.getBuilding() instanceof Library && prodBuilding.getUpgradeLevel() > 0, () -> true, () -> BuildingServerboundPacket.startProduction(prodBuilding.originPos, ProductionItems.RESEARCH_GRAND_LIBRARY), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.grand_library", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.grand_library.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    @Override
    public Button getCancelButton(ProductionPlacement prodBuilding, boolean first) {
        return new Button(itemName, 14, new ResourceLocation("minecraft", "textures/block/bookshelf.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), null, () -> false, () -> false, () -> true, () -> BuildingServerboundPacket.cancelProduction(prodBuilding.minCorner, ProductionItems.RESEARCH_GRAND_LIBRARY, first), null, null);
    }
}

