/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.resources;

import com.solegendary.reignofnether.config.ResourceBlockConfig;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigurableResourceSources {
    private static List<ResourceSource> generatedResourceSources = new ArrayList<ResourceSource>();
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        ConfigurableResourceSources.generateResourceSources();
        initialized = true;
    }

    public static void reload() {
        generatedResourceSources.clear();
        ConfigurableResourceSources.generateResourceSources();
    }

    private static void generateResourceSources() {
        Map<String, ResourceBlockConfig.ResourceBlockEntry> allConfigs = ResourceBlockConfig.getAllConfigs();
        Map<String, List<ResourceBlockConfig.ResourceBlockEntry>> groupedConfigs = ConfigurableResourceSources.groupConfigsByResourceType(allConfigs);
        for (Map.Entry<String, List<ResourceBlockConfig.ResourceBlockEntry>> group : groupedConfigs.entrySet()) {
            ResourceSource resourceSource;
            List<ResourceBlockConfig.ResourceBlockEntry> configs = group.getValue();
            if (configs.isEmpty() || (resourceSource = ConfigurableResourceSources.createResourceSourceFromConfigs(configs)) == null) continue;
            generatedResourceSources.add(resourceSource);
        }
    }

    private static Map<String, List<ResourceBlockConfig.ResourceBlockEntry>> groupConfigsByResourceType(Map<String, ResourceBlockConfig.ResourceBlockEntry> allConfigs) {
        HashMap<String, List<ResourceBlockConfig.ResourceBlockEntry>> grouped = new HashMap<String, List<ResourceBlockConfig.ResourceBlockEntry>>();
        for (ResourceBlockConfig.ResourceBlockEntry config : allConfigs.values()) {
            if (!config.enabled) continue;
            String groupKey = config.resourceType.toString() + "_" + config.resourceValue + "_" + config.gatherTicks;
            grouped.computeIfAbsent(groupKey, k -> new ArrayList()).add(config);
        }
        return grouped;
    }

    private static ResourceSource createResourceSourceFromConfigs(List<ResourceBlockConfig.ResourceBlockEntry> configs) {
        if (configs.isEmpty()) {
            return null;
        }
        ResourceBlockConfig.ResourceBlockEntry template = configs.get(0);
        ArrayList<Block> blocks = new ArrayList<Block>();
        ArrayList<Item> items = new ArrayList<Item>();
        for (ResourceBlockConfig.ResourceBlockEntry config : configs) {
            Block block = config.getBlock();
            if (block == null || block == Blocks.f_50016_) continue;
            blocks.add(block);
            Item item = block.m_5456_();
            if (item == null || item == Items.f_41852_) continue;
            items.add(item);
        }
        if (blocks.isEmpty()) {
            return null;
        }
        String sourceName = ConfigurableResourceSources.createSourceName(template.resourceType, blocks);
        Predicate<BlockState> blockStateTest = ConfigurableResourceSources.createBlockStatePredicate(blocks, template.resourceType);
        return new ResourceSource(sourceName, blocks, items, template.gatherTicks, template.resourceValue, template.resourceType, blockStateTest);
    }

    private static String createSourceName(ResourceName resourceType, List<Block> blocks) {
        if (blocks.size() == 1) {
            Block block = blocks.get(0);
            String blockName = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
            return ConfigurableResourceSources.capitalizeFirst(blockName.replace("_", " "));
        }
        return switch (resourceType) {
            case ResourceName.WOOD -> "Configurable Wood Sources";
            case ResourceName.FOOD -> "Configurable Food Sources";
            case ResourceName.ORE -> "Configurable Ore Sources";
            default -> "Configurable Resource Sources";
        };
    }

    private static Predicate<BlockState> createBlockStatePredicate(List<Block> blocks, ResourceName resourceType) {
        return blockState -> {
            Block block = blockState.m_60734_();
            if (!blocks.contains(block)) {
                return false;
            }
            return switch (resourceType) {
                case ResourceName.FOOD -> ConfigurableResourceSources.isMatureCrop(blockState);
                case ResourceName.WOOD -> ConfigurableResourceSources.isValidWoodSource(blockState);
                case ResourceName.ORE -> ConfigurableResourceSources.isValidOreSource(blockState);
                default -> true;
            };
        };
    }

    private static boolean isMatureCrop(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (blockState.m_61138_((Property)BlockStateProperties.f_61409_)) {
            return (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61409_) == 7;
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61407_)) {
            return (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61407_) == 3;
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61406_)) {
            return (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61406_) == 2;
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61405_)) {
            return (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61405_) == 1;
        }
        if (block == Blocks.f_50685_) {
            return blockState.m_61138_((Property)BlockStateProperties.f_61407_) && (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61407_) >= 2;
        }
        return true;
    }

    private static boolean isValidWoodSource(BlockState blockState) {
        Block block = blockState.m_60734_();
        return !block.m_7705_().contains("sapling") && !block.m_7705_().contains("leaves");
    }

    private static boolean isValidOreSource(BlockState blockState) {
        return true;
    }

    private static String capitalizeFirst(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static List<ResourceSource> getResourceSources() {
        if (!initialized) {
            ConfigurableResourceSources.initialize();
        }
        return new ArrayList<ResourceSource>(generatedResourceSources);
    }

    public static List<ResourceSource> getResourceSourcesByType(ResourceName resourceType) {
        return ConfigurableResourceSources.getResourceSources().stream().filter(source -> source.resourceName == resourceType).toList();
    }

    public static boolean isResourceBlock(Block block) {
        return ResourceBlockConfig.hasConfig(block);
    }

    public static ResourceBlockConfig.ResourceBlockEntry getResourceInfo(Block block) {
        return ResourceBlockConfig.getConfig(block);
    }

    public static ResourceSource findResourceSourceForBlock(Block block) {
        if (!initialized) {
            ConfigurableResourceSources.initialize();
        }
        for (ResourceSource source : generatedResourceSources) {
            if (!source.validBlocks.contains(block)) continue;
            return source;
        }
        return null;
    }

    public static Map<String, Object> getSourceStatistics() {
        if (!initialized) {
            ConfigurableResourceSources.initialize();
        }
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("total_sources", generatedResourceSources.size());
        int totalBlocks = 0;
        HashMap<ResourceName, Integer> resourceTypeCounts = new HashMap<ResourceName, Integer>();
        for (ResourceSource source : generatedResourceSources) {
            totalBlocks += source.validBlocks.size();
            resourceTypeCounts.merge(source.resourceName, source.validBlocks.size(), Integer::sum);
        }
        stats.put("total_blocks", totalBlocks);
        stats.put("wood_blocks", resourceTypeCounts.getOrDefault((Object)ResourceName.WOOD, 0));
        stats.put("food_blocks", resourceTypeCounts.getOrDefault((Object)ResourceName.FOOD, 0));
        stats.put("ore_blocks", resourceTypeCounts.getOrDefault((Object)ResourceName.ORE, 0));
        return stats;
    }
}

