/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.resources;

import com.solegendary.reignofnether.config.ResourceCostConfigEntry;
import java.util.HashMap;

public class ResourceCost {
    public static final HashMap<String, ResourceCost> ENTRIES = new HashMap();
    public static final int TICKS_PER_SECOND = 20;
    public int food;
    public int wood;
    public int ore;
    public int ticks;
    public int population;
    public String id;

    private ResourceCost(int food, int wood, int ore, int seconds, int population) {
        this.food = food;
        this.wood = wood;
        this.ore = ore;
        this.ticks = seconds * 20;
        this.population = population;
    }

    public ResourceCost(String modid, String id) {
        this.id = modid + "." + id;
        ENTRIES.put(this.id, this);
    }

    public static ResourceCost Unit(int food, int wood, int ore, int seconds, int population) {
        return new ResourceCost(food, wood, ore, seconds, population);
    }

    public static ResourceCost Research(int food, int wood, int ore, int seconds) {
        return new ResourceCost(food, wood, ore, seconds, 0);
    }

    public static ResourceCost Building(int food, int wood, int ore, int supply) {
        return new ResourceCost(food, wood, ore, 0, supply);
    }

    public static ResourceCost Enchantment(int food, int wood, int ore) {
        return new ResourceCost(food, wood, ore, 0, 0);
    }

    public void bakeValues(ResourceCostConfigEntry rcce) {
        this.food = rcce.getFood();
        this.wood = rcce.getWood();
        this.ore = rcce.getOre();
        this.ticks = rcce.getSeconds() * 20;
        this.population = rcce.getPopulation();
    }
}

