/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.resources.dynamic;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceType;
import com.solegendary.reignofnether.resources.dynamic.ResourceCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;

public class DynamicResourceRegistry {
    private static final Map<ResourceLocation, DynamicResourceType> RESOURCES = new ConcurrentHashMap<ResourceLocation, DynamicResourceType>();
    private static final Map<Item, DynamicResourceType> RESOURCES_BY_ITEM = new ConcurrentHashMap<Item, DynamicResourceType>();
    private static final Map<ResourceLocation, List<DynamicResourceType>> RESOURCES_BY_FACTION = new ConcurrentHashMap<ResourceLocation, List<DynamicResourceType>>();
    private static final Map<ResourceCategory, List<DynamicResourceType>> RESOURCES_BY_CATEGORY = new ConcurrentHashMap<ResourceCategory, List<DynamicResourceType>>();
    private static final List<DynamicResourceType> RESOURCE_LIST = new ArrayList<DynamicResourceType>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DynamicResourceType register(DynamicResourceType resourceType) {
        if (resourceType == null) {
            throw new IllegalArgumentException("DynamicResourceType cannot be null");
        }
        ResourceLocation id = resourceType.getId();
        if (RESOURCES.containsKey(id)) {
            ReignOfNether.LOGGER.warn("Resource {} is already registered, skipping duplicate registration", (Object)id);
            return RESOURCES.get(id);
        }
        RESOURCES.put(id, resourceType);
        RESOURCES_BY_ITEM.put(resourceType.getItem(), resourceType);
        if (resourceType.getFaction() != null) {
            RESOURCES_BY_FACTION.computeIfAbsent(resourceType.getFaction().getId(), k -> new ArrayList()).add(resourceType);
        }
        RESOURCES_BY_CATEGORY.computeIfAbsent(resourceType.getCategory(), k -> new ArrayList()).add(resourceType);
        List<DynamicResourceType> list = RESOURCE_LIST;
        synchronized (list) {
            RESOURCE_LIST.add(resourceType);
        }
        ReignOfNether.LOGGER.info("Registered resource: {} ({}) for faction {} in category {}", (Object)resourceType.getDisplayName(), (Object)id, (Object)(resourceType.getFaction() != null ? resourceType.getFaction().getDisplayName() : "None"), (Object)resourceType.getCategory().getDisplayName());
        return resourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DynamicResourceType registerOrUpdate(DynamicResourceType resourceType) {
        if (resourceType == null) {
            throw new IllegalArgumentException("DynamicResourceType cannot be null");
        }
        ResourceLocation id = resourceType.getId();
        DynamicResourceType existing = RESOURCES.get(id);
        if (existing != null) {
            List<DynamicResourceType> categoryResources;
            List<DynamicResourceType> factionResources;
            RESOURCES_BY_ITEM.remove(existing.getItem());
            if (existing.getFaction() != null && (factionResources = RESOURCES_BY_FACTION.get(existing.getFaction().getId())) != null) {
                factionResources.remove(existing);
            }
            if ((categoryResources = RESOURCES_BY_CATEGORY.get((Object)existing.getCategory())) != null) {
                categoryResources.remove(existing);
            }
            List<DynamicResourceType> list = RESOURCE_LIST;
            synchronized (list) {
                RESOURCE_LIST.remove(existing);
            }
            ReignOfNether.LOGGER.info("Updating existing resource: {} ({})", (Object)resourceType.getDisplayName(), (Object)id);
        } else {
            ReignOfNether.LOGGER.info("Registering new resource: {} ({})", (Object)resourceType.getDisplayName(), (Object)id);
        }
        RESOURCES.put(id, resourceType);
        RESOURCES_BY_ITEM.put(resourceType.getItem(), resourceType);
        if (resourceType.getFaction() != null) {
            RESOURCES_BY_FACTION.computeIfAbsent(resourceType.getFaction().getId(), k -> new ArrayList()).add(resourceType);
        }
        RESOURCES_BY_CATEGORY.computeIfAbsent(resourceType.getCategory(), k -> new ArrayList()).add(resourceType);
        List<DynamicResourceType> list = RESOURCE_LIST;
        synchronized (list) {
            RESOURCE_LIST.add(resourceType);
        }
        return resourceType;
    }

    public static DynamicResourceType getResourceType(ResourceLocation id) {
        return RESOURCES.get(id);
    }

    public static DynamicResourceType getResourceType(Item item) {
        return RESOURCES_BY_ITEM.get(item);
    }

    public static DynamicResourceType getResourceType(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return null;
        }
        return DynamicResourceRegistry.getResourceType(itemStack.m_41720_());
    }

    public static List<DynamicResourceType> getResourcesForFaction(FactionType faction) {
        if (faction == null) {
            return new ArrayList<DynamicResourceType>();
        }
        return new ArrayList<DynamicResourceType>(RESOURCES_BY_FACTION.getOrDefault(faction.getId(), Collections.emptyList()));
    }

    public static List<DynamicResourceType> getResourcesForFaction(ResourceLocation factionId) {
        return new ArrayList<DynamicResourceType>(RESOURCES_BY_FACTION.getOrDefault(factionId, Collections.emptyList()));
    }

    public static List<DynamicResourceType> getResourcesByCategory(ResourceCategory category) {
        return new ArrayList<DynamicResourceType>(RESOURCES_BY_CATEGORY.getOrDefault((Object)category, Collections.emptyList()));
    }

    public static List<DynamicResourceType> getAllResources() {
        return new ArrayList<DynamicResourceType>(RESOURCE_LIST);
    }

    public static Set<ResourceLocation> getAllResourceIds() {
        return new HashSet<ResourceLocation>(RESOURCES.keySet());
    }

    public static List<DynamicResourceType> getResourcesByFactionAndCategory(FactionType faction, ResourceCategory category) {
        List<DynamicResourceType> factionResources = DynamicResourceRegistry.getResourcesForFaction(faction);
        return factionResources.stream().filter(resource -> resource.getCategory() == category).collect(Collectors.toList());
    }

    public static List<DynamicResourceType> getTradeableResources() {
        return RESOURCE_LIST.stream().filter(resource -> resource.getProperties().isTradeable()).collect(Collectors.toList());
    }

    public static List<DynamicResourceType> getRenewableResources() {
        return RESOURCE_LIST.stream().filter(resource -> resource.getProperties().isRenewable()).collect(Collectors.toList());
    }

    public static List<DynamicResourceType> getWorkerBasedResources() {
        return RESOURCE_LIST.stream().filter(resource -> resource.getProperties().requiresWorkers()).collect(Collectors.toList());
    }

    public static List<DynamicResourceType> getVisibleResources() {
        return RESOURCE_LIST.stream().filter(resource -> resource.getProperties().isVisibleToEnemies()).collect(Collectors.toList());
    }

    public static boolean isRegistered(ResourceLocation id) {
        return RESOURCES.containsKey(id);
    }

    public static boolean isResource(Item item) {
        return RESOURCES_BY_ITEM.containsKey(item);
    }

    public static boolean isResource(ItemStack itemStack) {
        return !itemStack.m_41619_() && DynamicResourceRegistry.isResource(itemStack.m_41720_());
    }

    public static Set<ResourceCategory> getActiveCategories() {
        return new HashSet<ResourceCategory>(RESOURCES_BY_CATEGORY.keySet());
    }

    public static Set<ResourceLocation> getFactionsWithResources() {
        return new HashSet<ResourceLocation>(RESOURCES_BY_FACTION.keySet());
    }

    public static int getResourceCount(FactionType faction) {
        return DynamicResourceRegistry.getResourcesForFaction(faction).size();
    }

    public static int getTotalResourceValue(FactionType faction) {
        return DynamicResourceRegistry.getResourcesForFaction(faction).stream().mapToInt(resource -> resource.getProperties().getBaseValue()).sum();
    }

    public static synchronized void clear() {
        RESOURCES.clear();
        RESOURCES_BY_ITEM.clear();
        RESOURCES_BY_FACTION.clear();
        RESOURCES_BY_CATEGORY.clear();
        RESOURCE_LIST.clear();
    }

    public static class ResourceRegistrationEvent
    extends Event {
        public DynamicResourceType registerResource(DynamicResourceType resourceType) {
            return DynamicResourceRegistry.register(resourceType);
        }
    }
}

