/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.restoration;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class OreRestorationData {
    private final List<OreRecord> oreRecords = new ArrayList<OreRecord>();

    public void addOreRecord(BlockPos pos, BlockState blockState, String reason) {
        if (this.oreRecords.stream().anyMatch(record -> record.pos.equals((Object)pos))) {
            return;
        }
        this.oreRecords.add(new OreRecord(pos, blockState, reason));
    }

    public List<OreRecord> getOreRecords() {
        return new ArrayList<OreRecord>(this.oreRecords);
    }

    public OreRecord findOreRecord(BlockPos pos, String reason) {
        return this.oreRecords.stream().filter(record -> record.pos.equals((Object)pos) && record.reason.equals(reason)).findFirst().orElse(null);
    }

    public boolean removeOreRecord(BlockPos pos, String reason) {
        return this.oreRecords.removeIf(record -> record.pos.equals((Object)pos) && record.reason.equals(reason));
    }

    public void clearAll() {
        this.oreRecords.clear();
    }

    public int getCount() {
        return this.oreRecords.size();
    }

    public int getCountByReason(String reason) {
        return (int)this.oreRecords.stream().filter(record -> record.reason.equals(reason)).count();
    }

    public void removeRecordsInArea(BlockPos min, BlockPos max) {
        this.oreRecords.removeIf(record -> {
            BlockPos pos = record.pos;
            return pos.m_123341_() >= min.m_123341_() && pos.m_123341_() <= max.m_123341_() && pos.m_123342_() >= min.m_123342_() && pos.m_123342_() <= max.m_123342_() && pos.m_123343_() >= min.m_123343_() && pos.m_123343_() <= max.m_123343_();
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag recordList = new ListTag();
        for (OreRecord record : this.oreRecords) {
            recordList.add((Object)record.serializeNBT());
        }
        tag.m_128365_("ore_records", (Tag)recordList);
        tag.m_128405_("version", 1);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.oreRecords.clear();
        if (!tag.m_128425_("ore_records", 9)) {
            return;
        }
        ListTag recordList = tag.m_128437_("ore_records", 10);
        for (int i = 0; i < recordList.size(); ++i) {
            CompoundTag recordTag = recordList.m_128728_(i);
            OreRecord record = OreRecord.deserializeNBT(recordTag);
            if (record == null) continue;
            this.oreRecords.add(record);
        }
    }

    public static class OreRecord {
        public final BlockPos pos;
        public final BlockState originalBlockState;
        public final String reason;

        public OreRecord(BlockPos pos, BlockState originalBlockState, String reason) {
            this.pos = pos;
            this.originalBlockState = originalBlockState;
            this.reason = reason;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", this.pos.m_123341_());
            tag.m_128405_("y", this.pos.m_123342_());
            tag.m_128405_("z", this.pos.m_123343_());
            tag.m_128359_("block", ForgeRegistries.BLOCKS.getKey((Object)this.originalBlockState.m_60734_()).toString());
            tag.m_128359_("reason", this.reason);
            CompoundTag stateTag = new CompoundTag();
            this.originalBlockState.m_61148_().forEach((property, value) -> stateTag.m_128359_(property.m_61708_(), value.toString()));
            tag.m_128365_("state_properties", (Tag)stateTag);
            return tag;
        }

        public static OreRecord deserializeNBT(CompoundTag tag) {
            BlockPos pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
            String blockId = tag.m_128461_("block");
            String reason = tag.m_128461_("reason");
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
            if (block == null) {
                return null;
            }
            BlockState blockState = block.m_49966_();
            if (tag.m_128425_("state_properties", 10)) {
                CompoundTag compoundTag = tag.m_128469_("state_properties");
            }
            return new OreRecord(pos, blockState, reason);
        }
    }
}

