/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.restoration;

import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.nether.NetherBlocks;
import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.restoration.OreRestorationData;
import com.solegendary.reignofnether.restoration.OreRestorationSaveData;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class OreRestorationManager {
    public static boolean isTrackableOre(BlockState blockState) {
        Block block = blockState.m_60734_();
        return ResourceSources.getAllOreBlocks().stream().anyMatch(oreSource -> oreSource.validBlocks.contains(block));
    }

    public static void trackMinedOre(ServerLevel level, BlockPos pos, BlockState oreBlockState) {
        if (!OreRestorationManager.isTrackableOre(oreBlockState)) {
            System.out.println("[OreRestoration] Block " + oreBlockState.m_60734_().m_49954_().getString() + " is not trackable");
            return;
        }
        System.out.println("[OreRestoration] Tracking mined ore: " + oreBlockState.m_60734_().m_49954_().getString() + " at " + String.valueOf(pos));
        OreRestorationSaveData saveData = OreRestorationSaveData.get(level);
        saveData.getOreData().addOreRecord(pos, oreBlockState, "mined");
        saveData.markDirty();
    }

    public static void trackNetherConvertedOre(ServerLevel level, BlockPos pos, BlockState originalOreBlockState) {
        if (!OreRestorationManager.isTrackableOre(originalOreBlockState)) {
            return;
        }
        OreRestorationSaveData saveData = OreRestorationSaveData.get(level);
        saveData.getOreData().addOreRecord(pos, originalOreBlockState, "nether_converted");
        saveData.markDirty();
    }

    public static BlockState getOriginalOreForNetherOre(BlockState netherOreState) {
        Block netherBlock = netherOreState.m_60734_();
        for (Map.Entry<Block, List<Block>> entry : NetherBlocks.MAPPINGS.entrySet()) {
            if (entry.getKey() != netherBlock) continue;
            for (Block overworldBlock : entry.getValue()) {
                if (!OreRestorationManager.isTrackableOre(overworldBlock.m_49966_())) continue;
                return overworldBlock.m_49966_();
            }
        }
        return null;
    }

    public static void restoreAllOres(ServerLevel level) {
        OreRestorationSaveData saveData = OreRestorationSaveData.get(level);
        OreRestorationData oreData = saveData.getOreData();
        System.out.println("[OreRestoration] Starting restoration. Total tracked records: " + oreData.getCount());
        int restoredCount = 0;
        int skippedCount = 0;
        for (OreRestorationData.OreRecord record : oreData.getOreRecords()) {
            System.out.println("[OreRestoration] Processing record: " + record.originalBlockState.m_60734_().m_49954_().getString() + " at " + String.valueOf(record.pos) + " (reason: " + record.reason + ")");
            if (OreRestorationManager.canRestoreOreAt(level, record.pos)) {
                level.m_46597_(record.pos, record.originalBlockState);
                System.out.println("[OreRestoration] Restored " + record.originalBlockState.m_60734_().m_49954_().getString() + " at " + String.valueOf(record.pos));
                ++restoredCount;
                continue;
            }
            System.out.println("[OreRestoration] Skipped restoration at " + String.valueOf(record.pos) + " - blocked by building/structure");
            ++skippedCount;
        }
        oreData.clearAll();
        saveData.markDirty();
        System.out.println("[OreRestoration] Restored " + restoredCount + " ore blocks, skipped " + skippedCount + " (blocked by buildings/structures)");
    }

    private static boolean canRestoreOreAt(ServerLevel level, BlockPos pos) {
        boolean canRestore;
        if (BuildingUtils.isPosInsideAnyBuilding(false, pos)) {
            System.out.println("[OreRestoration] Blocked by building at " + String.valueOf(pos));
            return false;
        }
        BlockState currentState = level.m_8055_(pos);
        Block currentBlock = currentState.m_60734_();
        boolean bl = canRestore = currentBlock == Blocks.f_50016_ || currentBlock == Blocks.f_50493_ || currentBlock == Blocks.f_50069_ || currentBlock == Blocks.f_50652_ || currentBlock == Blocks.f_152551_ || currentBlock == BlockRegistrar.WALKABLE_MAGMA_BLOCK.get() || currentBlock == Blocks.f_50134_ || currentBlock == Blocks.f_50136_ || currentBlock == Blocks.f_50135_ || NetherBlocks.isNetherBlock((Level)level, pos);
        if (!canRestore) {
            System.out.println("[OreRestoration] Blocked by unsupported block: " + currentBlock.m_49954_().getString() + " at " + String.valueOf(pos));
        }
        return canRestore;
    }

    public static String getTrackingStats(ServerLevel level) {
        OreRestorationSaveData saveData = OreRestorationSaveData.get(level);
        OreRestorationData oreData = saveData.getOreData();
        int totalCount = oreData.getCount();
        int minedCount = oreData.getCountByReason("mined");
        int convertedCount = oreData.getCountByReason("nether_converted");
        return String.format("Tracking %d ore blocks (%d mined, %d nether-converted)", totalCount, minedCount, convertedCount);
    }

    public static void removeOreRecord(ServerLevel level, BlockPos pos, String reason) {
        OreRestorationSaveData saveData = OreRestorationSaveData.get(level);
        if (saveData.getOreData().removeOreRecord(pos, reason)) {
            saveData.markDirty();
        }
    }

    public static void clearAllTracking(ServerLevel level) {
        OreRestorationSaveData saveData = OreRestorationSaveData.get(level);
        saveData.getOreData().clearAll();
        saveData.markDirty();
    }
}

