/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.sandbox;

import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.sandbox.SandboxAction;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.sandbox.SandboxServerboundPacket;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class SandboxActionButtons {
    private static final Minecraft MC = Minecraft.m_91087_();
    public static Button setAnchor;
    public static Button resetToAnchor;
    public static Button removeAnchor;

    private static boolean neutralUnitsSelected() {
        for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
            Unit unit;
            if (!(entity instanceof Unit) || (unit = (Unit)entity).getOwnerName().isBlank()) continue;
            return false;
        }
        return true;
    }

    private static boolean selectedUnitsHaveAnchor() {
        for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
            Unit unit;
            if (!(entity instanceof Unit) || (unit = (Unit)entity).getAnchor() == null || unit.getAnchor().equals((Object)new BlockPos(0, 0, 0))) continue;
            return true;
        }
        return false;
    }

    private static Relationship getRelationshipToHudSelectedUnit() {
        if (SandboxActionButtons.MC.f_91074_ != null && HudClientEvents.hudSelectedEntity != null) {
            return UnitClientEvents.getPlayerToEntityRelationship(HudClientEvents.hudSelectedEntity);
        }
        return Relationship.NEUTRAL;
    }

    public static void updateButtons() {
        setAnchor = new Button("Set Anchor", Button.itemIconSize, new ResourceLocation("minecraft", "textures/block/respawn_anchor_side4.png"), Keybindings.keyQ, () -> CursorClientEvents.getLeftClickSandboxAction() == SandboxAction.SET_ANCHOR, () -> !SandboxClientEvents.isSandboxPlayer(), () -> true, () -> CursorClientEvents.setLeftClickSandboxAction(SandboxAction.SET_ANCHOR), null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.actionbuttons.reignofnether.set_anchor", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"hud.actionbuttons.reignofnether.set_anchor.tooltip1", (Object[])new Object[0]))));
        resetToAnchor = new Button("Reset to Anchor", Button.itemIconSize, new ResourceLocation("minecraft", "textures/block/respawn_anchor_top_off.png"), Keybindings.keyW, () -> CursorClientEvents.getLeftClickSandboxAction() == SandboxAction.RESET_TO_ANCHOR, () -> !SandboxClientEvents.isSandboxPlayer(), () -> SandboxActionButtons.selectedUnitsHaveAnchor(), () -> {
            LivingEntity entity;
            if (!UnitClientEvents.getSelectedUnits().isEmpty() && (entity = UnitClientEvents.getSelectedUnits().get(0)) instanceof Unit) {
                Unit unit = (Unit)entity;
                SandboxServerboundPacket.resetToAnchor(entity.m_19879_());
                Unit.fullResetBehaviours(unit);
            }
        }, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.actionbuttons.reignofnether.reset_to_anchor", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"hud.actionbuttons.reignofnether.reset_to_anchor.tooltip1", (Object[])new Object[0]))));
        removeAnchor = new Button("Remove Anchor", Button.itemIconSize, new ResourceLocation("reignofnether", "textures/icons/items/barrier.png"), Keybindings.keyE, () -> CursorClientEvents.getLeftClickSandboxAction() == SandboxAction.REMOVE_ANCHOR, () -> !SandboxClientEvents.isSandboxPlayer(), () -> SandboxActionButtons.selectedUnitsHaveAnchor(), () -> {
            if (!UnitClientEvents.getSelectedUnits().isEmpty()) {
                SandboxServerboundPacket.removeAnchor(UnitClientEvents.getSelectedUnits().get(0).m_19879_());
            }
        }, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.actionbuttons.reignofnether.remove_anchor", (Object[])new Object[0]), true)));
    }

    public static Button getSetRelationshipButton() {
        return new Button("Toggle Relationship", Button.itemIconSize, switch (SandboxActionButtons.getRelationshipToHudSelectedUnit()) {
            default -> throw new IncompatibleClassChangeError();
            case Relationship.OWNED -> new ResourceLocation("minecraft", "textures/block/lime_wool.png");
            case Relationship.FRIENDLY -> new ResourceLocation("minecraft", "textures/block/blue_wool.png");
            case Relationship.NEUTRAL -> new ResourceLocation("minecraft", "textures/block/yellow_wool.png");
            case Relationship.HOSTILE -> new ResourceLocation("minecraft", "textures/block/red_wool.png");
        }, (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            if (SandboxActionButtons.MC.f_91074_ != null) {
                for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
                    if (!(entity instanceof Unit)) continue;
                    Unit unit = (Unit)entity;
                    switch (UnitClientEvents.getPlayerToEntityRelationship(entity)) {
                        default: {
                            unit.setOwnerName("");
                            break;
                        }
                        case NEUTRAL: {
                            unit.setOwnerName("Enemy");
                            break;
                        }
                        case HOSTILE: {
                            unit.setOwnerName(SandboxActionButtons.MC.f_91074_.m_7755_().getString());
                        }
                    }
                    SandboxServerboundPacket.setOwner(entity.m_19879_(), unit.getOwnerName());
                    SandboxActionButtons.updateButtons();
                }
            }
        }, () -> {
            if (SandboxActionButtons.MC.f_91074_ != null) {
                for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
                    if (!(entity instanceof Unit)) continue;
                    Unit unit = (Unit)entity;
                    switch (SandboxActionButtons.getRelationshipToHudSelectedUnit()) {
                        default: {
                            unit.setOwnerName("Enemy");
                            break;
                        }
                        case NEUTRAL: {
                            unit.setOwnerName(SandboxActionButtons.MC.f_91074_.m_7755_().getString());
                            break;
                        }
                        case HOSTILE: {
                            unit.setOwnerName("");
                        }
                    }
                    SandboxServerboundPacket.setOwner(entity.m_19879_(), unit.getOwnerName());
                    SandboxActionButtons.updateButtons();
                }
            }
        }, List.of(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.relationship_button1", (Object[])new Object[]{SandboxClientEvents.getRelationshipName(SandboxActionButtons.getRelationshipToHudSelectedUnit())})), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.relationship_button2", (Object[])new Object[0]))));
    }

    static {
        SandboxActionButtons.updateButtons();
    }
}

