/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.sounds;

import com.solegendary.reignofnether.registrars.SoundRegistrar;
import com.solegendary.reignofnether.sounds.FadeableMusicInstance;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SoundClientEvents {
    public static ArrayList<BlockPos> mutedBps = new ArrayList();
    public static FadeableMusicInstance customSong = null;
    public static int songTicksLeft = 0;
    private static final Minecraft MC = Minecraft.m_91087_();
    public static List<SoundEvent> STATIC_SOUNDS = List.of((SoundEvent)SoundEvents.f_11689_.get(), (SoundEvent)SoundRegistrar.ALLY.get(), (SoundEvent)SoundRegistrar.CHAT.get(), (SoundEvent)SoundRegistrar.ENEMY.get());
    private static final Map<SoundAction, SoundEvent> SOUND_MAP = new HashMap<SoundAction, SoundEvent>();

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (songTicksLeft > 0 && customSong != null && --songTicksLeft <= 0) {
            SoundClientEvents.stopFadeableMusicInstance();
        }
    }

    public static void playFactionCalmTheme(Faction faction) {
        switch (faction) {
            case VILLAGERS: {
                SoundClientEvents.playFadeableMusicInstance(new FadeableMusicInstance((SoundEvent)SoundRegistrar.VILLAGER_CALM_THEME_SONG.get()), 5200);
                break;
            }
            case MONSTERS: {
                SoundClientEvents.playFadeableMusicInstance(new FadeableMusicInstance((SoundEvent)SoundRegistrar.MONSTER_CALM_THEME_SONG.get()), 5200);
                break;
            }
            case PIGLINS: {
                SoundClientEvents.playFadeableMusicInstance(new FadeableMusicInstance((SoundEvent)SoundRegistrar.PIGLIN_CALM_THEME_SONG.get()), 5200);
            }
        }
    }

    public static void playFadeableMusicInstance(FadeableMusicInstance instance) {
        SoundClientEvents.playFadeableMusicInstance(instance, 0);
    }

    public static void playFadeableMusicInstance(FadeableMusicInstance instance, int tickLength) {
        songTicksLeft = tickLength;
        MC.m_91397_().m_120186_();
        customSong = instance;
        MC.m_91106_().m_120367_((SoundInstance)instance);
    }

    public static void stopFadeableMusicInstance() {
        if (customSong != null) {
            songTicksLeft = 0;
            customSong.startFadeOut();
            customSong = null;
        }
    }

    public static void playSoundAtPos(SoundAction soundAction, BlockPos bp) {
        SoundClientEvents.playSoundAtPos(soundAction, bp, 1.0f);
    }

    public static void playSoundAtPos(SoundAction soundAction, BlockPos bp, float volume) {
        SoundEvent soundEvent = SOUND_MAP.get((Object)soundAction);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            level.m_7785_((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_(), soundEvent, SoundSource.NEUTRAL, volume, 1.0f, false);
        }
    }

    public static void playSoundForLocalPlayer(SoundAction soundAction) {
        SoundClientEvents.playSoundForLocalPlayer(soundAction, 1.0f);
    }

    public static void playSoundForLocalPlayer(SoundAction soundAction, float volume) {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ != null) {
            MC.f_91074_.m_5496_(SOUND_MAP.get((Object)soundAction), volume, 1.0f);
        }
    }

    public static void playSoundIfPlayer(SoundAction soundAction, String playerName) {
        SoundClientEvents.playSoundIfPlayer(soundAction, playerName, 1.0f);
    }

    public static void playSoundIfPlayer(SoundAction soundAction, String playerName, float volume) {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ != null && MC.f_91074_.m_7755_().getString().equals(playerName)) {
            MC.f_91074_.m_5496_(SOUND_MAP.get((Object)soundAction), volume, 1.0f);
        }
    }

    static {
        SOUND_MAP.put(SoundAction.USE_PORTAL, SoundEvents.f_11852_);
        SOUND_MAP.put(SoundAction.RANDOM_CAVE_AMBIENCE, (SoundEvent)SoundEvents.f_11689_.get());
        SOUND_MAP.put(SoundAction.ALLY, (SoundEvent)SoundRegistrar.ALLY.get());
        SOUND_MAP.put(SoundAction.CHAT, (SoundEvent)SoundRegistrar.CHAT.get());
        SOUND_MAP.put(SoundAction.ENEMY, (SoundEvent)SoundRegistrar.ENEMY.get());
        SOUND_MAP.put(SoundAction.BELL, SoundEvents.f_11699_);
        SOUND_MAP.put(SoundAction.BEACON_DEACTIVATE, SoundEvents.f_11738_);
        SOUND_MAP.put(SoundAction.BEACON_ACTIVATE, SoundEvents.f_11736_);
        SOUND_MAP.put(SoundAction.LEVEL_UP, SoundEvents.f_12275_);
        SOUND_MAP.put(SoundAction.BLOODLUST, (SoundEvent)SoundRegistrar.BLOODLUST.get());
        SOUND_MAP.put(SoundAction.HEROISM, (SoundEvent)SoundRegistrar.HEROISM.get());
    }
}

