/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.startpos;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.blocks.RTSStartBlock;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.startpos.StartPos;
import com.solegendary.reignofnether.startpos.StartPosClientboundPacket;
import com.solegendary.reignofnether.startpos.StartPosSaveData;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StartPosServerEvents {
    public static final int MAX_START_POSES = 16;
    public static ArrayList<StartPos> startPoses = new ArrayList();
    private static int TICKS_TO_START_MAX;
    private static int ticksToStart;
    private static boolean startingGame;
    private static int cullTicksMax;
    private static int cullTicks;

    public static void reset(ServerLevel serverLevel) {
        for (StartPos startPos : startPoses) {
            startPos.reset();
        }
        StartPosServerEvents.savePositions(serverLevel);
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent evt) {
        Block block = evt.getPlacedBlock().m_60734_();
        if (block instanceof RTSStartBlock) {
            RTSStartBlock rtsStartBlock = (RTSStartBlock)block;
            if (startPoses.size() < 16) {
                StartPos newStartPos = new StartPos(evt.getPos(), rtsStartBlock.m_284356_().f_283805_);
                startPoses.add(newStartPos);
                StartPosClientboundPacket.addPos(newStartPos);
            } else {
                evt.setCanceled(true);
                for (Player levelAccessor : PlayerServerEvents.players) {
                    if (!(levelAccessor.m_20238_(Vec3.m_82512_((Vec3i)evt.getPos())) < 100.0)) continue;
                    levelAccessor.m_213846_((Component)Component.m_237115_((String)"startpos.reignofnether.max_positions"));
                }
            }
            LevelAccessor levelAccessor = evt.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                StartPosServerEvents.savePositions(serverLevel);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent evt) {
        LevelAccessor levelAccessor;
        if (startPoses.removeIf(sp -> {
            if (sp.pos.equals((Object)evt.getPos())) {
                StartPosClientboundPacket.removePos(evt.getPos());
                return true;
            }
            return false;
        }) && (levelAccessor = evt.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            StartPosServerEvents.savePositions(serverLevel);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        for (StartPos startPos : startPoses) {
            StartPosClientboundPacket.addPos(startPos);
        }
    }

    private static void cullInvalidPoses(ServerLevel serverLevel) {
        if (startPoses.removeIf(sp -> {
            if (!(serverLevel.m_8055_(sp.pos).m_60734_() instanceof RTSStartBlock)) {
                StartPosClientboundPacket.removePos(sp.pos);
                return true;
            }
            return false;
        })) {
            StartPosServerEvents.savePositions(serverLevel);
        }
    }

    public static void startGameCountdown() {
        if (!startingGame) {
            ticksToStart = TICKS_TO_START_MAX;
            startingGame = true;
            StartPosClientboundPacket.startGameCountdown();
        }
    }

    public static void cancelStartGameCountdown(boolean noMsg) {
        if (startingGame) {
            ticksToStart = TICKS_TO_START_MAX;
            startingGame = false;
            StartPosClientboundPacket.cancelStartGameCountdown();
            if (!noMsg) {
                PlayerServerEvents.sendMessageToAllPlayers("startpos.reignofnether.cancelled_start_game", true, new Object[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (startingGame) {
            if (ticksToStart % 20 == 0) {
                int secondsLeft = ticksToStart / 20;
                if (secondsLeft > 0) {
                    PlayerServerEvents.sendMessageToAllPlayersNoNewlines("startpos.reignofnether.starting_game", false, secondsLeft);
                    SoundClientboundPacket.playSoundForAllPlayers(SoundAction.CHAT);
                } else {
                    PlayerServerEvents.sendMessageToAllPlayers("startpos.reignofnether.started_game", true, new Object[0]);
                    SoundClientboundPacket.playSoundForAllPlayers(SoundAction.ALLY);
                    block0: for (ServerPlayer serverPlayer : PlayerServerEvents.players) {
                        for (StartPos startPos : startPoses) {
                            if (!startPos.playerName.equals(serverPlayer.m_7755_().getString()) || startPos.faction == Faction.NONE) continue;
                            PlayerServerEvents.startRTS(serverPlayer.m_19879_(), new Vec3((double)startPos.pos.m_123341_(), (double)startPos.pos.m_123342_(), (double)startPos.pos.m_123343_()), startPos.faction, true);
                            continue block0;
                        }
                    }
                    PlayerServerEvents.setRTSLock(true, true);
                    StartPosServerEvents.reset(evt.getServer().m_129880_(Level.f_46428_));
                    StartPosClientboundPacket.reset();
                    startingGame = false;
                }
            }
            if (ticksToStart >= 0) {
                --ticksToStart;
            }
        } else if (!PlayerServerEvents.isGameActive() && ++cullTicks >= cullTicksMax) {
            cullTicks = 0;
            StartPosServerEvents.cullInvalidPoses(evt.getServer().m_129880_(Level.f_46428_));
        }
    }

    public static void savePositions(ServerLevel serverLevel) {
        StartPosSaveData startPosData = StartPosSaveData.getInstance((LevelAccessor)serverLevel);
        startPosData.startPoses.clear();
        startPosData.startPoses.addAll(startPoses);
        startPosData.save();
        serverLevel.m_8895_().m_78151_();
    }

    @SubscribeEvent
    public static void loadPositions(ServerStartedEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            StartPosSaveData startPosData = StartPosSaveData.getInstance((LevelAccessor)level);
            startPoses.clear();
            startPoses.addAll(startPosData.startPoses);
            ReignOfNether.LOGGER.info("loaded " + startPoses.size() + " start positions in serverevents");
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent evt) {
        for (StartPos startPos : startPoses) {
            ServerPlayer player;
            Player player2 = evt.getEntity();
            if (!(player2 instanceof ServerPlayer) || !startPos.playerName.equals((player = (ServerPlayer)player2).m_7755_().getString())) continue;
            StartPosClientboundPacket.unreservePos(startPos.pos);
            startPos.reset();
        }
    }

    static {
        ticksToStart = TICKS_TO_START_MAX = 100;
        startingGame = false;
        cullTicksMax = 100;
        cullTicks = 0;
    }
}

