/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.team;

import java.util.HashSet;
import java.util.Set;

public class Team {
    private final String name;
    private String leader;
    private final Set<String> members;
    private final long creationTime;

    public Team(String name, String leader) {
        this.name = name;
        this.leader = leader;
        this.members = new HashSet<String>();
        this.members.add(leader);
        this.creationTime = System.currentTimeMillis();
    }

    public String getName() {
        return this.name;
    }

    public String getLeader() {
        return this.leader;
    }

    public void setLeader(String newLeader) {
        if (this.members.contains(newLeader)) {
            this.leader = newLeader;
        }
    }

    public Set<String> getMembers() {
        return new HashSet<String>(this.members);
    }

    public void addMember(String playerName) {
        this.members.add(playerName);
    }

    public void removeMember(String playerName) {
        this.members.remove(playerName);
    }

    public boolean hasMember(String playerName) {
        return this.members.contains(playerName);
    }

    public int getSize() {
        return this.members.size();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String toString() {
        return "Team{name='" + this.name + "', leader='" + this.leader + "', members=" + String.valueOf(this.members) + ", size=" + this.getSize() + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Team team = (Team)obj;
        return this.name.equals(team.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

