/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.team;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.team.Team;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;

public class TeamClientEvents {
    private static final Map<String, Team> teams = new ConcurrentHashMap<String, Team>();
    private static final Map<String, String> playerToTeam = new ConcurrentHashMap<String, String>();
    private static final Map<String, PlayerTeamStats> playerStats = new ConcurrentHashMap<String, PlayerTeamStats>();
    private static final Set<String> pendingInvites = new HashSet<String>();
    private static final Set<String> defeatedOrLeftPlayers = new HashSet<String>();

    public static void syncTeam(String teamName, String leader, String[] members) {
        Team team = new Team(teamName, leader);
        for (String member : members) {
            if (member.equals(leader)) continue;
            team.addMember(member);
        }
        teams.put(teamName, team);
        HashSet<String> newMembers = new HashSet<String>(Arrays.asList(members));
        for (String member : members) {
            playerToTeam.put(member, teamName);
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, String> e : playerToTeam.entrySet()) {
            if (!e.getValue().equals(teamName) || newMembers.contains(e.getKey())) continue;
            toRemove.add(e.getKey());
        }
        for (String p : toRemove) {
            playerToTeam.remove(p);
        }
        ReignOfNether.LOGGER.info("Synced team: {}", (Object)team);
    }

    public static void receiveInvite(String teamId, String playerName, String leaderName) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_7755_().getString().equals(playerName)) {
            pendingInvites.add(teamId);
            ReignOfNether.LOGGER.info("Received invite to team {} from {}", (Object)teamId, (Object)leaderName);
        }
    }

    public static void resetAllTeams() {
        teams.clear();
        playerToTeam.clear();
        pendingInvites.clear();
        defeatedOrLeftPlayers.clear();
        playerStats.clear();
        ReignOfNether.LOGGER.info("Reset all team data");
    }

    public static void markPlayerDefeatedOrLeft(String playerName) {
        defeatedOrLeftPlayers.add(playerName);
        ReignOfNether.LOGGER.info("Marked player {} as defeated/left", (Object)playerName);
    }

    public static void markPlayerOnline(String playerName) {
        defeatedOrLeftPlayers.remove(playerName);
        ReignOfNether.LOGGER.info("Marked player {} as online (cleared defeated/left)", (Object)playerName);
    }

    public static boolean isPlayerDefeatedOrLeft(String playerName) {
        return defeatedOrLeftPlayers.contains(playerName);
    }

    public static Set<String> getDefeatedOrLeftPlayers() {
        return new HashSet<String>(defeatedOrLeftPlayers);
    }

    public static Team getPlayerTeam(String playerName) {
        String teamId = playerToTeam.get(playerName);
        return teamId != null ? teams.get(teamId) : null;
    }

    public static Collection<Team> getAllTeams() {
        return teams.values();
    }

    public static boolean areOnSameTeam(String player1, String player2) {
        if (player1 == null || player2 == null) {
            return false;
        }
        String team1 = playerToTeam.get(player1);
        String team2 = playerToTeam.get(player2);
        return team1 != null && team1.equals(team2);
    }

    public static Set<String> getTeammates(String playerName) {
        Team team = TeamClientEvents.getPlayerTeam(playerName);
        if (team == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(team.getMembers());
    }

    public static PlayerTeamStats getStats(String player) {
        return playerStats.computeIfAbsent(player, k -> new PlayerTeamStats());
    }

    public static void incrementCourierDelivered(String player) {
        ++TeamClientEvents.getStats((String)player).couriersDelivered;
    }

    public static void incrementCourierIntercepted(String player) {
        ++TeamClientEvents.getStats((String)player).couriersIntercepted;
    }

    public static void addContributions(String player, int food, int wood, int ore) {
        PlayerTeamStats s = TeamClientEvents.getStats(player);
        s.foodContributed += food;
        s.woodContributed += wood;
        s.oreContributed += ore;
    }

    public static boolean hasInvite(String teamId) {
        return pendingInvites.contains(teamId);
    }

    public static Set<String> getPendingInvites() {
        return new HashSet<String>(pendingInvites);
    }

    public static void removeInvite(String teamId) {
        pendingInvites.remove(teamId);
    }

    public static class PlayerTeamStats {
        public int kills;
        public int losses;
        public int couriersDelivered;
        public int couriersIntercepted;
        public int foodContributed;
        public int woodContributed;
        public int oreContributed;
    }
}

