/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.team;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.team.Team;
import com.solegendary.reignofnether.team.TeamManager;
import com.solegendary.reignofnether.team.TeamResetPacket;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;

public class TeamCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"team").then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"teamName", (ArgumentType)StringArgumentType.word()).executes(TeamCommand::createTeam))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"team").then(Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(TeamCommand::invitePlayer))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"team").then(Commands.m_82127_((String)"accept").then(Commands.m_82129_((String)"teamName", (ArgumentType)StringArgumentType.word()).executes(TeamCommand::acceptInvite))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"team").then(Commands.m_82127_((String)"decline").then(Commands.m_82129_((String)"teamName", (ArgumentType)StringArgumentType.word()).executes(TeamCommand::declineInvite))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"team").then(Commands.m_82127_((String)"leave").executes(TeamCommand::leaveTeam)));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"team").then(Commands.m_82127_((String)"kick").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(TeamCommand::kickPlayer))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"team").then(Commands.m_82127_((String)"list").executes(TeamCommand::listTeams)));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"team").then(Commands.m_82127_((String)"info").executes(TeamCommand::showTeamInfo)));
    }

    private static int createTeam(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String teamName = StringArgumentType.getString(context, (String)"teamName");
        String playerName = player.m_7755_().getString();
        Team team = TeamManager.createTeam(playerName, teamName);
        if (team != null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"team.reignofnether.created", (Object[])new Object[]{teamName}), false);
            SoundClientboundPacket.playSoundForPlayer(SoundAction.ALLY, playerName);
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"team.reignofnether.create_failed", (Object[])new Object[]{teamName}));
        }
        return 1;
    }

    private static int invitePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerPlayer targetPlayer = EntityArgument.m_91474_(context, (String)"player");
        String playerName = player.m_7755_().getString();
        String targetName = targetPlayer.m_7755_().getString();
        Team playerTeam = TeamManager.getPlayerTeam(playerName);
        if (playerTeam == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"team.reignofnether.not_in_team"));
            return 0;
        }
        if (!playerTeam.getLeader().equals(playerName)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"team.reignofnether.not_leader"));
            return 0;
        }
        boolean success = TeamManager.invitePlayer(playerTeam.getName(), targetName);
        if (success) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"team.reignofnether.invite_sent", (Object[])new Object[]{targetName}), false);
            targetPlayer.m_213846_((Component)Component.m_237110_((String)"team.reignofnether.invite_received", (Object[])new Object[]{playerName, playerTeam.getName()}));
            SoundClientboundPacket.playSoundForPlayer(SoundAction.CHAT, targetName);
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"team.reignofnether.invite_failed", (Object[])new Object[]{targetName}));
        }
        return 1;
    }

    private static int acceptInvite(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String playerName;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String teamName = StringArgumentType.getString(context, (String)"teamName");
        boolean success = TeamManager.acceptInvite(teamName, playerName = player.m_7755_().getString());
        if (success) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"team.reignofnether.joined", (Object[])new Object[]{teamName}), false);
            SoundClientboundPacket.playSoundForPlayer(SoundAction.ALLY, playerName);
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new TeamResetPacket());
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"team.reignofnether.join_failed", (Object[])new Object[]{teamName}));
        }
        return 1;
    }

    private static int declineInvite(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String playerName;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String teamName = StringArgumentType.getString(context, (String)"teamName");
        boolean success = TeamManager.declineInvite(teamName, playerName = player.m_7755_().getString());
        if (success) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"team.reignofnether.declined", (Object[])new Object[]{teamName}), false);
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new TeamResetPacket());
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"team.reignofnether.decline_failed", (Object[])new Object[]{teamName}));
        }
        return 1;
    }

    private static int leaveTeam(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String playerName = player.m_7755_().getString();
        Team team = TeamManager.getPlayerTeam(playerName);
        if (team == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"team.reignofnether.not_in_team"));
            return 0;
        }
        boolean success = TeamManager.leaveTeam(playerName);
        if (success) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"team.reignofnether.left", (Object[])new Object[]{team.getName()}), false);
            SoundClientboundPacket.playSoundForPlayer(SoundAction.ENEMY, playerName);
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"team.reignofnether.leave_failed"));
        }
        return 1;
    }

    private static int kickPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerPlayer targetPlayer = EntityArgument.m_91474_(context, (String)"player");
        String playerName = player.m_7755_().getString();
        String targetName = targetPlayer.m_7755_().getString();
        Team playerTeam = TeamManager.getPlayerTeam(playerName);
        if (playerTeam == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"team.reignofnether.not_in_team"));
            return 0;
        }
        if (!playerTeam.getLeader().equals(playerName)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"team.reignofnether.not_leader"));
            return 0;
        }
        boolean success = TeamManager.kickPlayer(playerTeam.getName(), playerName, targetName);
        if (success) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"team.reignofnether.kicked", (Object[])new Object[]{targetName}), false);
            targetPlayer.m_213846_((Component)Component.m_237110_((String)"team.reignofnether.kicked_from", (Object[])new Object[]{playerTeam.getName()}));
            SoundClientboundPacket.playSoundForPlayer(SoundAction.ENEMY, targetName);
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"team.reignofnether.kick_failed", (Object[])new Object[]{targetName}));
        }
        return 1;
    }

    private static int listTeams(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"team.reignofnether.list_header"), false);
        for (Team team : TeamManager.getAllTeams()) {
            String members = String.join((CharSequence)", ", team.getMembers());
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a76" + team.getName() + "\u00a7r (Leader: \u00a7e" + team.getLeader() + "\u00a7r): " + members)), false);
        }
        return 1;
    }

    private static int showTeamInfo(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String playerName = player.m_7755_().getString();
        Team team = TeamManager.getPlayerTeam(playerName);
        if (team == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"team.reignofnether.not_in_team"));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"team.reignofnether.info_header", (Object[])new Object[]{team.getName()}), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"team.reignofnether.info_leader", (Object[])new Object[]{team.getLeader()}), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"team.reignofnether.info_members", (Object[])new Object[]{team.getSize()}), false);
        String members = String.join((CharSequence)", ", team.getMembers());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7e" + members)), false);
        Set<String> invites = TeamManager.getPlayerInvites(playerName);
        if (!invites.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"team.reignofnether.info_invites"), false);
            for (String invite : invites) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7a" + invite)), false);
            }
        }
        return 1;
    }
}

