/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.team;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.team.Team;
import com.solegendary.reignofnether.team.TeamInvitePacket;
import com.solegendary.reignofnether.team.TeamResetPacket;
import com.solegendary.reignofnether.team.TeamSyncPacket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.network.PacketDistributor;

public class TeamManager {
    private static final Map<String, Team> teams = new ConcurrentHashMap<String, Team>();
    private static final Map<String, String> playerToTeam = new ConcurrentHashMap<String, String>();
    private static final Map<String, Set<String>> teamInvites = new ConcurrentHashMap<String, Set<String>>();
    private static volatile boolean teamsLocked = false;
    private static final int MAX_TEAM_SIZE = 6;
    private static final int INVITE_TIMEOUT_SECONDS = 60;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Team createTeam(String leaderName, String teamName) {
        if (teamsLocked) {
            return null;
        }
        if (playerToTeam.containsKey(leaderName)) {
            return null;
        }
        if (teams.containsKey(teamName)) {
            return null;
        }
        Team team = new Team(teamName, leaderName);
        teams.put(teamName, team);
        playerToTeam.put(leaderName, teamName);
        TeamManager.broadcastTeamUpdate(team);
        ReignOfNether.LOGGER.info("Team '{}' created by {}", (Object)teamName, (Object)leaderName);
        if (PlayerServerEvents.serverLevel != null) {
            TeamManager.saveToJson(PlayerServerEvents.serverLevel);
        }
        return team;
    }

    public static boolean invitePlayer(String teamId, String playerName) {
        if (teamsLocked) {
            return false;
        }
        Team team = teams.get(teamId);
        if (team == null) {
            return false;
        }
        if (playerToTeam.containsKey(playerName)) {
            return false;
        }
        if (team.getMembers().size() >= 6) {
            return false;
        }
        teamInvites.computeIfAbsent(teamId, k -> new HashSet()).add(playerName);
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new TeamInvitePacket(teamId, playerName, team.getLeader()));
        TeamManager.scheduleInviteTimeout(teamId, playerName);
        ReignOfNether.LOGGER.info("Player {} invited to team {}", (Object)playerName, (Object)teamId);
        return true;
    }

    public static boolean acceptInvite(String teamId, String playerName) {
        if (teamsLocked) {
            return false;
        }
        Team team = teams.get(teamId);
        if (team == null) {
            return false;
        }
        Set<String> invites = teamInvites.get(teamId);
        if (invites == null || !invites.contains(playerName)) {
            return false;
        }
        if (playerToTeam.containsKey(playerName)) {
            return false;
        }
        if (team.getMembers().size() >= 6) {
            return false;
        }
        team.addMember(playerName);
        playerToTeam.put(playerName, teamId);
        invites.remove(playerName);
        TeamManager.broadcastTeamUpdate(team);
        TeamManager.sendMessageToTeam(team, "team.reignofnether.player_joined", playerName);
        ReignOfNether.LOGGER.info("Player {} joined team {}", (Object)playerName, (Object)teamId);
        if (PlayerServerEvents.serverLevel != null) {
            TeamManager.saveToJson(PlayerServerEvents.serverLevel);
        }
        return true;
    }

    public static boolean declineInvite(String teamId, String playerName) {
        Team team;
        if (teamsLocked) {
            return false;
        }
        Set<String> invites = teamInvites.get(teamId);
        if (invites != null) {
            invites.remove(playerName);
        }
        if ((team = teams.get(teamId)) != null) {
            TeamManager.sendMessageToPlayer(team.getLeader(), "team.reignofnether.invite_declined", playerName);
        }
        if (PlayerServerEvents.serverLevel != null) {
            TeamManager.saveToJson(PlayerServerEvents.serverLevel);
        }
        return true;
    }

    public static boolean leaveTeam(String playerName) {
        if (teamsLocked) {
            return false;
        }
        String teamId = playerToTeam.get(playerName);
        if (teamId == null) {
            return false;
        }
        Team team = teams.get(teamId);
        if (team == null) {
            return false;
        }
        team.removeMember(playerName);
        playerToTeam.remove(playerName);
        if (team.getMembers().isEmpty()) {
            teams.remove(teamId);
            teamInvites.remove(teamId);
            ReignOfNether.LOGGER.info("Team {} disbanded (empty)", (Object)teamId);
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new TeamResetPacket());
        } else {
            if (team.getLeader().equals(playerName)) {
                String newLeader = team.getMembers().iterator().next();
                team.setLeader(newLeader);
                TeamManager.sendMessageToTeam(team, "team.reignofnether.new_leader", newLeader);
            }
            TeamManager.sendMessageToTeam(team, "team.reignofnether.player_left", playerName);
            TeamManager.broadcastTeamUpdate(team);
        }
        ReignOfNether.LOGGER.info("Player {} left team {}", (Object)playerName, (Object)teamId);
        if (PlayerServerEvents.serverLevel != null) {
            TeamManager.saveToJson(PlayerServerEvents.serverLevel);
        }
        return true;
    }

    public static boolean kickPlayer(String teamId, String leaderName, String playerName) {
        if (teamsLocked) {
            return false;
        }
        Team team = teams.get(teamId);
        if (team == null || !team.getLeader().equals(leaderName)) {
            return false;
        }
        if (!team.getMembers().contains(playerName)) {
            return false;
        }
        team.removeMember(playerName);
        playerToTeam.remove(playerName);
        TeamManager.sendMessageToPlayer(playerName, "team.reignofnether.kicked", teamId);
        TeamManager.sendMessageToTeam(team, "team.reignofnether.player_kicked", playerName);
        TeamManager.broadcastTeamUpdate(team);
        ReignOfNether.LOGGER.info("Player {} kicked from team {} by {}", (Object)playerName, (Object)teamId, (Object)leaderName);
        if (PlayerServerEvents.serverLevel != null) {
            TeamManager.saveToJson(PlayerServerEvents.serverLevel);
        }
        return true;
    }

    public static Team getPlayerTeam(String playerName) {
        String teamId = playerToTeam.get(playerName);
        return teamId != null ? teams.get(teamId) : null;
    }

    public static Collection<Team> getAllTeams() {
        return teams.values();
    }

    public static void setLocked(boolean locked) {
        teamsLocked = locked;
    }

    public static boolean isLocked() {
        return teamsLocked;
    }

    public static Team forceCreateTeam(String leaderName, String teamName) {
        if (playerToTeam.containsKey(leaderName)) {
            TeamManager.leaveTeamInternal(leaderName);
        }
        if (teams.containsKey(teamName)) {
            return teams.get(teamName);
        }
        Team team = new Team(teamName, leaderName);
        teams.put(teamName, team);
        playerToTeam.put(leaderName, teamName);
        TeamManager.broadcastTeamUpdate(team);
        ReignOfNether.LOGGER.info("[TeamAdmin] Team '{}' created with leader {}", (Object)teamName, (Object)leaderName);
        return team;
    }

    public static boolean forceAddToTeam(String teamId, String playerName) {
        Team team = teams.get(teamId);
        if (team == null) {
            return false;
        }
        String existing = playerToTeam.get(playerName);
        if (existing != null && !existing.equals(teamId)) {
            TeamManager.leaveTeamInternal(playerName);
        }
        team.addMember(playerName);
        playerToTeam.put(playerName, teamId);
        TeamManager.broadcastTeamUpdate(team);
        return true;
    }

    public static boolean forceRemoveFromTeam(String teamId, String playerName) {
        Team team = teams.get(teamId);
        if (team == null) {
            return false;
        }
        if (!team.getMembers().contains(playerName)) {
            return false;
        }
        team.removeMember(playerName);
        playerToTeam.remove(playerName);
        if (team.getMembers().isEmpty()) {
            teams.remove(teamId);
            teamInvites.remove(teamId);
        } else if (team.getLeader().equals(playerName)) {
            String newLeader = team.getMembers().iterator().next();
            team.setLeader(newLeader);
        }
        TeamManager.broadcastTeamUpdate(team);
        return true;
    }

    public static boolean forceSetLeader(String teamId, String newLeader) {
        Team team = teams.get(teamId);
        if (team == null) {
            return false;
        }
        if (!team.getMembers().contains(newLeader)) {
            TeamManager.forceAddToTeam(teamId, newLeader);
        }
        team.setLeader(newLeader);
        TeamManager.broadcastTeamUpdate(team);
        return true;
    }

    public static boolean forceDisband(String teamId) {
        Team team = teams.get(teamId);
        if (team == null) {
            return false;
        }
        for (String m : new HashSet<String>(team.getMembers())) {
            playerToTeam.remove(m);
        }
        teams.remove(teamId);
        teamInvites.remove(teamId);
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new TeamResetPacket());
        ReignOfNether.LOGGER.info("[TeamAdmin] Disbanded team {}", (Object)teamId);
        return true;
    }

    public static void forceClearAll() {
        teams.clear();
        playerToTeam.clear();
        teamInvites.clear();
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new TeamResetPacket());
    }

    private static void leaveTeamInternal(String playerName) {
        String teamId = playerToTeam.get(playerName);
        if (teamId == null) {
            return;
        }
        Team team = teams.get(teamId);
        if (team == null) {
            return;
        }
        team.removeMember(playerName);
        playerToTeam.remove(playerName);
        if (team.getMembers().isEmpty()) {
            teams.remove(teamId);
            teamInvites.remove(teamId);
        } else if (team.getLeader().equals(playerName)) {
            String newLeader = team.getMembers().iterator().next();
            team.setLeader(newLeader);
        }
        TeamManager.broadcastTeamUpdate(team);
    }

    public static boolean areOnSameTeam(String player1, String player2) {
        if (player1 == null || player2 == null) {
            return false;
        }
        String team1 = playerToTeam.get(player1);
        String team2 = playerToTeam.get(player2);
        return team1 != null && team1.equals(team2);
    }

    public static Set<String> getTeammates(String playerName) {
        Team team = TeamManager.getPlayerTeam(playerName);
        if (team == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(team.getMembers());
    }

    public static boolean hasInvite(String playerName, String teamId) {
        Set<String> invites = teamInvites.get(teamId);
        return invites != null && invites.contains(playerName);
    }

    public static Set<String> getPlayerInvites(String playerName) {
        HashSet<String> playerInvites = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry : teamInvites.entrySet()) {
            if (!entry.getValue().contains(playerName)) continue;
            playerInvites.add(entry.getKey());
        }
        return playerInvites;
    }

    public static void resetAllTeams() {
        teams.clear();
        playerToTeam.clear();
        teamInvites.clear();
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new TeamResetPacket());
        ReignOfNether.LOGGER.info("All teams reset");
    }

    public static void syncTeamsToPlayer(String playerName) {
        for (Team team : teams.values()) {
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new TeamSyncPacket(team));
        }
        Set<String> invites = TeamManager.getPlayerInvites(playerName);
        for (String teamId : invites) {
            Team team = teams.get(teamId);
            if (team == null) continue;
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new TeamInvitePacket(teamId, playerName, team.getLeader()));
        }
    }

    private static void broadcastTeamUpdate(Team team) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new TeamSyncPacket(team));
    }

    private static void sendMessageToTeam(Team team, String messageKey, Object ... args) {
        for (String member : team.getMembers()) {
            TeamManager.sendMessageToPlayer(member, messageKey, args);
        }
    }

    private static void sendMessageToPlayer(String playerName, String messageKey, Object ... args) {
        PlayerServerEvents.sendMessageToPlayerNoNewLines(playerName, messageKey, false, args);
        SoundClientboundPacket.playSoundForPlayer(SoundAction.CHAT, playerName);
    }

    private static void scheduleInviteTimeout(final String teamId, final String playerName) {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Set<String> invites = teamInvites.get(teamId);
                if (invites != null) {
                    invites.remove(playerName);
                    if (invites.isEmpty()) {
                        teamInvites.remove(teamId);
                    }
                }
                timer.cancel();
            }
        }, 60000L);
    }

    private static Path getTeamsJsonPath(ServerLevel serverLevel) {
        return serverLevel.m_7654_().m_129843_(LevelResource.f_78182_).resolve("reignofnether").resolve("teams.json");
    }

    public static void saveToJson(ServerLevel serverLevel) {
        try {
            Path path = TeamManager.getTeamsJsonPath(serverLevel);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            ArrayList<TeamRecord> dto = new ArrayList<TeamRecord>();
            for (Team t : teams.values()) {
                dto.add(new TeamRecord(t.getName(), t.getLeader(), t.getMembers()));
            }
            Files.writeString(path, (CharSequence)GSON.toJson(dto), new OpenOption[0]);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed to save teams.json", (Throwable)e);
        }
    }

    public static void loadFromJson(ServerLevel serverLevel) {
        try {
            Path path = TeamManager.getTeamsJsonPath(serverLevel);
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            String json = Files.readString(path);
            List dto = (List)GSON.fromJson(json, new TypeToken<List<TeamRecord>>(){}.getType());
            teams.clear();
            playerToTeam.clear();
            teamInvites.clear();
            if (dto != null) {
                for (TeamRecord rec : dto) {
                    Team t = new Team(rec.name(), rec.leader());
                    for (String m : rec.members()) {
                        t.addMember(m);
                    }
                    teams.put(t.getName(), t);
                    for (String m : t.getMembers()) {
                        playerToTeam.put(m, t.getName());
                    }
                }
            }
            for (Team team : teams.values()) {
                TeamManager.broadcastTeamUpdate(team);
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed to load teams.json", (Throwable)e);
        }
    }

    public static void resetAndSave(ServerLevel serverLevel) {
        TeamManager.resetAllTeams();
        TeamManager.saveToJson(serverLevel);
    }

    private record TeamRecord(String name, String leader, Set<String> members) {
    }
}

