/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.team;

import com.solegendary.reignofnether.team.TeamClientEvents;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class TeamStatsClientboundPacket {
    public String playerName;
    public int kills;
    public int losses;
    public int couriersDelivered;
    public int couriersIntercepted;
    public int foodContrib;
    public int woodContrib;
    public int oreContrib;

    public TeamStatsClientboundPacket(String playerName, int kills, int losses, int couriersDelivered, int couriersIntercepted, int foodContrib, int woodContrib, int oreContrib) {
        this.playerName = playerName;
        this.kills = kills;
        this.losses = losses;
        this.couriersDelivered = couriersDelivered;
        this.couriersIntercepted = couriersIntercepted;
        this.foodContrib = foodContrib;
        this.woodContrib = woodContrib;
        this.oreContrib = oreContrib;
    }

    public TeamStatsClientboundPacket(FriendlyByteBuf buf) {
        this.playerName = buf.m_130277_();
        this.kills = buf.m_130242_();
        this.losses = buf.m_130242_();
        this.couriersDelivered = buf.m_130242_();
        this.couriersIntercepted = buf.m_130242_();
        this.foodContrib = buf.m_130242_();
        this.woodContrib = buf.m_130242_();
        this.oreContrib = buf.m_130242_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.playerName);
        buf.m_130130_(this.kills);
        buf.m_130130_(this.losses);
        buf.m_130130_(this.couriersDelivered);
        buf.m_130130_(this.couriersIntercepted);
        buf.m_130130_(this.foodContrib);
        buf.m_130130_(this.woodContrib);
        buf.m_130130_(this.oreContrib);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            TeamClientEvents.PlayerTeamStats stats = TeamClientEvents.getStats(this.playerName);
            stats.kills = this.kills;
            stats.losses = this.losses;
            stats.couriersDelivered = this.couriersDelivered;
            stats.couriersIntercepted = this.couriersIntercepted;
            stats.foodContributed = this.foodContrib;
            stats.woodContributed = this.woodContrib;
            stats.oreContributed = this.oreContrib;
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

