/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.team;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.team.TeamStatsClientboundPacket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.network.PacketDistributor;

public final class TeamStatsServer {
    private static final Map<String, Stats> playerStats = new ConcurrentHashMap<String, Stats>();

    private TeamStatsServer() {
    }

    private static Path getStatsPath(ServerLevel level) {
        return level.m_7654_().m_129843_(LevelResource.f_78182_).resolve("reignofnether").resolve("team_stats.json");
    }

    public static void saveToJson(ServerLevel level) {
        try {
            Path path = TeamStatsServer.getStatsPath(level);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            JsonObject root = new JsonObject();
            for (Map.Entry<String, Stats> e : playerStats.entrySet()) {
                JsonObject o = new JsonObject();
                o.addProperty("kills", (Number)e.getValue().kills);
                o.addProperty("losses", (Number)e.getValue().losses);
                o.addProperty("couriersDelivered", (Number)e.getValue().couriersDelivered);
                o.addProperty("couriersIntercepted", (Number)e.getValue().couriersIntercepted);
                o.addProperty("foodContrib", (Number)e.getValue().foodContrib);
                o.addProperty("woodContrib", (Number)e.getValue().woodContrib);
                o.addProperty("oreContrib", (Number)e.getValue().oreContrib);
                root.add(e.getKey(), (JsonElement)o);
            }
            Files.writeString(path, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)root), new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadFromJson(ServerLevel level) {
        try {
            Path path = TeamStatsServer.getStatsPath(level);
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            String json = Files.readString(path);
            JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
            playerStats.clear();
            for (Map.Entry entry : root.entrySet()) {
                Stats s = new Stats();
                JsonObject o = ((JsonElement)entry.getValue()).getAsJsonObject();
                s.kills = o.get("kills").getAsInt();
                s.losses = o.get("losses").getAsInt();
                s.couriersDelivered = o.get("couriersDelivered").getAsInt();
                s.couriersIntercepted = o.get("couriersIntercepted").getAsInt();
                s.foodContrib = o.get("foodContrib").getAsInt();
                s.woodContrib = o.get("woodContrib").getAsInt();
                s.oreContrib = o.get("oreContrib").getAsInt();
                playerStats.put((String)entry.getKey(), s);
                TeamStatsServer.sync((String)entry.getKey());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Stats get(String player) {
        return playerStats.computeIfAbsent(player, k -> new Stats());
    }

    public static void incrementKill(String killer) {
        ++TeamStatsServer.get((String)killer).kills;
        TeamStatsServer.sync(killer);
    }

    public static void incrementLoss(String owner) {
        ++TeamStatsServer.get((String)owner).losses;
        TeamStatsServer.sync(owner);
    }

    public static void incrementCourierDelivered(String receiver) {
        ++TeamStatsServer.get((String)receiver).couriersDelivered;
        TeamStatsServer.sync(receiver);
    }

    public static void incrementCourierIntercepted(String sender) {
        ++TeamStatsServer.get((String)sender).couriersIntercepted;
        TeamStatsServer.sync(sender);
    }

    public static void addContribution(String sender, int food, int wood, int ore) {
        Stats s = TeamStatsServer.get(sender);
        s.foodContrib += food;
        s.woodContrib += wood;
        s.oreContrib += ore;
        TeamStatsServer.sync(sender);
    }

    public static void sync(String player) {
        Stats s = TeamStatsServer.get(player);
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new TeamStatsClientboundPacket(player, s.kills, s.losses, s.couriersDelivered, s.couriersIntercepted, s.foodContrib, s.woodContrib, s.oreContrib));
    }

    public static class Stats {
        public int kills;
        public int losses;
        public int couriersDelivered;
        public int couriersIntercepted;
        public int foodContrib;
        public int woodContrib;
        public int oreContrib;
    }
}

