/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.team;

import com.solegendary.reignofnether.team.Team;
import com.solegendary.reignofnether.team.TeamClientEvents;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class TeamSyncPacket {
    private final String teamName;
    private final String leader;
    private final String[] members;

    public TeamSyncPacket(Team team) {
        this.teamName = team.getName();
        this.leader = team.getLeader();
        this.members = team.getMembers().toArray(new String[0]);
    }

    public TeamSyncPacket(FriendlyByteBuf buf) {
        this.teamName = buf.m_130136_(Short.MAX_VALUE);
        this.leader = buf.m_130136_(Short.MAX_VALUE);
        int memberCount = buf.readInt();
        this.members = new String[memberCount];
        for (int i = 0; i < memberCount; ++i) {
            this.members[i] = buf.m_130136_(Short.MAX_VALUE);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.teamName);
        buf.m_130070_(this.leader);
        buf.writeInt(this.members.length);
        for (String member : this.members) {
            buf.m_130070_(member);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> TeamClientEvents.syncTeam(this.teamName, this.leader, this.members));
        return true;
    }
}

