/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.tutorial;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.tutorial.TutorialAction;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class TutorialClientboundPacket {
    private final TutorialAction action;
    private final TutorialStage stage;

    public static void enableTutorial() {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new TutorialClientboundPacket(TutorialAction.ENABLE, TutorialStage.INTRO));
    }

    public static void disableTutorial() {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new TutorialClientboundPacket(TutorialAction.DISABLE, TutorialStage.INTRO));
    }

    public static void loadTutorialStage(TutorialStage stage) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new TutorialClientboundPacket(TutorialAction.LOAD_STAGE, stage));
    }

    public TutorialClientboundPacket(TutorialAction action, TutorialStage stage) {
        this.action = action;
        this.stage = stage;
    }

    public TutorialClientboundPacket(FriendlyByteBuf buffer) {
        this.action = (TutorialAction)buffer.m_130066_(TutorialAction.class);
        this.stage = (TutorialStage)buffer.m_130066_(TutorialStage.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130068_((Enum)this.stage);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            switch (this.action) {
                case ENABLE: {
                    TutorialClientEvents.setEnabled(true);
                    break;
                }
                case DISABLE: {
                    TutorialClientEvents.setEnabled(false);
                    break;
                }
                case LOAD_STAGE: {
                    TutorialClientEvents.loadStage(this.stage);
                }
            }
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

