/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.tutorial;

import com.mojang.blaze3d.systems.RenderSystem;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public class TutorialRendering {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final ResourceLocation TEXTURE_ARROW_RIGHT = new ResourceLocation("reignofnether", "textures/hud/tutorial_arrow_right.png");
    private static final ResourceLocation TEXTURE_ARROW_LEFT = new ResourceLocation("reignofnether", "textures/hud/tutorial_arrow_left.png");
    private static final ResourceLocation TEXTURE_ARROW_UP = new ResourceLocation("reignofnether", "textures/hud/tutorial_arrow_up.png");
    private static final ResourceLocation TEXTURE_ARROW_DOWN = new ResourceLocation("reignofnether", "textures/hud/tutorial_arrow_down.png");
    private static String buttonNameToHighlight = "";
    static int xOffset2 = 0;
    static int yOffset2 = 0;

    public static void setButtonName(String name) {
        if (name != null) {
            buttonNameToHighlight = I18n.m_118938_((String)name, (Object[])new Object[0]);
        }
    }

    public static void clearButtonName() {
        buttonNameToHighlight = "";
    }

    public static void highlightNextButton(GuiGraphics guiGraphics, ArrayList<Button> buttons) {
        if (!TutorialClientEvents.isEnabled() || buttonNameToHighlight.isEmpty()) {
            return;
        }
        TutorialStage stage = TutorialClientEvents.getStage();
        Button activeButton = null;
        for (Button button : buttons) {
            if (!button.name.equals(buttonNameToHighlight) || button.isHidden.get().booleanValue() || !button.isEnabled.get().booleanValue() || button.isSelected.get().booleanValue() || button.hotkey == null && !button.name.equals(TutorialClientEvents.helpButton.name) && TutorialClientEvents.getStage() != TutorialStage.PLACE_WORKERS_B) continue;
            activeButton = button;
            break;
        }
        if (activeButton == null) {
            return;
        }
        if (System.currentTimeMillis() / 500L % 2L == 0L) {
            guiGraphics.m_280509_(activeButton.x, activeButton.y, activeButton.x + Button.DEFAULT_ICON_FRAME_SIZE, activeButton.y + Button.DEFAULT_ICON_FRAME_SIZE, 0x32FFFFFF);
        }
        TutorialRendering.pointAtWithArrow(guiGraphics, activeButton.x, activeButton.y, true);
    }

    public static void pointAtWithArrow(GuiGraphics guiGraphics, int x, int y, boolean vertical) {
        ResourceLocation texture;
        if (TutorialRendering.MC.f_91080_ == null) {
            return;
        }
        int xOffset = 0;
        int yOffset = 0;
        if (vertical && y < TutorialRendering.MC.f_91080_.f_96544_ / 2) {
            xOffset = -5;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_ARROW_UP);
            yOffset = (int)MiscUtil.getOscillatingFloat(20.0, 36.0);
            texture = TEXTURE_ARROW_UP;
        } else if (vertical) {
            xOffset = -5;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_ARROW_DOWN);
            yOffset = (int)MiscUtil.getOscillatingFloat(-46.0, -30.0, 500L);
            texture = TEXTURE_ARROW_DOWN;
        } else if (x < TutorialRendering.MC.f_91080_.f_96543_ / 2) {
            yOffset = -5;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_ARROW_LEFT);
            xOffset = (int)MiscUtil.getOscillatingFloat(20.0, 36.0);
            texture = TEXTURE_ARROW_LEFT;
        } else {
            yOffset = -5;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_ARROW_RIGHT);
            xOffset = (int)MiscUtil.getOscillatingFloat(-46.0, -30.0, 500L);
            texture = TEXTURE_ARROW_RIGHT;
        }
        guiGraphics.m_280398_(texture, x + xOffset + xOffset2, y + yOffset + yOffset2, 32, 32.0f, 32.0f, 32, 32, 32, 32);
    }
}

