/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.tutorial;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.villagers.Barracks;
import com.solegendary.reignofnether.building.buildings.villagers.TownCentre;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.tutorial.TutorialClientboundPacket;
import com.solegendary.reignofnether.tutorial.TutorialSaveData;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.units.monsters.SkeletonUnit;
import com.solegendary.reignofnether.unit.units.monsters.ZombieUnit;
import com.solegendary.reignofnether.unit.units.monsters.ZombieVillagerUnit;
import com.solegendary.reignofnether.util.Faction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TutorialServerEvents {
    private static final String TUTORIAL_MAP_NAME = "reign_of_nether_tutorial";
    private static final Long TUTORIAL_MAP_SEED = 4756899154123723533L;
    private static final String TUTORIAL_ENEMY_NAME = "Monsters";
    private static boolean enabled = false;
    private static final Vec3i ARMY_SPAWN_POS = new Vec3i(-2946, 68, -1177);
    private static final Vec3i ANIMAL_POS = new Vec3i(-2923, 67, -1184);
    private static final Vec3i MONSTER_ATTACK_SPAWN_POS = new Vec3i(-2968, 64, -1216);
    private static final Vec3i MONSTER_WORKER_POS = new Vec3i(-3082, 71, -1286);
    private static final Vec3i MAUSOLEUM_POS = new Vec3i(-3082, 71, -1293);
    private static final Vec3i FARM_POS_1 = new Vec3i(-3091, 70, -1291);
    private static final Vec3i FARM_POS_2 = new Vec3i(-3080, 70, -1281);
    private static final Vec3i GRAVEYARD_POS = new Vec3i(-3076, 71, -1278);
    private static final Vec3i TOWER_POS = new Vec3i(-3070, 71, -1286);
    private static final Vec3i SPIDER_LAIR_POS = new Vec3i(-3084, 71, -1302);
    private static final Vec3i TOWER_SKELETON_POS = new Vec3i(-3067, 82, -1283);
    private static final Vec3i GROUND_SKELETON_POS_1 = new Vec3i(-3074, 72, -1281);
    private static final Vec3i GROUND_SKELETON_POS_2 = new Vec3i(-3080, 71, -1272);
    private static final Vec3i SPIDER_POS = new Vec3i(-3082, 73, -1297);
    private static final Vec3i GRAVEYARD_ZOMBIE_POS = new Vec3i(-3074, 73, -1273);

    public static boolean isEnabled() {
        return enabled;
    }

    private static ServerLevel getServerLevel() {
        if (!PlayerServerEvents.players.isEmpty()) {
            return (ServerLevel)PlayerServerEvents.players.get(0).m_9236_();
        }
        return null;
    }

    public static void saveStage(TutorialStage stage) {
        ServerLevel serverLevel = TutorialServerEvents.getServerLevel();
        if (serverLevel != null) {
            TutorialSaveData tutorialData = TutorialSaveData.getInstance((LevelAccessor)serverLevel);
            tutorialData.stage = stage;
            tutorialData.save();
            serverLevel.m_8895_().m_78151_();
        }
    }

    public static TutorialStage loadStage(ServerLevel level) {
        if (level != null) {
            TutorialStage stage = TutorialSaveData.getInstance((LevelAccessor)level).stage;
            ReignOfNether.LOGGER.info("loaded tutorialStage in serverevents: " + String.valueOf((Object)stage));
            return stage;
        }
        return null;
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        ServerLevel serverLevel;
        MinecraftServer server = evt.getEntity().m_20194_();
        if (server == null) {
            PlayerServerEvents.sendMessageToAllPlayers("tutorial.reignofnether.server_not_found");
            return;
        }
        String levelName = server.m_129910_().m_5926_().m_46917_();
        Level level = evt.getEntity().m_9236_();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_7328_() == TUTORIAL_MAP_SEED.longValue() && levelName.equals(TUTORIAL_MAP_NAME)) {
            TutorialStage stage = TutorialServerEvents.loadStage(server.m_129880_(Level.f_46428_));
            if (stage == TutorialStage.COMPLETED) {
                return;
            }
            if (stage != null) {
                TutorialClientboundPacket.loadTutorialStage(stage);
            }
            TutorialClientboundPacket.enableTutorial();
            enabled = true;
        } else {
            TutorialClientboundPacket.disableTutorial();
            enabled = false;
        }
    }

    public static void setDayTime() {
        ServerLevel level = TutorialServerEvents.getServerLevel();
        if (level != null) {
            level.m_8615_(1000L);
        }
    }

    public static void setNightTime() {
        ServerLevel level = TutorialServerEvents.getServerLevel();
        if (level != null) {
            level.m_8615_(13000L);
        }
    }

    public static void spawnAnimals() {
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)EntityType.f_20510_, TutorialServerEvents.getServerLevel(), ANIMAL_POS, 3, "");
    }

    public static void spawnMonsterWorkers() {
        PlayerServerEvents.startRTSBot(TUTORIAL_ENEMY_NAME, Vec3.m_82512_((Vec3i)MAUSOLEUM_POS), Faction.MONSTERS);
        ResearchServerEvents.addCheat(TUTORIAL_ENEMY_NAME, "warpten");
        ResourcesServerEvents.addSubtractResources(new Resources(TUTORIAL_ENEMY_NAME, 10000, 10000, 10000));
    }

    public static void spawnMonstersA() {
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)((EntityType)EntityRegistrar.ZOMBIE_UNIT.get()), TutorialServerEvents.getServerLevel(), MONSTER_ATTACK_SPAWN_POS, 1, TUTORIAL_ENEMY_NAME);
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)((EntityType)EntityRegistrar.SKELETON_UNIT.get()), TutorialServerEvents.getServerLevel(), MONSTER_ATTACK_SPAWN_POS.m_122012_(), 1, TUTORIAL_ENEMY_NAME);
    }

    public static void spawnMonstersB() {
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)((EntityType)EntityRegistrar.ZOMBIE_UNIT.get()), TutorialServerEvents.getServerLevel(), MONSTER_ATTACK_SPAWN_POS, 4, TUTORIAL_ENEMY_NAME);
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)((EntityType)EntityRegistrar.SKELETON_UNIT.get()), TutorialServerEvents.getServerLevel(), MONSTER_ATTACK_SPAWN_POS.m_122012_(), 2, TUTORIAL_ENEMY_NAME);
    }

    public static void attackWithMonstersA() {
        BlockPos attackPos = null;
        for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
            if (!(building.getBuilding() instanceof TownCentre)) continue;
            attackPos = building.originPos;
        }
        if (attackPos == null) {
            for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
                if (!(building.getBuilding() instanceof Barracks)) continue;
                attackPos = building.originPos;
            }
        }
        if (attackPos != null) {
            for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
                if (!(entity instanceof ZombieUnit) && !(entity instanceof SkeletonUnit)) continue;
                ((AttackerUnit)entity).setAttackMoveTarget(attackPos);
            }
        }
    }

    public static void attackWithMonstersB() {
        BlockPos townCentrePos = null;
        BlockPos barracksPos = null;
        for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
            if (building.getBuilding() instanceof TownCentre) {
                townCentrePos = building.originPos;
                continue;
            }
            if (!(building.getBuilding() instanceof Barracks)) continue;
            barracksPos = building.originPos;
        }
        int zombiesCommanded = 0;
        int skeletonsCommanded = 0;
        for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
            if (entity instanceof ZombieUnit) {
                ZombieUnit zUnit = (ZombieUnit)entity;
                if (zombiesCommanded == 0 && barracksPos != null) {
                    zUnit.setAttackBuildingTarget(barracksPos);
                } else if (townCentrePos != null) {
                    zUnit.setAttackBuildingTarget(townCentrePos);
                }
                ++zombiesCommanded;
                continue;
            }
            if (!(entity instanceof SkeletonUnit)) continue;
            SkeletonUnit sUnit = (SkeletonUnit)entity;
            if (skeletonsCommanded == 0 && barracksPos != null) {
                sUnit.setAttackMoveTarget(barracksPos);
            } else if (townCentrePos != null) {
                sUnit.setAttackMoveTarget(townCentrePos);
            }
            ++skeletonsCommanded;
        }
    }

    public static void startBuildingMonsterBase() {
        int[] builderUnitIds = UnitServerEvents.getAllUnits().stream().filter(u -> u instanceof ZombieVillagerUnit).mapToInt(Entity::m_19879_).toArray();
        if (builderUnitIds.length > 0) {
            BuildingServerEvents.placeBuilding(Buildings.MAUSOLEUM, new BlockPos(MAUSOLEUM_POS.m_123341_(), MAUSOLEUM_POS.m_123342_(), MAUSOLEUM_POS.m_123343_()), Rotation.NONE, TUTORIAL_ENEMY_NAME, builderUnitIds, false, false);
        }
    }

    public static void expandMonsterBaseA() {
        int[] builderUnitIds = UnitServerEvents.getAllUnits().stream().filter(u -> u instanceof ZombieVillagerUnit).mapToInt(Entity::m_19879_).toArray();
        block4: for (int i = 0; i < builderUnitIds.length; ++i) {
            switch (i) {
                case 0: {
                    BuildingServerEvents.placeBuilding(Buildings.PUMPKIN_FARM, new BlockPos(FARM_POS_1), Rotation.NONE, TUTORIAL_ENEMY_NAME, new int[]{builderUnitIds[0]}, false, false);
                    continue block4;
                }
                case 1: {
                    BuildingServerEvents.placeBuilding(Buildings.PUMPKIN_FARM, new BlockPos(FARM_POS_2), Rotation.CLOCKWISE_90, TUTORIAL_ENEMY_NAME, new int[]{builderUnitIds[1]}, false, false);
                }
            }
        }
    }

    public static void expandMonsterBaseB() {
        int[] builderUnitIds = UnitServerEvents.getAllUnits().stream().filter(u -> u instanceof ZombieVillagerUnit).mapToInt(Entity::m_19879_).toArray();
        block5: for (int i = 0; i < builderUnitIds.length; ++i) {
            switch (i) {
                case 0: {
                    BuildingServerEvents.placeBuilding(Buildings.GRAVEYARD, new BlockPos(GRAVEYARD_POS), Rotation.NONE, TUTORIAL_ENEMY_NAME, new int[]{builderUnitIds[0]}, false, false);
                    continue block5;
                }
                case 1: {
                    BuildingServerEvents.placeBuilding(Buildings.DARK_WATCHTOWER, new BlockPos(TOWER_POS), Rotation.NONE, TUTORIAL_ENEMY_NAME, new int[]{builderUnitIds[1]}, false, false);
                    continue block5;
                }
                case 2: {
                    BuildingServerEvents.placeBuilding(Buildings.SPIDER_LAIR, new BlockPos(SPIDER_LAIR_POS), Rotation.NONE, TUTORIAL_ENEMY_NAME, new int[]{builderUnitIds[2]}, false, false);
                }
            }
        }
    }

    public static void spawnMonsterBaseArmy() {
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)((EntityType)EntityRegistrar.ZOMBIE_UNIT.get()), TutorialServerEvents.getServerLevel(), GRAVEYARD_ZOMBIE_POS, 3, TUTORIAL_ENEMY_NAME);
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)((EntityType)EntityRegistrar.SKELETON_UNIT.get()), TutorialServerEvents.getServerLevel(), GROUND_SKELETON_POS_1, 1, TUTORIAL_ENEMY_NAME);
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)((EntityType)EntityRegistrar.SKELETON_UNIT.get()), TutorialServerEvents.getServerLevel(), GROUND_SKELETON_POS_2, 1, TUTORIAL_ENEMY_NAME);
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)((EntityType)EntityRegistrar.SKELETON_UNIT.get()), TutorialServerEvents.getServerLevel(), TOWER_SKELETON_POS, 1, TUTORIAL_ENEMY_NAME);
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)((EntityType)EntityRegistrar.SPIDER_UNIT.get()), TutorialServerEvents.getServerLevel(), SPIDER_POS, 3, TUTORIAL_ENEMY_NAME);
    }

    public static void spawnFriendlyArmy() {
        if (PlayerServerEvents.players.isEmpty()) {
            return;
        }
        String ownerName = PlayerServerEvents.players.get(0).m_7755_().getString();
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)((EntityType)EntityRegistrar.VINDICATOR_UNIT.get()), TutorialServerEvents.getServerLevel(), ARMY_SPAWN_POS, 5, ownerName);
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)((EntityType)EntityRegistrar.PILLAGER_UNIT.get()), TutorialServerEvents.getServerLevel(), ARMY_SPAWN_POS.m_122019_(), 3, ownerName);
        UnitServerEvents.spawnMobs((EntityType<? extends Mob>)((EntityType)EntityRegistrar.IRON_GOLEM_UNIT.get()), TutorialServerEvents.getServerLevel(), ARMY_SPAWN_POS.m_122019_().m_122019_(), 1, ownerName);
    }
}

