/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit;

public class UnitProperties {
    private final boolean isWorker;
    private final boolean isAttacker;
    private final boolean isRanged;
    private final boolean isFlying;
    private final boolean isHero;
    private final float moveSpeedMultiplier;
    private final boolean canClimbLadders;
    private final boolean canDestroyTerrain;
    private final boolean canSwim;
    private final int buildTime;
    private final int populationCost;
    private final int populationProvided;
    private final boolean hasSpecialAbilities;
    private final boolean canGarrison;
    private final boolean canMount;
    private final boolean canBeRevived;
    private final float aggressionLevel;
    private final float defenseLevel;
    private final int visionRange;
    private final int attackRange;

    private UnitProperties(Builder builder) {
        this.isWorker = builder.isWorker;
        this.isAttacker = builder.isAttacker;
        this.isRanged = builder.isRanged;
        this.isFlying = builder.isFlying;
        this.isHero = builder.isHero;
        this.moveSpeedMultiplier = builder.moveSpeedMultiplier;
        this.canClimbLadders = builder.canClimbLadders;
        this.canDestroyTerrain = builder.canDestroyTerrain;
        this.canSwim = builder.canSwim;
        this.buildTime = builder.buildTime;
        this.populationCost = builder.populationCost;
        this.populationProvided = builder.populationProvided;
        this.hasSpecialAbilities = builder.hasSpecialAbilities;
        this.canGarrison = builder.canGarrison;
        this.canMount = builder.canMount;
        this.canBeRevived = builder.canBeRevived;
        this.aggressionLevel = builder.aggressionLevel;
        this.defenseLevel = builder.defenseLevel;
        this.visionRange = builder.visionRange;
        this.attackRange = builder.attackRange;
    }

    public static UnitProperties defaultProperties() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isWorker() {
        return this.isWorker;
    }

    public boolean isAttacker() {
        return this.isAttacker;
    }

    public boolean isRanged() {
        return this.isRanged;
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public boolean isHero() {
        return this.isHero;
    }

    public float getMoveSpeedMultiplier() {
        return this.moveSpeedMultiplier;
    }

    public boolean canClimbLadders() {
        return this.canClimbLadders;
    }

    public boolean canDestroyTerrain() {
        return this.canDestroyTerrain;
    }

    public boolean canSwim() {
        return this.canSwim;
    }

    public int getBuildTime() {
        return this.buildTime;
    }

    public int getPopulationCost() {
        return this.populationCost;
    }

    public int getPopulationProvided() {
        return this.populationProvided;
    }

    public boolean hasSpecialAbilities() {
        return this.hasSpecialAbilities;
    }

    public boolean canGarrison() {
        return this.canGarrison;
    }

    public boolean canMount() {
        return this.canMount;
    }

    public boolean canBeRevived() {
        return this.canBeRevived;
    }

    public float getAggressionLevel() {
        return this.aggressionLevel;
    }

    public float getDefenseLevel() {
        return this.defenseLevel;
    }

    public int getVisionRange() {
        return this.visionRange;
    }

    public int getAttackRange() {
        return this.attackRange;
    }

    public static class Builder {
        private boolean isWorker = false;
        private boolean isAttacker = true;
        private boolean isRanged = false;
        private boolean isFlying = false;
        private boolean isHero = false;
        private float moveSpeedMultiplier = 1.0f;
        private boolean canClimbLadders = true;
        private boolean canDestroyTerrain = false;
        private boolean canSwim = false;
        private int buildTime = 400;
        private int populationCost = 1;
        private int populationProvided = 0;
        private boolean hasSpecialAbilities = false;
        private boolean canGarrison = true;
        private boolean canMount = false;
        private boolean canBeRevived = false;
        private float aggressionLevel = 0.5f;
        private float defenseLevel = 0.5f;
        private int visionRange = 16;
        private int attackRange = 2;

        public Builder worker(boolean isWorker) {
            this.isWorker = isWorker;
            return this;
        }

        public Builder attacker(boolean isAttacker) {
            this.isAttacker = isAttacker;
            return this;
        }

        public Builder ranged(boolean isRanged) {
            this.isRanged = isRanged;
            return this;
        }

        public Builder flying(boolean isFlying) {
            this.isFlying = isFlying;
            return this;
        }

        public Builder hero(boolean isHero) {
            this.isHero = isHero;
            return this;
        }

        public Builder moveSpeedMultiplier(float multiplier) {
            this.moveSpeedMultiplier = multiplier;
            return this;
        }

        public Builder canClimbLadders(boolean canClimb) {
            this.canClimbLadders = canClimb;
            return this;
        }

        public Builder canDestroyTerrain(boolean canDestroy) {
            this.canDestroyTerrain = canDestroy;
            return this;
        }

        public Builder canSwim(boolean canSwim) {
            this.canSwim = canSwim;
            return this;
        }

        public Builder buildTime(int ticks) {
            this.buildTime = ticks;
            return this;
        }

        public Builder populationCost(int cost) {
            this.populationCost = cost;
            return this;
        }

        public Builder populationProvided(int provided) {
            this.populationProvided = provided;
            return this;
        }

        public Builder hasSpecialAbilities(boolean hasAbilities) {
            this.hasSpecialAbilities = hasAbilities;
            return this;
        }

        public Builder canGarrison(boolean canGarrison) {
            this.canGarrison = canGarrison;
            return this;
        }

        public Builder canMount(boolean canMount) {
            this.canMount = canMount;
            return this;
        }

        public Builder canBeRevived(boolean canRevive) {
            this.canBeRevived = canRevive;
            return this;
        }

        public Builder aggressionLevel(float level) {
            this.aggressionLevel = level;
            return this;
        }

        public Builder defenseLevel(float level) {
            this.defenseLevel = level;
            return this;
        }

        public Builder visionRange(int range) {
            this.visionRange = range;
            return this;
        }

        public Builder attackRange(int range) {
            this.attackRange = range;
            return this;
        }

        public UnitProperties build() {
            return new UnitProperties(this);
        }
    }
}

