/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.adapter;

import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class AdapterGarrisonGoal
extends Goal {
    private final Mob mob;
    private BuildingPlacement buildingTarget;
    private BlockPos moveTarget;

    public AdapterGarrisonGoal(Mob mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.buildingTarget != null;
    }

    public boolean m_8045_() {
        return this.buildingTarget != null && this.moveTarget != null && !this.mob.m_21573_().m_26571_();
    }

    public void m_8056_() {
        if (this.moveTarget != null) {
            this.mob.m_21573_().m_26519_((double)this.moveTarget.m_123341_(), (double)this.moveTarget.m_123342_(), (double)this.moveTarget.m_123343_(), 1.0);
        }
    }

    public void m_8037_() {
        BuildingPlacement buildingPlacement = this.buildingTarget;
        if (!(buildingPlacement instanceof GarrisonableBuilding)) {
            this.stopGarrisoning();
            return;
        }
        GarrisonableBuilding garr = (GarrisonableBuilding)((Object)buildingPlacement);
        this.recalcMoveTarget();
        if (this.moveTarget == null) {
            return;
        }
        double d2 = this.mob.m_20238_(new Vec3((double)this.moveTarget.m_123341_() + 0.5, (double)this.moveTarget.m_123342_() + 0.5, (double)this.moveTarget.m_123343_() + 0.5));
        if (d2 <= 3.0) {
            if (!garr.isFull() && this.buildingTarget.isBuilt) {
                BlockPos bp = this.buildingTarget.originPos.m_121955_((Vec3i)garr.getEntryPosition());
                this.mob.m_6021_((double)((float)bp.m_123341_() + 0.5f), (double)((float)bp.m_123342_() + 0.5f), (double)((float)bp.m_123343_() + 0.5f));
            }
            this.stopGarrisoning();
        }
    }

    private void recalcMoveTarget() {
        if (this.buildingTarget != null) {
            this.moveTarget = this.buildingTarget.getClosestGroundPos(this.mob.m_20097_(), 1);
            if (this.moveTarget != null && this.mob.m_21573_().m_26571_()) {
                this.mob.m_21573_().m_26519_((double)this.moveTarget.m_123341_(), (double)this.moveTarget.m_123342_(), (double)this.moveTarget.m_123343_(), 1.0);
            }
        }
    }

    public void setBuildingTarget(BlockPos blockPos, String ownerName) {
        if (blockPos == null) {
            return;
        }
        boolean clientside = this.mob.m_9236_().m_5776_();
        BuildingPlacement building = BuildingUtils.findBuilding(clientside, blockPos);
        if (building == null || !(building instanceof GarrisonableBuilding)) {
            this.stopGarrisoning();
            return;
        }
        boolean isAllied = AlliancesServerEvents.isAllied(ownerName, building.ownerName);
        if (!building.ownerName.equals(ownerName) && !isAllied) {
            this.stopGarrisoning();
            return;
        }
        this.buildingTarget = building;
        this.recalcMoveTarget();
        this.m_8056_();
    }

    public void stopGarrisoning() {
        this.buildingTarget = null;
        this.moveTarget = null;
        this.mob.m_21573_().m_26573_();
    }
}

