/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.adapter;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AdapterRangedAttackGoal
extends Goal {
    private final Mob mob;
    private final double range;
    private int cooldown;

    public AdapterRangedAttackGoal(Mob mob, double range) {
        this.mob = mob;
        this.range = range;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.cooldown = 0;
    }

    public boolean m_8036_() {
        LivingEntity t = this.mob.m_5448_();
        return t != null && t.m_6084_();
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_()) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        double dist = this.mob.m_20270_((Entity)target);
        boolean sees = this.mob.m_21574_().m_148306_((Entity)target);
        if (dist > this.range || !sees) {
            this.mob.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.mob.m_21573_().m_26573_();
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (dist <= this.range && sees) {
            Level level = this.mob.m_9236_();
            Vec3 from = this.mob.m_146892_();
            Vec3 to = target.m_146892_();
            double dx = to.f_82479_ - from.f_82479_;
            double dy = to.f_82480_ - from.f_82480_;
            double dz = to.f_82481_ - from.f_82481_;
            Arrow arrow = new Arrow(level, (LivingEntity)this.mob);
            arrow.m_6034_(from.f_82479_, from.f_82480_, from.f_82481_);
            float velocity = 1.6f;
            float inaccuracy = 6.0f;
            arrow.m_6686_(dx, dy + dist * 0.05, dz, velocity, inaccuracy);
            double base = this.mob.m_21051_(Attributes.f_22281_) != null ? this.mob.m_21051_(Attributes.f_22281_).m_22115_() : 2.0;
            arrow.m_36781_(Math.max(1.0, base * 0.75));
            arrow.m_5602_((Entity)this.mob);
            level.m_7967_((Entity)arrow);
            this.cooldown = 20;
        }
    }
}

