/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.adapter;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.buildings.placements.PortalPlacement;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.datapack.UnitScriptEngine;
import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSource;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientboundPacket;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.unit.UnitProperties;
import com.solegendary.reignofnether.unit.UnitRegistry;
import com.solegendary.reignofnether.unit.UnitType;
import com.solegendary.reignofnether.unit.adapter.AdapterGarrisonGoal;
import com.solegendary.reignofnether.unit.adapter.AdapterRangedAttackGoal;
import com.solegendary.reignofnether.unit.adapter.RTSAttackGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DatapackUnitAdapter {
    public static boolean ALLOW_TERRAIN_DESTRUCTION = false;
    private static final Map<UUID, AdaptedState> STATES = new ConcurrentHashMap<UUID, AdaptedState>();

    public static boolean isAdapted(LivingEntity entity) {
        return STATES.containsKey(entity.m_20148_());
    }

    @Nullable
    public static AdaptedState getState(LivingEntity entity) {
        return STATES.get(entity.m_20148_());
    }

    public static void register(Mob mob, UnitType<?> unitType, String ownerName) {
        if (DatapackUnitAdapter.isAdapted((LivingEntity)mob)) {
            return;
        }
        try {
            ArrayList goals = new ArrayList(mob.f_21345_.m_148105_());
            for (Object g : goals) {
                mob.f_21345_.m_25363_(g.m_26015_());
            }
            ArrayList targets = new ArrayList(mob.f_21346_.m_148105_());
            for (WrappedGoal g : targets) {
                mob.f_21346_.m_25363_(g.m_26015_());
            }
        }
        catch (Throwable t) {
            ReignOfNether.LOGGER.warn("Failed to clear AI goals for {}: {}", (Object)mob.m_6095_().m_147048_(), (Object)t.getMessage());
        }
        try {
            mob.f_21345_.m_25352_(2, (Goal)new RTSAttackGoal(mob));
        }
        catch (Throwable t) {
            ReignOfNether.LOGGER.warn("Failed to add RTSAttackGoal to {}: {}", (Object)mob.m_6095_().m_147048_(), (Object)t.getMessage());
        }
        AdaptedState st = new AdaptedState(mob.m_20148_(), unitType.getId(), ownerName);
        STATES.put(mob.m_20148_(), st);
        try {
            mob.m_21553_(true);
        }
        catch (Throwable targets) {
            // empty catch block
        }
        try {
            boolean allowGarrison = true;
            try {
                UnitProperties p = unitType.getProperties();
                if (p != null) {
                    allowGarrison = p.canGarrison();
                }
            }
            catch (Throwable p) {
                // empty catch block
            }
            if (allowGarrison) {
                st.garrisonGoal = new AdapterGarrisonGoal(mob);
                mob.f_21345_.m_25352_(3, (Goal)st.garrisonGoal);
            }
        }
        catch (Throwable t) {
            ReignOfNether.LOGGER.warn("Failed to add AdapterGarrisonGoal to {}: {}", (Object)mob.m_6095_().m_147048_(), (Object)t.getMessage());
        }
        try {
            UnitType<ResourceLocation> ut = UnitRegistry.getUnitType(st.unitId);
            if (ut != null && ut.getProperties() != null && ut.getProperties().isRanged()) {
                double range = Math.max(ut.getProperties().getAttackRange(), 12);
                mob.f_21345_.m_25352_(4, (Goal)new AdapterRangedAttackGoal(mob, range));
            }
        }
        catch (Throwable t) {
            ReignOfNether.LOGGER.warn("Failed to add AdapterRangedAttackGoal to {}: {}", (Object)mob.m_6095_().m_147048_(), (Object)t.getMessage());
        }
        try {
            UnitProperties props;
            UnitType<ResourceLocation> ut2 = UnitRegistry.getUnitType(st.unitId);
            if (ut2 != null && (props = ut2.getProperties()) != null) {
                AttributeInstance hp;
                AttributeInstance armor;
                double scale;
                AttributeInstance atk;
                AttributeInstance follow;
                double base;
                AttributeInstance inst;
                if (props.isFlying()) {
                    mob.m_20242_(true);
                }
                if (mob.m_21204_().m_22171_(Attributes.f_22279_) && (inst = mob.m_21051_(Attributes.f_22279_)) != null) {
                    base = inst.m_22115_();
                    double mult = Math.max(0.1, (double)props.getMoveSpeedMultiplier());
                    inst.m_22100_(base * mult);
                }
                if (mob.m_21204_().m_22171_(Attributes.f_22277_) && (follow = mob.m_21051_(Attributes.f_22277_)) != null && props.getVisionRange() > 0) {
                    follow.m_22100_((double)props.getVisionRange());
                }
                if (mob.m_21204_().m_22171_(Attributes.f_22281_) && (atk = mob.m_21051_(Attributes.f_22281_)) != null) {
                    base = atk.m_22115_();
                    scale = 1.0 + Math.max(0.0, Math.min(1.0, (double)props.getAggressionLevel())) * 0.3;
                    atk.m_22100_(base * scale);
                }
                if (mob.m_21204_().m_22171_(Attributes.f_22284_) && (armor = mob.m_21051_(Attributes.f_22284_)) != null) {
                    base = armor.m_22115_();
                    scale = 1.0 + Math.max(0.0, Math.min(1.0, (double)props.getDefenseLevel())) * 0.5;
                    armor.m_22100_(base * scale);
                }
                if (mob.m_21204_().m_22171_(Attributes.f_22276_) && (hp = mob.m_21051_(Attributes.f_22276_)) != null) {
                    base = hp.m_22115_();
                    scale = 1.0 + Math.max(0.0, Math.min(1.0, (double)props.getDefenseLevel())) * 0.2;
                    hp.m_22100_(base * scale);
                }
                if (props.canSwim()) {
                    mob.m_21441_(BlockPathTypes.WATER, -1.0f);
                }
                mob.m_274367_(props.canClimbLadders() ? 1.0f : 0.6f);
            }
        }
        catch (Throwable t) {
            ReignOfNether.LOGGER.warn("Failed to apply datapack unit properties to {}: {}", (Object)mob.m_6095_().m_147048_(), (Object)t.getMessage());
        }
        UnitScriptEngine.ScriptBundle scripts = UnitScriptEngine.getScripts(unitType.getId());
        if (scripts != null && scripts.onSpawn != null) {
            try {
                scripts.onSpawn.run();
            }
            catch (Exception ex) {
                ReignOfNether.LOGGER.error("Error in unit AI on_spawn for {}: {}", (Object)unitType.getId(), (Object)ex.getMessage());
            }
        }
    }

    public static void unregister(LivingEntity entity) {
        STATES.remove(entity.m_20148_());
    }

    public static void setOwner(Mob mob, String owner) {
        AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
        if (st != null) {
            st.ownerName = owner;
        }
    }

    public static void setMoveTarget(Mob mob, @Nullable BlockPos pos) {
        AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
        if (st != null) {
            st.moveTarget = pos;
            st.recalcPathCooldown = 0;
        }
    }

    public static void setHold(Mob mob, boolean hold) {
        AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
        if (st != null) {
            st.holdPosition = hold;
        }
    }

    public static void setForcedTarget(Mob mob, @Nullable LivingEntity target) {
        AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
        if (st != null) {
            st.forcedTarget = target;
        }
    }

    public static boolean hasForcedTarget(Mob mob) {
        AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
        return st != null && st.forcedTarget != null && st.forcedTarget.m_6084_();
    }

    public static void garrison(Mob mob, BlockPos buildingPos) {
        AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
        if (st == null || st.garrisonGoal == null) {
            return;
        }
        st.garrisonGoal.setBuildingTarget(buildingPos, st.ownerName);
    }

    public static void ungarrison(Mob mob) {
        Level level = mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
            if (!building.isPosInsideBuilding(mob.m_20097_()) || mob.m_20097_().m_123342_() <= building.originPos.m_123342_() + 2 || !(building instanceof GarrisonableBuilding)) continue;
            GarrisonableBuilding garr = (GarrisonableBuilding)((Object)building);
            BlockPos bp = building.originPos.m_121955_((Vec3i)garr.getExitPosition());
            mob.m_6021_((double)((float)bp.m_123341_() + 0.5f), (double)((float)bp.m_123342_() + 0.5f), (double)((float)bp.m_123343_() + 0.5f));
            break;
        }
    }

    public static List<Mob> getAdaptedMobs(ServerLevel level) {
        if (STATES.isEmpty()) {
            return List.of();
        }
        ArrayList<Mob> out = new ArrayList<Mob>();
        for (UUID id : STATES.keySet()) {
            Mob mob;
            Entity e = level.m_8791_(id);
            if (!(e instanceof Mob) || (mob = (Mob)e).m_213877_() || mob.m_21224_()) continue;
            out.add(mob);
        }
        return out;
    }

    public static void startGathering(Mob mob, ResourceName name, BlockPos target) {
        AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
        if (st == null) {
            return;
        }
        try {
            UnitType<ResourceLocation> ut = UnitRegistry.getUnitType(st.unitId);
            if (ut == null || ut.getProperties() == null || !ut.getProperties().isWorker()) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        st.hunting = false;
        st.huntCenter = null;
        st.returnBuilding = null;
        st.resumeHuntAfterDeposit = false;
        st.gatherTargetName = name;
        st.gatherTarget = target;
        st.targetResourceSource = null;
        st.gatherTicksLeft = 0;
        st.todoGatherTargets.clear();
        DatapackUnitAdapter.setForcedTarget(mob, null);
        DatapackUnitAdapter.setMoveTarget(mob, target);
    }

    public static void startHunting(Mob mob, BlockPos center, int radius) {
        AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
        if (st == null) {
            return;
        }
        try {
            UnitType<ResourceLocation> ut = UnitRegistry.getUnitType(st.unitId);
            if (ut == null || ut.getProperties() == null || !ut.getProperties().isWorker()) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        st.hunting = true;
        st.huntCenter = center;
        st.huntRadius = Math.max(8, Math.min(radius, 96));
        st.returnBuilding = null;
        st.resumeGatherAfterDeposit = false;
    }

    public static void stopJobs(Mob mob) {
        AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
        if (st == null) {
            return;
        }
        st.hunting = false;
        st.huntCenter = null;
        st.gatherTarget = null;
        st.todoGatherTargets.clear();
        st.returnBuilding = null;
        st.resumeGatherAfterDeposit = false;
        st.resumeHuntAfterDeposit = false;
    }

    public static void returnResourcesToClosest(Mob mob) {
        Level level;
        AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
        if (st == null || mob.m_9236_().m_5776_() || !((level = mob.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        BuildingPlacement closest = null;
        double best = Double.MAX_VALUE;
        for (BuildingPlacement b : BuildingServerEvents.getBuildings()) {
            BlockPos bp;
            double d;
            if (!b.isBuilt || !b.getBuilding().canAcceptResources || st.ownerName == null || !st.ownerName.equals(b.ownerName) || !((d = (bp = b.getClosestGroundPos(mob.m_20097_(), 1)).m_123331_((Vec3i)mob.m_20097_())) < best)) continue;
            best = d;
            closest = b;
        }
        if (closest != null) {
            st.returnBuilding = closest;
            DatapackUnitAdapter.setMoveTarget(mob, closest.getClosestGroundPos(mob.m_20097_(), 1));
        }
    }

    public static void returnResourcesTo(Mob mob, BuildingPlacement building) {
        AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
        if (st == null) {
            return;
        }
        st.returnBuilding = building;
        DatapackUnitAdapter.setMoveTarget(mob, building.getClosestGroundPos(mob.m_20097_(), 1));
    }

    public static int countWorkersNear(ServerLevel level, String ownerName, BlockPos center, double range) {
        List<Mob> mobs = DatapackUnitAdapter.getAdaptedMobs(level);
        if (mobs.isEmpty()) {
            return 0;
        }
        double r2 = range * range;
        int count = 0;
        for (Mob mob : mobs) {
            UnitType<ResourceLocation> ut;
            AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
            if (st == null || ownerName != null && !ownerName.isBlank() && !ownerName.equals(st.ownerName) || (ut = UnitRegistry.getUnitType(st.unitId)) == null || ut.getProperties() == null || !ut.getProperties().isWorker() || !(mob.m_20275_((double)center.m_123341_() + 0.5, (double)center.m_123342_() + 0.5, (double)center.m_123343_() + 0.5) <= r2)) continue;
            ++count;
        }
        return count;
    }

    public static void setBuildingAnimationForNearbyWorkers(ServerLevel level, String ownerName, BlockPos center, double range, boolean building) {
        List<Mob> mobs = DatapackUnitAdapter.getAdaptedMobs(level);
        if (mobs.isEmpty()) {
            return;
        }
        double r2 = range * range;
        for (Mob mob : mobs) {
            UnitType<ResourceLocation> ut;
            AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
            if (st == null || ownerName != null && !ownerName.isBlank() && !ownerName.equals(st.ownerName) || (ut = UnitRegistry.getUnitType(st.unitId)) == null || ut.getProperties() == null || !ut.getProperties().isWorker() || !(mob.m_20275_((double)center.m_123341_() + 0.5, (double)center.m_123342_() + 0.5, (double)center.m_123343_() + 0.5) <= r2) || !building) continue;
            st.buildingAnimTTL = 12;
            DatapackUnitAdapter.setBuildingState(mob, st, true);
        }
    }

    private static void setBuildingState(Mob mob, AdaptedState st, boolean building) {
        if (building) {
            if (!st.buildingAnim) {
                st.buildingAnim = true;
                st.buildSwingCooldown = 0;
                try {
                    ItemStack cur = mob.m_6844_(EquipmentSlot.MAINHAND);
                    st.prevMainHand = cur.m_41777_();
                    if (!cur.m_150930_(Items.f_42384_)) {
                        mob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42384_));
                    }
                }
                catch (Throwable cur) {}
            }
        } else if (st.buildingAnim) {
            st.buildingAnim = false;
            try {
                if (!st.prevMainHand.m_41619_()) {
                    mob.m_8061_(EquipmentSlot.MAINHAND, st.prevMainHand);
                } else {
                    ItemStack cur = mob.m_6844_(EquipmentSlot.MAINHAND);
                    if (cur.m_150930_(Items.f_42384_)) {
                        mob.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            st.prevMainHand = ItemStack.f_41583_;
            st.buildSwingCooldown = 0;
        }
    }

    public static void tickAll(ServerLevel level) {
        if (STATES.isEmpty()) {
            return;
        }
        for (UUID id : new ArrayList<UUID>(STATES.keySet())) {
            BlockPos approach;
            Mob mob;
            AdaptedState st;
            block114: {
                block113: {
                    LivingEntity le;
                    LivingEntity e;
                    st = STATES.get(id);
                    if (st == null) continue;
                    Entity entity = level.m_8791_(id);
                    LivingEntity livingEntity = e = entity instanceof LivingEntity ? (le = (LivingEntity)entity) : null;
                    if (!(e instanceof Mob)) break block113;
                    mob = (Mob)e;
                    if (!e.m_213877_() && !e.m_21224_()) break block114;
                }
                STATES.remove(id);
                continue;
            }
            UnitType<ResourceLocation> unitType = UnitRegistry.getUnitType(st.unitId);
            double speedFactor = 1.0;
            boolean isFlying = false;
            float aggression = 0.0f;
            float defense = 0.0f;
            boolean isWorkerUnit = false;
            if (unitType != null) {
                UnitProperties props;
                block112: {
                    UnitScriptEngine.ScriptBundle scripts = UnitScriptEngine.getScripts(unitType.getId());
                    if (scripts != null && scripts.onTick != null) {
                        try {
                            HashMap<String, Serializable> ctx = new HashMap<String, Serializable>();
                            ctx.put("id", Integer.valueOf(mob.m_19879_()));
                            ctx.put("x", Double.valueOf(mob.m_20185_()));
                            ctx.put("y", Double.valueOf(mob.m_20186_()));
                            ctx.put("z", Double.valueOf(mob.m_20189_()));
                            ctx.put("has_target", Boolean.valueOf(mob.m_5448_() != null));
                            ctx.put("target_id", Integer.valueOf(mob.m_5448_() != null ? mob.m_5448_().m_19879_() : -1));
                            Map<String, Object> ret = scripts.onTick.apply(ctx);
                            if (ret == null || !ret.containsKey("cmd")) break block112;
                            String cmd = String.valueOf(ret.get("cmd"));
                            switch (cmd) {
                                case "move": {
                                    int tx = (int)Math.round(((Number)ret.getOrDefault("x", mob.m_20185_())).doubleValue());
                                    int ty = (int)Math.round(((Number)ret.getOrDefault("y", mob.m_20186_())).doubleValue());
                                    int tz = (int)Math.round(((Number)ret.getOrDefault("z", mob.m_20189_())).doubleValue());
                                    DatapackUnitAdapter.setForcedTarget(mob, null);
                                    DatapackUnitAdapter.setMoveTarget(mob, new BlockPos(tx, ty, tz));
                                    break;
                                }
                                case "attack": {
                                    LivingEntity tgt;
                                    int tid = (int)Math.round(((Number)ret.getOrDefault("target", -1)).doubleValue());
                                    LivingEntity livingEntity = tgt = tid >= 0 ? (LivingEntity)level.m_6815_(tid) : null;
                                    if (tgt != null) {
                                        DatapackUnitAdapter.setForcedTarget(mob, tgt);
                                    }
                                    break;
                                }
                                case "hold": {
                                    boolean bl;
                                    Object tz = ret.get("hold");
                                    if (tz instanceof Boolean) {
                                        Boolean b = (Boolean)tz;
                                        bl = b;
                                    } else {
                                        bl = true;
                                    }
                                    boolean hold = bl;
                                    DatapackUnitAdapter.setHold(mob, hold);
                                    break;
                                }
                                case "clear": {
                                    DatapackUnitAdapter.setForcedTarget(mob, null);
                                    DatapackUnitAdapter.setMoveTarget(mob, null);
                                }
                            }
                        }
                        catch (Exception ex) {
                            ReignOfNether.LOGGER.error("Error in unit AI on_tick for {}: {}", (Object)unitType.getId(), (Object)ex.getMessage());
                        }
                    }
                }
                if ((props = unitType.getProperties()) != null) {
                    speedFactor = Math.max(0.1, (double)props.getMoveSpeedMultiplier());
                    isFlying = props.isFlying();
                    aggression = Math.max(0.0f, Math.min(1.0f, props.getAggressionLevel()));
                    defense = Math.max(0.0f, Math.min(1.0f, props.getDefenseLevel()));
                    isWorkerUnit = props.isWorker();
                }
            }
            if (st.aggroCooldown > 0) {
                --st.aggroCooldown;
            }
            if (st.terrainBreakCooldown > 0) {
                --st.terrainBreakCooldown;
            }
            if (!st.holdPosition && st.forcedTarget == null && mob.m_5448_() == null && aggression > 0.0f && st.aggroCooldown <= 0 && unitType != null) {
                double radius = Math.max(8.0, unitType.getProperties() != null ? (double)unitType.getProperties().getVisionRange() : 16.0);
                AABB box = new AABB(mob.m_20183_()).m_82400_(radius *= Math.max(0.5, (double)aggression));
                List candidates = level.m_6443_(LivingEntity.class, box, le2 -> le2 != mob && le2.m_6084_());
                for (LivingEntity cand : candidates) {
                    String otherOwner = null;
                    if (cand instanceof Unit) {
                        Unit u = (Unit)cand;
                        otherOwner = u.getOwnerName();
                    } else if (cand instanceof Player) {
                        Player p = (Player)cand;
                        otherOwner = p.m_7755_().getString();
                    }
                    if (otherOwner == null || otherOwner.isBlank() || st.ownerName == null || st.ownerName.isBlank() || AlliancesServerEvents.isAllied(st.ownerName, otherOwner)) continue;
                    DatapackUnitAdapter.setForcedTarget(mob, cand);
                    st.aggroCooldown = 40;
                    break;
                }
            }
            if (st.forcedTarget != null && st.forcedTarget.m_6084_()) {
                if (mob.m_5448_() != st.forcedTarget) {
                    mob.m_6710_(st.forcedTarget);
                }
                if (mob.f_19797_ % 10 == 0) {
                    mob.m_21573_().m_5624_((Entity)st.forcedTarget, 1.2);
                }
                if (isFlying) {
                    Vec3 tp = st.forcedTarget.m_20182_();
                    mob.m_21566_().m_6849_(tp.f_82479_, tp.f_82480_, tp.f_82481_, speedFactor);
                }
                DatapackUnitAdapter.maybeBreakSoftBlockToward(level, mob, st, st.forcedTarget.m_20183_(), unitType);
            } else if (st.attackBuildingPos != null) {
                BuildingPlacement b = BuildingUtils.findBuilding(false, st.attackBuildingPos);
                if (b == null || b.getBlocksPlaced() <= 0) {
                    st.attackBuildingPos = null;
                } else {
                    approach = b.getClosestGroundPos(mob.m_20097_(), 1);
                    double dist2 = mob.m_20238_(Vec3.m_82512_((Vec3i)approach));
                    if (dist2 > 4.0) {
                        if (st.recalcPathCooldown <= 0 || mob.m_21573_().m_26571_()) {
                            mob.m_21573_().m_26519_((double)approach.m_123341_(), (double)approach.m_123342_(), (double)approach.m_123343_(), 1.0);
                            st.recalcPathCooldown = 10;
                        } else {
                            --st.recalcPathCooldown;
                        }
                        if (isFlying) {
                            Vec3 ap = Vec3.m_82512_((Vec3i)approach);
                            mob.m_21566_().m_6849_(ap.f_82479_, ap.f_82480_, ap.f_82481_, speedFactor);
                        }
                        DatapackUnitAdapter.maybeBreakSoftBlockToward(level, mob, st, approach, unitType);
                    } else if (st.attackCooldownTicks <= 0) {
                        double baseDmg = 1.0;
                        AttributeInstance ai = mob.m_21051_(Attributes.f_22281_);
                        if (ai != null) {
                            baseDmg = Math.max(1.0, ai.m_22115_());
                        }
                        double dmgFloat = baseDmg * (1.0 + (double)aggression * 0.25) * (double)b.getMeleeDamageMult();
                        int dmg = (int)Math.floor(dmgFloat);
                        if (mob.m_217043_().m_188500_() < dmgFloat - (double)dmg) {
                            ++dmg;
                        }
                        if (dmg > 0) {
                            b.destroyRandomBlocks(dmg);
                            b.lastAttacker = mob;
                        }
                        mob.m_6674_(InteractionHand.MAIN_HAND);
                        st.attackCooldownTicks = 20;
                    } else {
                        --st.attackCooldownTicks;
                    }
                }
            } else if (st.moveTarget != null) {
                BuildingPlacement dest;
                BlockPos entry;
                PortalPlacement portal;
                BuildingPlacement building;
                double dist2 = mob.m_20238_(Vec3.m_82512_((Vec3i)st.moveTarget));
                if (dist2 < 4.0 || st.holdPosition && mob.m_21573_().m_26571_()) {
                    if (!st.holdPosition) {
                        st.moveTarget = null;
                    }
                } else {
                    if (st.recalcPathCooldown <= 0 || mob.m_21573_().m_26571_()) {
                        mob.m_21573_().m_26519_((double)st.moveTarget.m_123341_(), (double)st.moveTarget.m_123342_(), (double)st.moveTarget.m_123343_(), 1.0);
                        st.recalcPathCooldown = 20;
                    } else {
                        --st.recalcPathCooldown;
                    }
                    if (isFlying) {
                        Vec3 mp = Vec3.m_82512_((Vec3i)st.moveTarget);
                        mob.m_21566_().m_6849_(mp.f_82479_, mp.f_82480_, mp.f_82481_, speedFactor);
                    }
                    DatapackUnitAdapter.maybeBreakSoftBlockToward(level, mob, st, st.moveTarget, unitType);
                }
                if ((building = BuildingUtils.findBuilding(false, st.moveTarget)) instanceof PortalPlacement && (portal = (PortalPlacement)building).getPortalType() == PortalPlacement.PortalType.TRANSPORT && portal.hasDestination() && mob.m_20238_(Vec3.m_82512_((Vec3i)(entry = portal.getClosestGroundPos(mob.m_20097_(), 1)))) <= 3.0 && (dest = BuildingUtils.findBuilding(false, portal.destination)) instanceof PortalPlacement) {
                    PortalPlacement destPortal = (PortalPlacement)dest;
                    BlockPos exit = dest.originPos.m_7918_(0, 1, 2);
                    mob.m_6021_((double)exit.m_123341_() + 0.5, (double)exit.m_123342_() + 0.5, (double)exit.m_123343_() + 0.5);
                    st.moveTarget = null;
                }
            } else if (mob.m_5448_() != null && mob.m_5448_().m_21224_()) {
                mob.m_6710_(null);
            }
            if (st.buildingAnimTTL > 0) {
                --st.buildingAnimTTL;
            } else if (st.buildingAnim) {
                DatapackUnitAdapter.setBuildingState(mob, st, false);
            }
            if (st.buildingAnim) {
                try {
                    ItemStack cur = mob.m_6844_(EquipmentSlot.MAINHAND);
                    if (!cur.m_150930_(Items.f_42384_)) {
                        mob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42384_));
                    }
                }
                catch (Throwable cur) {
                    // empty catch block
                }
                if (mob.f_19797_ % 10 == 0) {
                    mob.m_6674_(InteractionHand.MAIN_HAND);
                }
            }
            if (isWorkerUnit) {
                try {
                    if (mob.f_19797_ % 2 == 0) {
                        for (ItemEntity item : level.m_45976_(ItemEntity.class, mob.m_20191_().m_82377_(1.0, 0.5, 1.0))) {
                            ResourceSource rs;
                            ItemStack stack;
                            if (item.m_213877_() || item.m_32063_() || (stack = item.m_32055_()).m_41619_() || (rs = ResourceSources.getFromItem(stack.m_41720_())) == null) continue;
                            while (stack.m_41613_() > 0 && DatapackUnitAdapter.getCarriedValue(st) < st.maxResources) {
                                mob.m_21053_(item);
                                mob.m_7938_((Entity)item, 1);
                                st.items.add(new ItemStack((ItemLike)stack.m_41720_(), 1));
                                stack.m_41774_(1);
                            }
                            if (stack.m_41613_() <= 0) {
                                item.m_146870_();
                            }
                            if (!DatapackUnitAdapter.atThreshold(st, st.ownerName, level) || st.returnBuilding != null) continue;
                            st.resumeGatherAfterDeposit = st.gatherTarget != null;
                            st.resumeHuntAfterDeposit = st.hunting;
                            DatapackUnitAdapter.returnResourcesToClosest(mob);
                        }
                    }
                }
                catch (Throwable cur) {
                    // empty catch block
                }
            }
            if (isWorkerUnit && st.returnBuilding != null) {
                BuildingPlacement b = st.returnBuilding;
                if (!BuildingServerEvents.getBuildings().contains(b) || !b.isBuilt) {
                    st.returnBuilding = null;
                } else {
                    approach = b.getClosestGroundPos(mob.m_20097_(), 1);
                    if (mob.m_20238_(Vec3.m_82512_((Vec3i)approach)) > 2.25) {
                        if (st.recalcPathCooldown <= 0 || mob.m_21573_().m_26571_()) {
                            mob.m_21573_().m_26519_((double)approach.m_123341_(), (double)approach.m_123342_(), (double)approach.m_123343_(), 1.0);
                            st.recalcPathCooldown = 10;
                        } else {
                            --st.recalcPathCooldown;
                        }
                    } else {
                        Resources res = Resources.getTotalResourcesFromItems(st.items);
                        if (res.getTotalValue() > 0) {
                            res.ownerName = st.ownerName;
                            ResourcesServerEvents.addSubtractResources(res);
                            ResourcesClientboundPacket.showFloatingText(res, mob.m_20183_());
                            st.items.clear();
                        }
                        st.returnBuilding = null;
                        if (st.resumeGatherAfterDeposit && st.gatherTarget != null) {
                            DatapackUnitAdapter.setMoveTarget(mob, st.gatherTarget);
                        } else if (st.resumeHuntAfterDeposit && st.huntCenter != null) {
                            st.hunting = true;
                        }
                        st.resumeGatherAfterDeposit = false;
                        st.resumeHuntAfterDeposit = false;
                    }
                }
            }
            if (isWorkerUnit && st.gatherTarget != null && st.gatherTargetName != ResourceName.NONE && st.returnBuilding == null) {
                ResourceSource cur;
                if (st.targetResourceSource == null) {
                    st.targetResourceSource = ResourceSources.getFromBlockPos(st.gatherTarget, (Level)level);
                    int n = st.gatherTicksLeft = st.targetResourceSource != null ? st.targetResourceSource.ticksToGather : 0;
                }
                if ((cur = ResourceSources.getFromBlockPos(st.gatherTarget, (Level)level)) == null || cur.resourceName != st.gatherTargetName) {
                    if (!st.todoGatherTargets.isEmpty()) {
                        st.gatherTarget = st.todoGatherTargets.remove(0);
                        st.targetResourceSource = null;
                        continue;
                    }
                    st.gatherTarget = null;
                    st.targetResourceSource = null;
                    st.gatherTicksLeft = 0;
                } else {
                    DatapackUnitAdapter.setMoveTarget(mob, st.gatherTarget);
                    double d2 = mob.m_20238_(Vec3.m_82512_((Vec3i)st.gatherTarget));
                    if (d2 <= 4.0) {
                        st.gatherTicksLeft = Math.max(0, st.gatherTicksLeft - 1);
                        if (st.gatherTicksLeft == 0) {
                            BlockState bs = level.m_8055_(st.gatherTarget);
                            if (st.gatherTargetName == ResourceName.ORE && bs.m_60734_() != Blocks.f_152588_) {
                                level.m_46961_(st.gatherTarget, false);
                                BlockState replace = Blocks.f_50652_.m_49966_();
                                try {
                                    if (BuildingUtils.isInNetherRange(false, st.gatherTarget)) {
                                        replace = ((Block)BlockRegistrar.WALKABLE_MAGMA_BLOCK.get()).m_49966_();
                                    }
                                }
                                catch (Throwable dest) {
                                    // empty catch block
                                }
                                level.m_46597_(st.gatherTarget, replace);
                            } else {
                                level.m_46961_(st.gatherTarget, false);
                            }
                            if (st.targetResourceSource != null && !st.targetResourceSource.items.isEmpty()) {
                                st.items.add(new ItemStack((ItemLike)st.targetResourceSource.items.get(0)));
                            }
                            for (BlockPos adj : MiscUtil.findAdjacentBlocks(st.gatherTarget, bp -> {
                                ResourceSource r2 = ResourceSources.getFromBlockPos(bp, (Level)level);
                                return r2 != null && r2.resourceName == st.gatherTargetName;
                            })) {
                                if (st.todoGatherTargets.contains(adj)) continue;
                                st.todoGatherTargets.add(adj);
                            }
                            st.gatherTarget = null;
                            st.targetResourceSource = null;
                            st.gatherTicksLeft = 0;
                            if (DatapackUnitAdapter.atThreshold(st, st.ownerName, level)) {
                                st.resumeGatherAfterDeposit = true;
                                DatapackUnitAdapter.returnResourcesToClosest(mob);
                            }
                        }
                    } else {
                        if (st.lastOnPos != null && st.lastOnPos.equals((Object)mob.m_20097_())) {
                            ++st.stationaryWithTargetTicks;
                            if (st.stationaryWithTargetTicks > 40) {
                                st.gatherTarget = null;
                                st.targetResourceSource = null;
                                st.stationaryWithTargetTicks = 0;
                            }
                        } else {
                            st.stationaryWithTargetTicks = 0;
                        }
                        st.lastOnPos = mob.m_20097_();
                    }
                }
            }
            if (!isWorkerUnit || !st.hunting || st.returnBuilding != null) continue;
            boolean needDeposit = DatapackUnitAdapter.atThreshold(st, st.ownerName, level);
            if (needDeposit) {
                st.resumeHuntAfterDeposit = true;
                DatapackUnitAdapter.returnResourcesToClosest(mob);
                continue;
            }
            if (DatapackUnitAdapter.hasForcedTarget(mob) && mob.m_5448_() != null && mob.m_5448_().m_6084_()) continue;
            LivingEntity prey = DatapackUnitAdapter.findNearestHuntableAnimal(level, mob, st.huntCenter != null ? st.huntCenter : mob.m_20183_(), st.huntRadius);
            if (prey != null) {
                DatapackUnitAdapter.setForcedTarget(mob, prey);
                continue;
            }
            if (st.aggroCooldown > 0) continue;
            st.aggroCooldown = 40;
        }
    }

    private static void maybeBreakSoftBlockToward(ServerLevel level, Mob mob, AdaptedState st, BlockPos target, @Nullable UnitType<?> unitType) {
        if (unitType == null) {
            return;
        }
        UnitProperties props = unitType.getProperties();
        if (props == null) {
            return;
        }
        if (!props.canDestroyTerrain()) {
            return;
        }
        if (!ALLOW_TERRAIN_DESTRUCTION) {
            return;
        }
        if (st.terrainBreakCooldown > 0) {
            return;
        }
        Vec3 dir = new Vec3((double)target.m_123341_() + 0.5 - mob.m_20185_(), (double)target.m_123342_() + 0.1 - mob.m_20186_(), (double)target.m_123343_() + 0.5 - mob.m_20189_());
        int sx = (int)Math.signum(dir.f_82479_);
        int sz = (int)Math.signum(dir.f_82481_);
        BlockPos ahead = mob.m_20183_().m_7918_(sx, 0, sz);
        BlockPos aheadUp = ahead.m_7494_();
        if (DatapackUnitAdapter.tryBreakIfSoft(level, ahead) || DatapackUnitAdapter.tryBreakIfSoft(level, aheadUp)) {
            st.terrainBreakCooldown = 20;
        }
    }

    private static boolean tryBreakIfSoft(ServerLevel level, BlockPos bp) {
        BlockState bs = level.m_8055_(bp);
        if (bs.m_60795_()) {
            return false;
        }
        for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
            if (!building.isPosInsideBuilding(bp)) continue;
            return false;
        }
        float hardness = bs.m_60800_((BlockGetter)level, bp);
        if (hardness < 0.0f) {
            return false;
        }
        if (hardness > 0.6f) {
            return false;
        }
        if (level.m_7702_(bp) != null) {
            return false;
        }
        return level.m_46961_(bp, false);
    }

    public static void setAttackBuildingTarget(Mob mob, @Nullable BlockPos bp) {
        AdaptedState st = DatapackUnitAdapter.getState((LivingEntity)mob);
        if (st != null) {
            st.attackBuildingPos = bp;
            st.recalcPathCooldown = 0;
        }
    }

    private static int getCarriedValue(AdaptedState st) {
        return Resources.getTotalResourcesFromItems(st.items).getTotalValue();
    }

    private static boolean atThreshold(AdaptedState st, String ownerName, ServerLevel level) {
        boolean hasCarryBags = false;
        try {
            hasCarryBags = ResearchServerEvents.playerHasResearch(ownerName, ProductionItems.RESEARCH_RESOURCE_CAPACITY);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int threshold = hasCarryBags ? 100 : 50;
        return DatapackUnitAdapter.getCarriedValue(st) >= threshold;
    }

    @Nullable
    private static LivingEntity findNearestHuntableAnimal(ServerLevel level, Mob mob, BlockPos center, int radius) {
        AABB box = new AABB(center).m_82400_((double)radius);
        List candidates = level.m_6443_(LivingEntity.class, box, le -> le instanceof Animal && le.m_6084_());
        LivingEntity best = null;
        double bestD = Double.MAX_VALUE;
        for (LivingEntity le2 : candidates) {
            double d = le2.m_20280_((Entity)mob);
            if (!(d < bestD)) continue;
            bestD = d;
            best = le2;
        }
        return best;
    }

    public static class AdaptedState {
        public final UUID entityId;
        public final ResourceLocation unitId;
        public String ownerName;
        public boolean holdPosition = false;
        @Nullable
        public BlockPos moveTarget = null;
        @Nullable
        public LivingEntity forcedTarget = null;
        @Nullable
        public BlockPos attackBuildingPos = null;
        public int recalcPathCooldown = 0;
        public int attackCooldownTicks = 0;
        @Nullable
        public AdapterGarrisonGoal garrisonGoal = null;
        public int aggroCooldown = 0;
        public int terrainBreakCooldown = 0;
        public boolean buildingAnim = false;
        public int buildingAnimTTL = 0;
        public int buildSwingCooldown = 0;
        public ItemStack prevMainHand = ItemStack.f_41583_;
        public final List<ItemStack> items = new ArrayList<ItemStack>();
        public int maxResources = 100;
        @Nullable
        public BlockPos gatherTarget = null;
        public ResourceName gatherTargetName = ResourceName.NONE;
        @Nullable
        public ResourceSource targetResourceSource = null;
        public int gatherTicksLeft = 0;
        public final List<BlockPos> todoGatherTargets = new ArrayList<BlockPos>();
        public int stationaryWithTargetTicks = 0;
        @Nullable
        public BlockPos lastOnPos = null;
        @Nullable
        public BuildingPlacement returnBuilding = null;
        public boolean resumeGatherAfterDeposit = false;
        public boolean resumeHuntAfterDeposit = false;
        public boolean hunting = false;
        @Nullable
        public BlockPos huntCenter = null;
        public int huntRadius = 24;

        public AdaptedState(UUID id, ResourceLocation unitId, String owner) {
            this.entityId = id;
            this.unitId = unitId;
            this.ownerName = owner;
        }
    }
}

