/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientEvents;
import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.BlockUtils;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSource;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.restoration.OreRestorationManager;
import com.solegendary.reignofnether.unit.TargetResourcesSave;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.packets.UnitSyncClientboundPacket;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnitProfession;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GatherResourcesGoal
extends MoveToTargetBlockGoal {
    public TargetResourcesSave data = new TargetResourcesSave();
    public TargetResourcesSave saveData = new TargetResourcesSave();
    public TargetResourcesSave permSaveData = new TargetResourcesSave();
    private static final int REACH_RANGE = 5;
    private static final int DEFAULT_MAX_GATHER_TICKS = 600;
    private int gatherTicksLeft = 600;
    private static final int MAX_SEARCH_CD_TICKS = 40;
    private int searchCdTicksLeft = 0;
    private int failedSearches = 0;
    private static final int MAX_FAILED_SEARCHES = 4;
    private static final int TICK_CD = 20;
    private int cdTicksLeft = 20;
    public static final int NO_TARGET_TIMEOUT = 50;
    public static final int IDLE_TIMEOUT = 200;
    private int ticksWithoutTarget = 0;
    private int ticksIdle = 200;
    private int ticksStationaryWithTarget = 0;
    public static final int TICKS_STATIONARY_TIMEOUT = 100;
    private BlockPos lastOnPos = null;
    private BlockPos altSearchPos = null;
    private final Predicate<BlockPos> BLOCK_CONDITION = bp -> {
        BlockState bs = this.mob.m_9236_().m_8055_(bp);
        BlockState bsAbove = this.mob.m_9236_().m_8055_(bp.m_7494_());
        ResourceSource resBlock = ResourceSources.getFromBlockPos(bp, this.mob.m_9236_());
        if (!this.mob.m_9236_().m_6857_().m_61937_(bp)) {
            return false;
        }
        if (resBlock == null || resBlock.resourceName != this.data.targetResourceName) {
            return false;
        }
        if (!resBlock.blockStateTest.test(bs)) {
            return false;
        }
        if (this.data.targetFarm != null && !this.data.targetFarm.isPosInsideBuilding((BlockPos)bp)) {
            return false;
        }
        if (bs.m_60734_() == Blocks.f_50093_ || bs.m_60734_() == Blocks.f_50135_ ? !bsAbove.m_60795_() || !this.canAffordReplant() || !BuildingUtils.isPosInsideAnyBuilding(this.mob.m_9236_().m_5776_(), bp) : this.data.targetFarm == null && BuildingUtils.isPosInsideAnyBuilding(this.mob.m_9236_().m_5776_(), bp)) {
            return false;
        }
        boolean hasClearNeighbour = false;
        for (BlockPos adjBp : List.of(bp.m_7494_(), bp.m_122012_(), bp.m_122019_(), bp.m_122029_(), bp.m_122024_())) {
            if (!ResourceSources.isClearMaterial(this.mob.m_9236_().m_8055_(adjBp))) continue;
            hasClearNeighbour = true;
            break;
        }
        if (!hasClearNeighbour) {
            return false;
        }
        AABB aabb = AABB.m_165882_((Vec3)this.mob.m_20182_(), (double)10.0, (double)10.0, (double)10.0);
        for (LivingEntity entity : this.mob.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148353_(), (LivingEntity)this.mob, aabb)) {
            BlockPos otherUnitTarget;
            WorkerUnit workerUnit;
            Unit unit;
            if (!(entity instanceof Unit) || !((unit = (Unit)entity) instanceof WorkerUnit) || (workerUnit = (WorkerUnit)((Object)unit)).getGatherResourceGoal() == null || entity.m_19879_() == this.mob.m_19879_() || (otherUnitTarget = workerUnit.getGatherResourceGoal().getGatherTarget()) == null || !otherUnitTarget.equals(bp)) continue;
            this.altSearchPos = bp;
            return false;
        }
        return true;
    };

    public GatherResourcesGoal(Mob mob) {
        super(mob, true, 4);
    }

    public void syncFromServer(ResourceName gatherName, BlockPos gatherPos, int gatherTicks) {
        this.data.targetResourceName = gatherName;
        this.data.gatherTarget = gatherPos;
        this.gatherTicksLeft = gatherTicks;
        this.data.targetResourceSource = ResourceSources.getFromBlockPos(this.data.gatherTarget, this.mob.m_9236_());
    }

    public void tickClient() {
        if (this.data.targetResourceSource != null && this.data.gatherTarget != null && this.isGathering() && FogOfWarClientEvents.isInBrightChunk(this.data.gatherTarget)) {
            this.gatherTicksLeft = Math.min(this.gatherTicksLeft, this.data.targetResourceSource.ticksToGather);
            --this.gatherTicksLeft;
            if (this.gatherTicksLeft <= 0) {
                this.gatherTicksLeft = this.data.targetResourceSource.ticksToGather;
            }
            int gatherProgress = Math.round((float)(this.data.targetResourceSource.ticksToGather - this.gatherTicksLeft) / (float)this.data.targetResourceSource.ticksToGather * 10.0f);
            this.mob.m_9236_().m_6801_(this.mob.m_19879_(), this.data.gatherTarget, gatherProgress);
        }
    }

    public void m_8037_() {
        if (this.mob.m_9236_().m_5776_()) {
            this.tickClient();
            return;
        }
        --this.cdTicksLeft;
        if (this.cdTicksLeft > 0) {
            return;
        }
        this.cdTicksLeft = 20;
        if (this.data.gatherTarget == null && this.data.targetResourceName != ResourceName.NONE) {
            this.searchCdTicksLeft -= 10;
            for (BlockPos todoBp : this.data.todoGatherTargets) {
                if (!this.BLOCK_CONDITION.test(todoBp)) continue;
                this.data.gatherTarget = todoBp;
                break;
            }
            if (this.data.gatherTarget != null) {
                this.data.todoGatherTargets.remove(this.data.gatherTarget);
            }
            if (this.data.gatherTarget == null && this.searchCdTicksLeft <= 0) {
                if (this.data.targetFarm != null) {
                    for (BuildingBlock block : this.data.targetFarm.getBlocks()) {
                        if (!this.BLOCK_CONDITION.test(block.getBlockPos())) continue;
                        this.data.gatherTarget = block.getBlockPos();
                        break;
                    }
                } else {
                    Optional bpOpt;
                    if (this.altSearchPos != null) {
                        bpOpt = BlockPos.m_121930_((BlockPos)this.altSearchPos, (int)2, (int)2, this.BLOCK_CONDITION);
                        this.altSearchPos = null;
                    } else {
                        int range = 5 * (this.failedSearches + 1);
                        if (this.failedSearches > 4) {
                            this.stopGathering();
                            this.ticksIdle += 200;
                        }
                        bpOpt = BlockPos.m_121930_((BlockPos)new BlockPos((int)this.mob.m_146892_().f_82479_, (int)this.mob.m_146892_().f_82480_, (int)this.mob.m_146892_().f_82481_), (int)range, (int)range, this.BLOCK_CONDITION);
                    }
                    bpOpt.ifPresentOrElse(blockPos -> {
                        this.data.gatherTarget = blockPos;
                        this.failedSearches = 0;
                    }, () -> ++this.failedSearches);
                }
                this.searchCdTicksLeft = 40;
            }
            if (this.data.gatherTarget != null) {
                this.data.targetResourceSource = ResourceSources.getFromBlockPos(this.data.gatherTarget, this.mob.m_9236_());
            }
        }
        if (this.data.gatherTarget != null) {
            this.ticksStationaryWithTarget = this.mob.m_20097_().equals((Object)this.lastOnPos) && !this.isGathering() ? (this.ticksStationaryWithTarget += 20) : 0;
            if (this.ticksStationaryWithTarget >= 100) {
                this.ticksStationaryWithTarget = 0;
                this.data.gatherTarget = null;
                return;
            }
            this.lastOnPos = this.mob.m_20097_();
            if (!this.BLOCK_CONDITION.test(this.data.gatherTarget)) {
                this.removeGatherTarget();
            } else {
                super.setMoveTarget(this.data.gatherTarget);
            }
            if (this.isGathering()) {
                this.ticksIdle = 0;
                this.mob.m_21563_().m_24946_((double)this.data.gatherTarget.m_123341_(), (double)this.data.gatherTarget.m_123342_(), (double)this.data.gatherTarget.m_123343_());
                this.mob.m_21563_().f_186068_ = 20;
                BlockState bsTarget = this.mob.m_9236_().m_8055_(this.data.gatherTarget);
                if (bsTarget.m_60734_() == Blocks.f_50093_ || bsTarget.m_60734_() == Blocks.f_50135_) {
                    this.gatherTicksLeft -= 10;
                    this.gatherTicksLeft = Math.min(this.gatherTicksLeft, 10);
                    if (this.gatherTicksLeft <= 0) {
                        this.gatherTicksLeft = 600;
                        if (this.canAffordReplant()) {
                            ResourcesServerEvents.addSubtractResources(new Resources(((Unit)this.mob).getOwnerName(), 0, -1, 0));
                            this.mob.m_9236_().m_46597_(this.data.gatherTarget.m_7494_(), ((WorkerUnit)this.mob).getReplantBlockState());
                            this.removeGatherTarget();
                        }
                    }
                } else {
                    int ticksToProgress = ResearchServerEvents.playerHasCheat(((Unit)this.mob).getOwnerName(), "operationcwal") ? 100 : 10;
                    Mob mob = this.mob;
                    if (mob instanceof VillagerUnit) {
                        VillagerUnit vUnit = (VillagerUnit)mob;
                        if (ResourceSources.getBlockResourceName(this.getGatherTarget(), this.mob.m_9236_()) == ResourceName.WOOD && vUnit.getUnitProfession() == VillagerUnitProfession.LUMBERJACK) {
                            ticksToProgress = vUnit.isVeteran() ? (int)((float)ticksToProgress * 1.5f) : (int)((float)ticksToProgress * 1.25f);
                        } else if (ResourceSources.getBlockResourceName(this.getGatherTarget(), this.mob.m_9236_()) == ResourceName.ORE && vUnit.getUnitProfession() == VillagerUnitProfession.MINER) {
                            ticksToProgress = vUnit.isVeteran() ? (int)((float)ticksToProgress * 1.5f) : (int)((float)ticksToProgress * 1.25f);
                        }
                    }
                    this.gatherTicksLeft -= ticksToProgress;
                    this.gatherTicksLeft = Math.min(this.gatherTicksLeft, this.data.targetResourceSource.ticksToGather);
                    if (this.gatherTicksLeft <= 0) {
                        this.gatherTicksLeft = 600;
                        ResourceName resourceName = ResourceSources.getBlockResourceName(this.data.gatherTarget, this.mob.m_9236_());
                        BlockState bs = this.mob.m_9236_().m_8055_(this.data.gatherTarget);
                        boolean isLogBlock = BlockUtils.isLogBlock(bs);
                        boolean isFallingLogBlock = BlockUtils.isFallingLogBlock(bs);
                        if (isLogBlock) {
                            ResourcesServerEvents.fellAdjacentLogs(this.data.gatherTarget, new ArrayList<BlockPos>(), this.mob.m_9236_());
                        }
                        ResourceName expName = ResourceName.NONE;
                        if (ResourceSources.getBlockResourceName(this.getGatherTarget(), this.mob.m_9236_()) == ResourceName.FOOD && this.isFarming()) {
                            expName = ResourceName.FOOD;
                        } else if (ResourceSources.getBlockResourceName(this.getGatherTarget(), this.mob.m_9236_()) == ResourceName.WOOD && (isLogBlock || isFallingLogBlock)) {
                            expName = ResourceName.WOOD;
                        } else if (ResourceSources.getBlockResourceName(this.getGatherTarget(), this.mob.m_9236_()) == ResourceName.ORE && bs.m_60734_() != Blocks.f_152588_) {
                            expName = ResourceName.ORE;
                        }
                        if (this.data.targetResourceSource.resourceName == ResourceName.ORE) {
                            try {
                                if (OreRestorationManager.isTrackableOre(bs)) {
                                    System.out.println("[OreRestoration] Unit mining " + bs.m_60734_().m_49954_().getString() + " at " + String.valueOf(this.data.gatherTarget));
                                    OreRestorationManager.trackMinedOre((ServerLevel)this.mob.m_9236_(), this.data.gatherTarget, bs);
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (this.mob.m_9236_().m_46961_(this.data.gatherTarget, false)) {
                            Mob mob2 = this.mob;
                            if (mob2 instanceof VillagerUnit) {
                                VillagerUnit vUnit = (VillagerUnit)mob2;
                                if (expName == ResourceName.FOOD) {
                                    vUnit.incrementFarmerExp();
                                } else if (expName == ResourceName.WOOD) {
                                    vUnit.incrementLumberjackExp();
                                } else if (expName == ResourceName.ORE) {
                                    vUnit.incrementMinerExp();
                                }
                            }
                            if (this.data.targetResourceSource.resourceName == ResourceName.ORE && bsTarget.m_60734_() != Blocks.f_152588_) {
                                BlockState replaceBs = BuildingUtils.isInNetherRange(this.mob.m_9236_().m_5776_(), this.data.gatherTarget) ? ((Block)BlockRegistrar.WALKABLE_MAGMA_BLOCK.get()).m_49966_() : (bsTarget.m_60734_().m_49954_().getString().toLowerCase().contains("deepslate") ? Blocks.f_152551_.m_49966_() : Blocks.f_50652_.m_49966_());
                                this.mob.m_9236_().m_46597_(this.data.gatherTarget, replaceBs);
                            }
                            this.data.todoGatherTargets.remove(this.data.gatherTarget);
                            for (BlockPos pos : MiscUtil.findAdjacentBlocks(this.data.gatherTarget, this.BLOCK_CONDITION)) {
                                if (this.data.todoGatherTargets.contains(pos)) continue;
                                this.data.todoGatherTargets.add(pos);
                            }
                            Unit unit = (Unit)this.mob;
                            unit.getItems().add(new ItemStack((ItemLike)this.data.targetResourceSource.items.get(0)));
                            UnitSyncClientboundPacket.sendSyncResourcesPacket(unit);
                            if (Unit.atThresholdResources(unit)) {
                                this.saveAndReturnResources();
                            }
                            this.removeGatherTarget();
                        }
                    }
                }
            } else {
                if (this.mob.m_21573_().m_26571_()) {
                    this.ticksWithoutTarget += 10;
                }
                if (this.ticksWithoutTarget >= 50) {
                    this.removeGatherTarget();
                }
            }
        } else {
            this.ticksIdle += 10;
        }
    }

    public void saveAndReturnResources() {
        Unit unit = (Unit)this.mob;
        if (unit.getReturnResourcesGoal() != null) {
            this.saveState();
            unit.resetBehaviours();
            WorkerUnit.resetBehaviours((WorkerUnit)((Object)unit));
            unit.getReturnResourcesGoal().returnToClosestBuilding();
        }
    }

    private void saveState() {
        this.saveData.todoGatherTargets.clear();
        this.saveData.todoGatherTargets.addAll(this.data.todoGatherTargets);
        this.saveData.gatherTarget = this.data.gatherTarget;
        this.saveData.targetResourceName = this.data.targetResourceName;
        this.saveData.targetResourceSource = this.data.targetResourceSource;
        this.saveData.targetFarm = this.data.targetFarm;
        this.savePermState();
    }

    public void savePermState() {
        if (this.data.hasData()) {
            this.permSaveData.todoGatherTargets.clear();
            this.permSaveData.todoGatherTargets.addAll(this.data.todoGatherTargets);
            this.permSaveData.gatherTarget = this.data.gatherTarget;
            this.permSaveData.targetResourceName = this.data.targetResourceName;
            this.permSaveData.targetResourceSource = this.data.targetResourceSource;
            this.permSaveData.targetFarm = this.data.targetFarm;
        }
    }

    public void loadState() {
        this.data.todoGatherTargets.clear();
        this.data.todoGatherTargets.addAll(this.saveData.todoGatherTargets);
        this.data.gatherTarget = this.saveData.gatherTarget;
        this.data.targetResourceName = this.saveData.targetResourceName;
        this.data.targetResourceSource = this.saveData.targetResourceSource;
        this.data.targetFarm = this.saveData.targetFarm;
    }

    private boolean isBlockInRange(BlockPos target) {
        int reachRangeBonus = Math.min(5, this.ticksWithoutTarget / 20);
        return target.m_203198_(this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_()) <= Math.pow(5 + reachRangeBonus, 2.0);
    }

    public boolean isGathering() {
        if (!Unit.atMaxResources((Unit)this.mob) && this.data.gatherTarget != null && this.mob.m_9236_().m_5776_()) {
            return this.isBlockInRange(this.data.gatherTarget);
        }
        if (!Unit.atMaxResources((Unit)this.mob) && this.data.gatherTarget != null && this.data.targetResourceSource != null && ResourceSources.getBlockResourceName(this.data.gatherTarget, this.mob.m_9236_()) != ResourceName.NONE) {
            return this.isBlockInRange(this.data.gatherTarget);
        }
        return false;
    }

    private boolean canAffordReplant() {
        return ResourcesServerEvents.canAfford(((Unit)this.mob).getOwnerName(), ResourceName.WOOD, 1);
    }

    public void setTargetResourceName(ResourceName resourceName) {
        this.data.targetResourceName = resourceName;
    }

    public ResourceName getTargetResourceName() {
        return this.data.targetResourceName;
    }

    @Override
    public void setMoveTarget(@Nullable BlockPos bp) {
        if (bp != null) {
            MiscUtil.addUnitCheckpoint((Unit)this.mob, bp, true);
        }
        super.setMoveTarget(bp);
        if (this.BLOCK_CONDITION.test(bp)) {
            this.data.gatherTarget = bp;
            this.data.targetResourceSource = ResourceSources.getFromBlockPos(this.data.gatherTarget, this.mob.m_9236_());
        }
    }

    public boolean isFarming() {
        return this.data.targetFarm != null;
    }

    public void setTargetFarm(BuildingPlacement building) {
        if (building != null) {
            MiscUtil.addUnitCheckpoint((Unit)this.mob, building.centrePos, true);
        }
        this.data.targetFarm = building;
    }

    public void removeGatherTarget() {
        this.data.gatherTarget = null;
        this.data.targetResourceSource = null;
        this.gatherTicksLeft = 600;
        this.searchCdTicksLeft = 0;
        this.ticksWithoutTarget = 0;
    }

    public void stopGathering() {
        this.ticksIdle = 200;
        this.failedSearches = 0;
        this.savePermState();
        this.mob.m_9236_().m_6801_(this.mob.m_19879_(), new BlockPos(0, 0, 0), 0);
        this.data.todoGatherTargets.clear();
        this.data.targetFarm = null;
        this.removeGatherTarget();
        this.setTargetResourceName(ResourceName.NONE);
        super.stopMoving();
    }

    public BlockPos getGatherTarget() {
        return this.data.gatherTarget;
    }

    public int getGatherTicksLeft() {
        return this.gatherTicksLeft;
    }

    public boolean isIdle() {
        return this.ticksIdle > 200;
    }
}

