/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.KeyframeAnimated;
import com.solegendary.reignofnether.unit.interfaces.RangedAttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.packets.UnitAnimationClientboundPacket;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class UnitRangedAttackGoal<T extends Mob>
extends Goal {
    private final int VELOCITY = 20;
    private final T mob;
    private final int attackWindupTicksMax;
    private int attackWindupTicksLeft;
    private int attackCooldown = 0;
    private int attackTime = -1;
    private int seeTime = 0;

    public UnitRangedAttackGoal(T mob, int attackWindupTime) {
        this.mob = mob;
        this.attackWindupTicksMax = attackWindupTime;
        this.attackWindupTicksLeft = attackWindupTime;
        this.setToMaxAttackCooldown();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void tickAttackCooldown() {
        if (this.attackCooldown > ((AttackerUnit)this.mob).getAttackCooldown()) {
            this.setToMaxAttackCooldown();
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void setToMaxAttackCooldown() {
        this.attackCooldown = ((AttackerUnit)this.mob).getAttackCooldown();
    }

    public void resetCooldown() {
        this.attackCooldown = 0;
    }

    public boolean m_8036_() {
        return this.mob.m_5448_() != null;
    }

    public boolean m_8045_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        return this.m_8036_() || !this.isDoneMoving();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.attackWindupTicksLeft = this.attackWindupTicksMax;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && target.m_6084_()) {
            boolean flag;
            this.mob.m_21563_().m_24946_(target.m_20185_(), target.m_20188_(), target.m_20189_());
            GarrisonableBuilding garr = GarrisonableBuilding.getGarrison((Unit)this.mob);
            GarrisonableBuilding targetGarr = null;
            if (target instanceof Unit) {
                Unit unit = (Unit)target;
                targetGarr = GarrisonableBuilding.getGarrison(unit);
            }
            boolean isGarrisoned = garr != null;
            boolean isTargetGarrisoned = targetGarr != null;
            boolean canSeeTarget = this.mob.m_21574_().m_148306_((Entity)target) || isGarrisoned || isTargetGarrisoned;
            boolean bl = flag = this.seeTime > 0;
            if (canSeeTarget != flag) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
            float attackRange = ((AttackerUnit)this.mob).getAttackRange();
            if (isGarrisoned) {
                attackRange = garr.getAttackRange();
            } else if (isTargetGarrisoned) {
                attackRange += (float)targetGarr.getExternalAttackRangeBonus();
            }
            double distToTarget = this.mob.m_20270_((Entity)target);
            if (!this.mob.m_20159_()) {
                if (!(!(distToTarget > (double)(attackRange - 1.0f)) && canSeeTarget || ((Unit)this.mob).getHoldPosition())) {
                    this.moveTo(target);
                } else {
                    this.stopMoving();
                }
            }
            if (distToTarget <= (double)attackRange && canSeeTarget && this.seeTime >= -60 && this.attackCooldown <= 0) {
                if (this.attackWindupTicksLeft == this.attackWindupTicksMax && this.mob instanceof KeyframeAnimated && !this.mob.m_9236_().m_5776_()) {
                    UnitAnimationClientboundPacket.sendBasicPacket(UnitAnimationAction.ATTACK_UNIT, this.mob);
                }
                --this.attackWindupTicksLeft;
                if (this.attackWindupTicksLeft <= 0) {
                    this.attackWindupTicksLeft = this.attackWindupTicksMax;
                    this.setToMaxAttackCooldown();
                    T t = this.mob;
                    if (t instanceof RangedAttackerUnit) {
                        RangedAttackerUnit rangedAttackerUnit = (RangedAttackerUnit)t;
                        rangedAttackerUnit.performUnitRangedAttack(target, 20.0f);
                    }
                }
            } else {
                this.attackWindupTicksLeft = this.attackWindupTicksMax;
            }
        }
    }

    private boolean isDoneMoving() {
        Unit unit = (Unit)this.mob;
        return this.mob.m_21573_().m_26571_();
    }

    private void stopMoving() {
        Unit unit = (Unit)this.mob;
        this.mob.m_21573_().m_26573_();
    }

    private void moveTo(LivingEntity target) {
        Unit unit = (Unit)this.mob;
        this.mob.m_21573_().m_5624_((Entity)target, 1.0);
    }
}

