/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.packets;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.sandbox.SandboxServer;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class UnitActionServerboundPacket {
    private final String ownerName;
    private final UnitAction action;
    private final int unitId;
    private final int[] unitIds;
    private final BlockPos preselectedBlockPos;
    private final BlockPos selectedBuildingPos;
    private final boolean shiftQueue;

    public UnitActionServerboundPacket(String ownerName, UnitAction action, int unitId, int[] unitIds, BlockPos preselectedBlockPos, BlockPos selectedBuildingPos, boolean shiftQueue) {
        this.ownerName = ownerName;
        this.action = action;
        this.unitId = unitId;
        this.unitIds = unitIds;
        this.preselectedBlockPos = preselectedBlockPos;
        this.selectedBuildingPos = selectedBuildingPos;
        this.shiftQueue = shiftQueue;
    }

    public UnitActionServerboundPacket(FriendlyByteBuf buffer) {
        this.ownerName = buffer.m_130277_();
        this.action = (UnitAction)buffer.m_130066_(UnitAction.class);
        this.unitId = buffer.readInt();
        this.unitIds = buffer.m_130100_();
        this.preselectedBlockPos = buffer.m_130135_();
        this.selectedBuildingPos = buffer.m_130135_();
        this.shiftQueue = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.ownerName);
        buffer.m_130068_((Enum)this.action);
        buffer.writeInt(this.unitId);
        buffer.m_130089_(this.unitIds);
        buffer.m_130064_(this.preselectedBlockPos);
        buffer.m_130064_(this.selectedBuildingPos);
        buffer.writeBoolean(this.shiftQueue);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer player;
            if (this.action == UnitAction.DEBUG1) {
                UnitServerEvents.debug1();
            }
            if (this.action == UnitAction.DEBUG2) {
                UnitServerEvents.debug2();
            }
            if ((player = ((NetworkEvent.Context)ctx.get()).getSender()) == null) {
                ReignOfNether.LOGGER.warn("Sender for unit action packet was null");
                success.set(false);
            } else if (!(player.m_7755_().getString().equals(this.ownerName) || SandboxServer.isSandboxPlayer(this.ownerName) || AlliancesServerEvents.canControlAlly(player.m_7755_().getString(), this.ownerName))) {
                ReignOfNether.LOGGER.warn("UnitActionServerboundPacket: Tried to process packet from " + String.valueOf(player.m_7755_()) + " for " + this.ownerName);
                success.set(false);
            } else {
                UnitServerEvents.addActionItem(this.ownerName, this.action, this.unitId, this.unitIds, this.preselectedBlockPos, this.selectedBuildingPos, this.shiftQueue);
                success.set(true);
            }
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

