/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.packets;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class UnitAnimationClientboundPacket {
    private final UnitAnimationAction animAction;
    private final int entityId;
    private final int targetId;
    private final double posX;
    private final double posY;
    private final double posZ;

    public static void sendBasicPacket(UnitAnimationAction animAction, LivingEntity entity) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitAnimationClientboundPacket(animAction, entity.m_19879_(), 0, 0.0, 0.0, 0.0));
    }

    public static void sendEntityPacket(UnitAnimationAction animAction, LivingEntity entity, LivingEntity target) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitAnimationClientboundPacket(animAction, entity.m_19879_(), target.m_19879_(), 0.0, 0.0, 0.0));
    }

    public static void sendBlockPosPacket(UnitAnimationAction animAction, LivingEntity entity, BlockPos bp) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitAnimationClientboundPacket(animAction, entity.m_19879_(), 0, bp.m_123341_(), bp.m_123342_(), bp.m_123343_()));
    }

    public static void sendEatFoodPacket(LivingEntity entity, int itemId) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitAnimationClientboundPacket(UnitAnimationAction.EAT_FOOD_ITEM, entity.m_19879_(), itemId, 0.0, 0.0, 0.0));
    }

    public UnitAnimationClientboundPacket(UnitAnimationAction animAction, int unitId, int targetId, double posX, double posY, double posZ) {
        this.animAction = animAction;
        this.entityId = unitId;
        this.targetId = targetId;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public UnitAnimationClientboundPacket(FriendlyByteBuf buffer) {
        this.animAction = (UnitAnimationAction)buffer.m_130066_(UnitAnimationAction.class);
        this.entityId = buffer.readInt();
        this.targetId = buffer.readInt();
        this.posX = buffer.readDouble();
        this.posY = buffer.readDouble();
        this.posZ = buffer.readDouble();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.animAction);
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.targetId);
        buffer.writeDouble(this.posX);
        buffer.writeDouble(this.posY);
        buffer.writeDouble(this.posZ);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            switch (this.animAction) {
                case EAT_FOOD_ITEM: {
                    UnitClientEvents.syncUnitEatingFood(this.entityId, this.targetId);
                    break;
                }
                case NON_KEYFRAME_START: {
                    UnitClientEvents.syncUnitAnimation(this.animAction, true, this.entityId, this.targetId, new BlockPos((int)this.posX, (int)this.posY, (int)this.posZ));
                    break;
                }
                case NON_KEYFRAME_STOP: {
                    UnitClientEvents.syncUnitAnimation(this.animAction, false, this.entityId, this.targetId, new BlockPos((int)this.posX, (int)this.posY, (int)this.posZ));
                    break;
                }
                case NON_KEYFRAME_ATTACK: {
                    UnitClientEvents.playAttackAnimation(this.entityId);
                    break;
                }
                default: {
                    UnitClientEvents.playKeyframeAnimation(this.animAction, this.entityId);
                }
            }
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

