/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding;

import net.minecraft.core.BlockPos;

public class PathNode
implements Comparable<PathNode> {
    public final BlockPos pos;
    public final double gCost;
    public final double hCost;
    public final double fCost;
    public final PathNode parent;
    public final int depth;

    public PathNode(BlockPos pos, double gCost, double hCost, PathNode parent) {
        this.pos = pos;
        this.gCost = gCost;
        this.hCost = hCost;
        this.fCost = gCost + hCost;
        this.parent = parent;
        this.depth = parent != null ? parent.depth + 1 : 0;
    }

    @Override
    public int compareTo(PathNode other) {
        int fCompare = Double.compare(this.fCost, other.fCost);
        if (fCompare != 0) {
            return fCompare;
        }
        int hCompare = Double.compare(this.hCost, other.hCost);
        if (hCompare != 0) {
            return hCompare;
        }
        return Integer.compare(this.depth, other.depth);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PathNode pathNode = (PathNode)obj;
        return this.pos.equals((Object)pathNode.pos);
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    public String toString() {
        return String.format("PathNode{pos=%s, f=%.1f, g=%.1f, h=%.1f, depth=%d}", this.pos, this.fCost, this.gCost, this.hCost, this.depth);
    }
}

