/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding;

import com.solegendary.reignofnether.unit.interfaces.Unit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class PathfindingDebug {
    private static boolean debugEnabled = false;
    private static long totalAStarTime = 0L;
    private static long totalVanillaTime = 0L;
    private static int aStarPathCount = 0;
    private static int vanillaPathCount = 0;

    public static void setDebugEnabled(boolean enabled) {
        debugEnabled = enabled;
        if (enabled) {
            PathfindingDebug.resetStats();
        }
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    public static void resetStats() {
        totalAStarTime = 0L;
        totalVanillaTime = 0L;
        aStarPathCount = 0;
        vanillaPathCount = 0;
    }

    public static void recordAStarPath(long timeNanos) {
        if (debugEnabled) {
            totalAStarTime += timeNanos;
            ++aStarPathCount;
        }
    }

    public static void recordVanillaPath(long timeNanos) {
        if (debugEnabled) {
            totalVanillaTime += timeNanos;
            ++vanillaPathCount;
        }
    }

    public static String getPerformanceReport() {
        if (!debugEnabled) {
            return "Pathfinding debug is disabled. Enable with /reignofnether pathfinding debug true";
        }
        StringBuilder report = new StringBuilder();
        report.append("=== Pathfinding Performance Report ===\n");
        if (aStarPathCount > 0) {
            double avgAStarMs = (double)totalAStarTime / 1000000.0 / (double)aStarPathCount;
            report.append(String.format("A* Pathfinding: %d paths, avg %.2fms\n", aStarPathCount, avgAStarMs));
        } else {
            report.append("A* Pathfinding: No paths calculated\n");
        }
        if (vanillaPathCount > 0) {
            double avgVanillaMs = (double)totalVanillaTime / 1000000.0 / (double)vanillaPathCount;
            report.append(String.format("Vanilla Pathfinding: %d paths, avg %.2fms\n", vanillaPathCount, avgVanillaMs));
        } else {
            report.append("Vanilla Pathfinding: No paths calculated\n");
        }
        if (aStarPathCount > 0 && vanillaPathCount > 0) {
            double aStarAvg = (double)totalAStarTime / 1000000.0 / (double)aStarPathCount;
            double vanillaAvg = (double)totalVanillaTime / 1000000.0 / (double)vanillaPathCount;
            double speedup = vanillaAvg / aStarAvg;
            report.append(String.format("Performance ratio: %.2fx %s\n", Math.abs(speedup), speedup > 1.0 ? "(A* faster)" : "(Vanilla faster)"));
        }
        return report.toString();
    }

    public static void logPathfindingRequest(Mob mob, BlockPos start, BlockPos goal, Path result, long timeNanos, String method) {
        String string;
        if (!debugEnabled) {
            return;
        }
        if (mob instanceof Unit) {
            Unit unit = (Unit)mob;
            string = mob.m_6095_().m_20675_();
        } else {
            string = mob.getClass().getSimpleName();
        }
        String unitName = string;
        double distanceToGoal = start.m_123331_((Vec3i)goal);
        int pathLength = result != null ? result.f_77362_.size() : 0;
        double timeMs = (double)timeNanos / 1000000.0;
        System.out.printf("[Pathfinding] %s: %s from %s to %s (dist=%.1f) -> %s path (len=%d) in %.2fms%n", method, unitName, start, goal, Math.sqrt(distanceToGoal), result != null ? "found" : "NO", pathLength, timeMs);
    }

    public static boolean validatePath(Path path, BlockPos start, BlockPos goal) {
        if (path == null || path.f_77362_.isEmpty()) {
            return false;
        }
        BlockPos pathStart = ((Node)path.f_77362_.get(0)).m_77288_();
        if (pathStart.m_123331_((Vec3i)start) > 4.0) {
            if (debugEnabled) {
                System.out.printf("[Pathfinding] WARNING: Path starts at %s but unit is at %s%n", pathStart, start);
            }
            return false;
        }
        BlockPos pathEnd = ((Node)path.f_77362_.get(path.f_77362_.size() - 1)).m_77288_();
        if (pathEnd.m_123331_((Vec3i)goal) > 16.0) {
            if (debugEnabled) {
                System.out.printf("[Pathfinding] WARNING: Path ends at %s but goal is %s%n", pathEnd, goal);
            }
            return false;
        }
        return true;
    }
}

