/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding;

import com.solegendary.reignofnether.unit.goals.FlyingMoveToTargetGoal;
import com.solegendary.reignofnether.unit.goals.ImprovedFlyingMoveToTargetGoal;
import com.solegendary.reignofnether.unit.goals.ImprovedMoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.pathfinding.DestructiveMovementGoal;
import com.solegendary.reignofnether.unit.pathfinding.PathfindingCache;
import com.solegendary.reignofnether.unit.pathfinding.TerrainDestruction;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;

public class PathfindingManager {
    private static boolean enableImprovedPathfinding = true;

    public static void setImprovedPathfindingEnabled(boolean enabled) {
        enableImprovedPathfinding = enabled;
        if (!enabled) {
            PathfindingCache.clearCache();
        }
    }

    public static boolean isImprovedPathfindingEnabled() {
        return enableImprovedPathfinding;
    }

    public static MoveToTargetBlockGoal createGroundMovementGoal(Mob mob, boolean persistent, int reachRange) {
        if (enableImprovedPathfinding && mob instanceof Unit) {
            if (TerrainDestruction.canUnitDestroy(mob)) {
                return new DestructiveMovementGoal(mob, 1.0, reachRange, persistent);
            }
            return new ImprovedMoveToTargetBlockGoal(mob, persistent, reachRange);
        }
        return new MoveToTargetBlockGoal(mob, persistent, reachRange);
    }

    public static FlyingMoveToTargetGoal createFlyingMovementGoal(Mob mob, int reachRange) {
        if (enableImprovedPathfinding && mob instanceof Unit) {
            return new ImprovedFlyingMoveToTargetGoal(mob, reachRange);
        }
        return new FlyingMoveToTargetGoal(mob, reachRange);
    }

    public static void upgradeMovementGoals(Mob mob) {
        MoveToTargetBlockGoal newGoal;
        MoveToTargetBlockGoal oldGoal;
        if (!enableImprovedPathfinding || !(mob instanceof Unit)) {
            return;
        }
        Set availableGoals = mob.f_21345_.m_148105_();
        Goal oldMoveGoal = null;
        Goal oldFlyingGoal = null;
        for (WrappedGoal goalWrapper : availableGoals) {
            Goal goal = goalWrapper.m_26015_();
            if (goal instanceof MoveToTargetBlockGoal && !(goal instanceof ImprovedMoveToTargetBlockGoal)) {
                oldMoveGoal = goal;
                continue;
            }
            if (!(goal instanceof FlyingMoveToTargetGoal) || goal instanceof ImprovedFlyingMoveToTargetGoal) continue;
            oldFlyingGoal = goal;
        }
        if (oldMoveGoal instanceof MoveToTargetBlockGoal) {
            oldGoal = (MoveToTargetBlockGoal)oldMoveGoal;
            mob.f_21345_.m_25363_((Goal)oldGoal);
            newGoal = TerrainDestruction.canUnitDestroy(mob) ? new DestructiveMovementGoal(mob, 1.0, oldGoal.moveReachRange, oldGoal.persistent) : new ImprovedMoveToTargetBlockGoal(mob, oldGoal.persistent, oldGoal.moveReachRange);
            if (oldGoal.getMoveTarget() != null) {
                newGoal.setMoveTarget(oldGoal.getMoveTarget());
            }
            mob.f_21345_.m_25352_(1, (Goal)newGoal);
        }
        if (oldFlyingGoal instanceof FlyingMoveToTargetGoal) {
            oldGoal = (FlyingMoveToTargetGoal)oldFlyingGoal;
            mob.f_21345_.m_25363_((Goal)oldGoal);
            newGoal = new ImprovedFlyingMoveToTargetGoal(mob, ((FlyingMoveToTargetGoal)oldGoal).getMoveReachRange());
            if (oldGoal.getMoveTarget() != null) {
                ((ImprovedFlyingMoveToTargetGoal)newGoal).setMoveTarget(oldGoal.getMoveTarget());
            }
            mob.f_21345_.m_25352_(1, (Goal)newGoal);
        }
    }

    public static void notifyTerrainChange(int centerX, int centerZ, int radius) {
        PathfindingCache.invalidateArea(new BlockPos(centerX, 0, centerZ), radius);
    }

    public static Goal getMovementGoal(Unit unit) {
        Mob mob = (Mob)unit;
        for (WrappedGoal goalWrapper : mob.f_21345_.m_148105_()) {
            Goal goal = goalWrapper.m_26015_();
            if (!(goal instanceof MoveToTargetBlockGoal) && !(goal instanceof FlyingMoveToTargetGoal) && !(goal instanceof ImprovedMoveToTargetBlockGoal) && !(goal instanceof ImprovedFlyingMoveToTargetGoal) && !(goal instanceof DestructiveMovementGoal)) continue;
            return goal;
        }
        return null;
    }

    public static void recalculatePath(Unit unit) {
        Goal moveGoal = PathfindingManager.getMovementGoal(unit);
        if (moveGoal instanceof ImprovedMoveToTargetBlockGoal) {
            ImprovedMoveToTargetBlockGoal improved = (ImprovedMoveToTargetBlockGoal)moveGoal;
            improved.invalidatePath();
        } else if (moveGoal instanceof DestructiveMovementGoal) {
            DestructiveMovementGoal destructive = (DestructiveMovementGoal)moveGoal;
            destructive.m_8041_();
            destructive.m_8056_();
        } else if (moveGoal instanceof MoveToTargetBlockGoal) {
            MoveToTargetBlockGoal standard = (MoveToTargetBlockGoal)moveGoal;
            standard.m_8056_();
        }
    }

    public static String getPerformanceStats() {
        PathfindingCache.CacheStatistics cacheStats = PathfindingCache.getStatistics();
        return String.format("PF cache[size=%d hit=%,d miss=%,d evict=%,d hitRate=%.2f] improved=%s", cacheStats.currentSize, cacheStats.hits, cacheStats.misses, cacheStats.evictions, cacheStats.hitRate, enableImprovedPathfinding);
    }
}

