/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding;

import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TerrainDestruction {
    private static final double LEAVES_DESTRUCTION_COST = 0.5;
    private static final double GRASS_DESTRUCTION_COST = 0.3;
    private static final double DIRT_DESTRUCTION_COST = 1.0;
    private static final double WOOD_DESTRUCTION_COST = 2.0;
    private static final double STONE_DESTRUCTION_COST = 3.0;
    private static final double CROPS_DESTRUCTION_COST = 0.2;
    private static final double LADDER_PLACEMENT_COST = 1.5;
    private static final double LADDER_CLIMBING_COST = 0.8;
    private static final int LEAVES_DESTRUCTION_TIME = 10;
    private static final int GRASS_DESTRUCTION_TIME = 5;
    private static final int DIRT_DESTRUCTION_TIME = 20;
    private static final int WOOD_DESTRUCTION_TIME = 40;
    private static final int STONE_DESTRUCTION_TIME = 60;
    private static final int CROPS_DESTRUCTION_TIME = 3;
    private static final int LADDER_PLACEMENT_TIME = 15;
    private static final Map<Block, DestructionData> destructionCache = new HashMap<Block, DestructionData>();

    private static void initializeDestructionData() {
        destructionCache.put(Blocks.f_50050_, new DestructionData(0.5, 10, true));
        destructionCache.put(Blocks.f_50051_, new DestructionData(0.5, 10, true));
        destructionCache.put(Blocks.f_50052_, new DestructionData(0.5, 10, true));
        destructionCache.put(Blocks.f_50053_, new DestructionData(0.5, 10, true));
        destructionCache.put(Blocks.f_50054_, new DestructionData(0.5, 10, true));
        destructionCache.put(Blocks.f_50055_, new DestructionData(0.5, 10, true));
        destructionCache.put(Blocks.f_271115_, new DestructionData(0.5, 10, true));
        destructionCache.put(Blocks.f_220838_, new DestructionData(0.5, 10, true));
        destructionCache.put(Blocks.f_50034_, new DestructionData(0.3, 5, true));
        destructionCache.put(Blocks.f_50359_, new DestructionData(0.3, 5, true));
        destructionCache.put(Blocks.f_50035_, new DestructionData(0.3, 5, true));
        destructionCache.put(Blocks.f_50360_, new DestructionData(0.3, 5, true));
        destructionCache.put(Blocks.f_50036_, new DestructionData(0.3, 5, true));
        destructionCache.put(Blocks.f_50037_, new DestructionData(0.3, 5, true));
        destructionCache.put(Blocks.f_50038_, new DestructionData(0.3, 5, true));
        destructionCache.put(Blocks.f_50092_, new DestructionData(0.2, 3, true));
        destructionCache.put(Blocks.f_50249_, new DestructionData(0.2, 3, true));
        destructionCache.put(Blocks.f_50250_, new DestructionData(0.2, 3, true));
        destructionCache.put(Blocks.f_50444_, new DestructionData(0.2, 3, true));
        destructionCache.put(Blocks.f_50189_, new DestructionData(0.2, 3, true));
        destructionCache.put(Blocks.f_50190_, new DestructionData(0.2, 3, true));
        destructionCache.put(Blocks.f_50493_, new DestructionData(1.0, 20, true));
        destructionCache.put(Blocks.f_50546_, new DestructionData(1.0, 20, true));
        destructionCache.put(Blocks.f_152549_, new DestructionData(1.0, 20, true));
        destructionCache.put(Blocks.f_50093_, new DestructionData(1.0, 20, true));
        destructionCache.put(Blocks.f_50440_, new DestructionData(1.0, 20, true));
        destructionCache.put(Blocks.f_50195_, new DestructionData(1.0, 20, true));
        destructionCache.put(Blocks.f_50599_, new DestructionData(1.0, 20, true));
        destructionCache.put(Blocks.f_49999_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_50000_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_50001_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_50002_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_50003_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_50004_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_271170_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_220832_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_50010_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_50005_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_50006_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_50007_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_50008_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_50009_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_271326_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_220835_, new DestructionData(2.0, 40, true));
        destructionCache.put(Blocks.f_50652_, new DestructionData(3.0, 60, false));
        destructionCache.put(Blocks.f_50069_, new DestructionData(3.0, 60, false));
        destructionCache.put(Blocks.f_50334_, new DestructionData(3.0, 60, false));
        destructionCache.put(Blocks.f_50122_, new DestructionData(3.0, 60, false));
        destructionCache.put(Blocks.f_50228_, new DestructionData(3.0, 60, false));
        destructionCache.put(Blocks.f_50111_, new DestructionData(0.3, 5, true));
        destructionCache.put(Blocks.f_50112_, new DestructionData(0.3, 5, true));
        destructionCache.put(Blocks.f_50113_, new DestructionData(0.3, 5, true));
        destructionCache.put(Blocks.f_50114_, new DestructionData(0.3, 5, true));
        destructionCache.put(Blocks.f_50073_, new DestructionData(0.3, 5, true));
        destructionCache.put(Blocks.f_50072_, new DestructionData(0.3, 5, true));
    }

    public static boolean isDestructible(BlockState blockState) {
        return destructionCache.containsKey(blockState.m_60734_());
    }

    public static boolean shouldDestroy(BlockState blockState) {
        DestructionData data = destructionCache.get(blockState.m_60734_());
        return data != null && data.shouldDestroyForPathfinding;
    }

    public static double getDestructionCost(BlockState blockState) {
        DestructionData data = destructionCache.get(blockState.m_60734_());
        return data != null ? data.cost : Double.MAX_VALUE;
    }

    public static int getDestructionTime(BlockState blockState) {
        DestructionData data = destructionCache.get(blockState.m_60734_());
        return data != null ? data.timeInTicks : Integer.MAX_VALUE;
    }

    public static boolean canUnitDestroy(Mob mob) {
        if (!(mob instanceof Unit)) {
            return false;
        }
        Unit unit = (Unit)mob;
        String mobTypeName = mob.m_6095_().m_20675_();
        return !mobTypeName.contains("ghast") && !mobTypeName.contains("blaze");
    }

    public static boolean canUnitClimbLadders(Mob mob) {
        if (!(mob instanceof Unit)) {
            return false;
        }
        Unit unit = (Unit)mob;
        String mobTypeName = mob.m_6095_().m_20675_();
        if (mobTypeName.contains("ghast") || mobTypeName.contains("blaze")) {
            return false;
        }
        return !mobTypeName.contains("ravager") && !mobTypeName.contains("iron_golem");
    }

    public static boolean canPlaceLadder(Level level, BlockPos pos) {
        BlockState currentState = level.m_8055_(pos);
        if (!currentState.m_60795_() && !TerrainDestruction.isDestructible(currentState)) {
            return false;
        }
        for (int[] direction : new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 0, 1}, {0, 0, -1}}) {
            BlockPos wallPos = pos.m_7918_(direction[0], direction[1], direction[2]);
            BlockState wallState = level.m_8055_(wallPos);
            if (!wallState.m_280296_()) continue;
            return true;
        }
        return false;
    }

    public static double getLadderPlacementCost() {
        return 1.5;
    }

    public static double getLadderClimbingCost() {
        return 0.8;
    }

    public static int getLadderPlacementTime() {
        return 15;
    }

    public static boolean isDestructionWorthwhile(BlockPos pos, BlockPos goal, BlockState blockState, double currentPathCost) {
        if (!TerrainDestruction.isDestructible(blockState)) {
            return false;
        }
        double destructionCost = TerrainDestruction.getDestructionCost(blockState);
        double distanceToGoal = pos.m_123331_((Vec3i)goal);
        if (destructionCost <= 1.0) {
            return true;
        }
        double potentialSavings = Math.sqrt(distanceToGoal) * 0.5;
        return destructionCost < potentialSavings;
    }

    public static void destroyBlock(Level level, BlockPos pos, Mob mob) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState blockState = level.m_8055_(pos);
        if (!TerrainDestruction.isDestructible(blockState)) {
            return;
        }
        if (mob instanceof Unit) {
            Unit unit = (Unit)mob;
            TerrainDestruction.generateResourcesFromDestruction(blockState, unit.getOwnerName(), pos, serverLevel);
        }
        level.m_46961_(pos, false);
        serverLevel.m_46796_(2001, pos, Block.m_49956_((BlockState)blockState));
    }

    public static void placeLadder(Level level, BlockPos pos, Mob mob) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!TerrainDestruction.canPlaceLadder(level, pos)) {
            return;
        }
        BlockState currentState = level.m_8055_(pos);
        if (!currentState.m_60795_()) {
            if (TerrainDestruction.isDestructible(currentState)) {
                TerrainDestruction.destroyBlock(level, pos, mob);
            } else {
                return;
            }
        }
        BlockState ladderState = Blocks.f_50155_.m_49966_();
        for (int[] direction : new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 0, 1}, {0, 0, -1}}) {
            BlockPos wallPos = pos.m_7918_(direction[0], direction[1], direction[2]);
            BlockState wallState = level.m_8055_(wallPos);
            if (!wallState.m_280296_()) continue;
            try {
                if (direction[0] == 1) {
                    ladderState = (BlockState)ladderState.m_61124_((Property)LadderBlock.f_54337_, (Comparable)Direction.WEST);
                    break;
                }
                if (direction[0] == -1) {
                    ladderState = (BlockState)ladderState.m_61124_((Property)LadderBlock.f_54337_, (Comparable)Direction.EAST);
                    break;
                }
                if (direction[2] == 1) {
                    ladderState = (BlockState)ladderState.m_61124_((Property)LadderBlock.f_54337_, (Comparable)Direction.NORTH);
                    break;
                }
                if (direction[2] != -1) break;
                ladderState = (BlockState)ladderState.m_61124_((Property)LadderBlock.f_54337_, (Comparable)Direction.SOUTH);
            }
            catch (Exception exception) {}
            break;
        }
        level.m_7731_(pos, ladderState, 3);
        if (mob instanceof Unit) {
            Unit unit = (Unit)mob;
            Resources woodCost = new Resources(unit.getOwnerName(), 0, -1, 0);
            ResourcesServerEvents.addSubtractResources(woodCost);
        }
        serverLevel.m_46796_(1000, pos, 0);
    }

    private static void generateResourcesFromDestruction(BlockState blockState, String ownerName, BlockPos pos, ServerLevel level) {
        Block block = blockState.m_60734_();
        if (block.m_7705_().contains("log")) {
            Resources woodResources = new Resources(ownerName, 0, 1, 0);
            ResourcesServerEvents.addSubtractResources(woodResources);
        } else if (block == Blocks.f_50092_ || block == Blocks.f_50249_ || block == Blocks.f_50250_ || block == Blocks.f_50444_) {
            Resources foodResources = new Resources(ownerName, 1, 0, 0);
            ResourcesServerEvents.addSubtractResources(foodResources);
        } else if (block.m_7705_().contains("leaves")) {
            if (Math.random() < 0.1) {
                Resources woodResources = new Resources(ownerName, 0, 1, 0);
                ResourcesServerEvents.addSubtractResources(woodResources);
            }
        } else if (block == Blocks.f_50069_ || block == Blocks.f_50652_) {
            Resources oreResources = new Resources(ownerName, 0, 0, 1);
            ResourcesServerEvents.addSubtractResources(oreResources);
        }
    }

    static {
        TerrainDestruction.initializeDestructionData();
    }

    private static class DestructionData {
        public final double cost;
        public final int timeInTicks;
        public final boolean shouldDestroyForPathfinding;

        public DestructionData(double cost, int timeInTicks, boolean shouldDestroyForPathfinding) {
            this.cost = cost;
            this.timeInTicks = timeInTicks;
            this.shouldDestroyForPathfinding = shouldDestroyForPathfinding;
        }
    }
}

