/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import com.solegendary.reignofnether.unit.pathfinding.PathNode;
import com.solegendary.reignofnether.unit.pathfinding.async.PathfindingTask;
import com.solegendary.reignofnether.unit.pathfinding.async.ReservationGrid;
import com.solegendary.reignofnether.unit.pathfinding.async.WorldSnapshot;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class AsyncPathfinder {
    private static final int DEFAULT_MAX_ITERATIONS = 2000;
    private static final int DEFAULT_MAX_NODES = 5000;
    private static final long BASE_TIME_BUDGET_MS = 12L;
    private static final double DIAGONAL_COST = 1.414;
    private static final double STRAIGHT_COST = 1.0;
    private static final double HEIGHT_PENALTY = 0.5;
    private static final double LIQUID_ADJACENT_BIAS = 0.9;
    private final int maxIterations;
    private final int maxNodes;

    public AsyncPathfinder() {
        this(2000, 5000);
    }

    public AsyncPathfinder(int maxIterations, int maxNodes) {
        this.maxIterations = maxIterations;
        this.maxNodes = maxNodes;
    }

    public Path findPath(PathfindingTask task) {
        if (task == null || task.isCancelled()) {
            return null;
        }
        try {
            return this.findPathInternal(task);
        }
        catch (Exception e) {
            System.err.printf("AsyncPathfinder error for entity %d: %s%n", task.getEntityId(), e.getMessage());
            return null;
        }
    }

    private Path findPathInternal(PathfindingTask task) {
        Path bi;
        WorldSnapshot world = task.getWorldSnapshot();
        BlockPos start = task.getStartPos();
        BlockPos goal = task.getGoalPos();
        int reachRange = task.getReachRange();
        if (start.m_123333_((Vec3i)goal) > 1024 && (bi = this.findPathBidirectional(task)) != null) {
            return bi;
        }
        PriorityQueue<PathNode> openSet = new PriorityQueue<PathNode>();
        Long2DoubleOpenHashMap bestG = new Long2DoubleOpenHashMap();
        bestG.defaultReturnValue(Double.POSITIVE_INFINITY);
        LongOpenHashSet closedSet = new LongOpenHashSet();
        PathNode startNode = new PathNode(start, 0.0, this.heuristic(start, goal, task.isWeightedHeuristic()), null);
        openSet.add(startNode);
        bestG.put(start.m_121878_(), 0.0);
        int iterations = 0;
        long startTime = System.nanoTime();
        long timeBudgetMs = this.computeTimeBudgetMs(world, start, goal);
        PathNode bestSoFar = startNode;
        while (!openSet.isEmpty() && iterations < this.maxIterations) {
            long elapsedMs;
            if (task.isCancelled()) {
                return null;
            }
            ++iterations;
            PathNode current = (PathNode)openSet.poll();
            long curKey = current.pos.m_121878_();
            if (current.gCost > bestG.get(curKey) || closedSet.contains(curKey)) continue;
            closedSet.add(curKey);
            if (current.hCost < bestSoFar.hCost) {
                bestSoFar = current;
            }
            if (this.isAtGoal(current.pos, goal, reachRange)) {
                return this.constructPath(current, world);
            }
            if (bestG.size() > this.maxNodes || (elapsedMs = (System.nanoTime() - startTime) / 1000000L) > timeBudgetMs) break;
            boolean tryJps = this.isOpenTerrainAround3D(current.pos, world);
            if (tryJps) {
                for (int[] dir : this.getPrunedDirectionsForJps(current)) {
                    long nKey;
                    BlockPos jp = this.jump(current.pos, (int)dir[0], (int)dir[1], (int)dir[2], world, goal);
                    if (jp == null || closedSet.contains(nKey = jp.m_121878_())) continue;
                    double moveCost = this.getJumpCost(current.pos, jp, world);
                    double expected = current.gCost + moveCost;
                    ReservationGrid.reserveAt(jp, (int)Math.max(1.0, expected / 1.0));
                    double newGCost = current.gCost + (moveCost += ReservationGrid.softPenalty(jp, expected));
                    double prevBest = bestG.get(nKey);
                    if (!(newGCost < prevBest)) continue;
                    bestG.put(nKey, newGCost);
                    openSet.add(new PathNode(jp, newGCost, this.heuristic(jp, goal, task.isWeightedHeuristic()), current));
                }
                continue;
            }
            Object object = this.getStepNeighbors(current.pos, world).iterator();
            while (object.hasNext()) {
                BlockPos neighbor = (BlockPos)object.next();
                long nKey = neighbor.m_121878_();
                if (closedSet.contains(nKey) || !world.isValidPosition(neighbor) || !this.isPassable(neighbor, world)) continue;
                double baseMove = this.getBaseMovementCost(current.pos, neighbor, world);
                double expected = current.gCost + baseMove;
                ReservationGrid.reserveAt(neighbor, (int)Math.max(1.0, expected / 1.0));
                double newGCost = current.gCost + baseMove + ReservationGrid.softPenalty(neighbor, expected);
                double prevBest = bestG.get(nKey);
                if (newGCost >= prevBest) continue;
                PathNode parent = current;
                if (current.parent != null && this.hasLineOfSight(current.parent.pos, neighbor, world)) {
                    double viaBase = this.getBaseMovementCost(current.parent.pos, neighbor, world);
                    double viaExpected = current.parent.gCost + viaBase;
                    ReservationGrid.reserveAt(neighbor, (int)Math.max(1.0, viaExpected / 1.0));
                    double viaParent = current.parent.gCost + viaBase + ReservationGrid.softPenalty(neighbor, viaExpected);
                    if (viaParent < newGCost) {
                        newGCost = viaParent;
                        parent = current.parent;
                    }
                }
                bestG.put(nKey, newGCost);
                openSet.add(new PathNode(neighbor, newGCost, this.heuristic(neighbor, goal, task.isWeightedHeuristic()), parent));
            }
        }
        if (bestSoFar != null && bestSoFar != startNode) {
            return this.constructPath(bestSoFar, world);
        }
        return null;
    }

    private Path findPathBidirectional(PathfindingTask task) {
        WorldSnapshot world = task.getWorldSnapshot();
        BlockPos start = task.getStartPos();
        BlockPos goal = task.getGoalPos();
        int reachRange = task.getReachRange();
        PriorityQueue<PathNode> openF = new PriorityQueue<PathNode>();
        PriorityQueue<PathNode> openB = new PriorityQueue<PathNode>();
        Long2DoubleOpenHashMap gF = new Long2DoubleOpenHashMap();
        gF.defaultReturnValue(Double.POSITIVE_INFINITY);
        Long2DoubleOpenHashMap gB = new Long2DoubleOpenHashMap();
        gB.defaultReturnValue(Double.POSITIVE_INFINITY);
        LongOpenHashSet closedF = new LongOpenHashSet();
        LongOpenHashSet closedB = new LongOpenHashSet();
        PathNode sNode = new PathNode(start, 0.0, this.heuristic(start, goal, task.isWeightedHeuristic()), null);
        PathNode tNode = new PathNode(goal, 0.0, this.heuristic(goal, start, task.isWeightedHeuristic()), null);
        openF.add(sNode);
        openB.add(tNode);
        gF.put(start.m_121878_(), 0.0);
        gB.put(goal.m_121878_(), 0.0);
        PathNode meetF = null;
        PathNode meetB = null;
        int iterations = 0;
        long startTime = System.nanoTime();
        long timeBudgetMs = this.computeTimeBudgetMs(world, start, goal);
        while (!openF.isEmpty() && !openB.isEmpty() && iterations < this.maxIterations) {
            ++iterations;
            if ((System.nanoTime() - startTime) / 1000000L > timeBudgetMs) break;
            PathNode cf = (PathNode)openF.poll();
            long kf = cf.pos.m_121878_();
            if (cf.gCost > gF.get(kf)) continue;
            closedF.add(kf);
            if (gB.containsKey(kf)) {
                meetF = cf;
                break;
            }
            for (BlockPos n : this.getStepNeighbors(cf.pos, world)) {
                double viaExpected;
                double viaBase;
                double via;
                double expected;
                double baseMove;
                double g;
                long nk;
                if (!world.isValidPosition(n) || !this.isPassable(n, world) || closedF.contains(nk = n.m_121878_()) || !((g = cf.gCost + (baseMove = this.getBaseMovementCost(cf.pos, n, world)) + ReservationGrid.softPenalty(n, expected = cf.gCost + baseMove)) < gF.get(nk))) continue;
                gF.put(nk, g);
                PathNode parent = cf;
                if (cf.parent != null && this.hasLineOfSight(cf.parent.pos, n, world) && (via = cf.parent.gCost + (viaBase = this.getBaseMovementCost(cf.parent.pos, n, world)) + ReservationGrid.softPenalty(n, viaExpected = cf.parent.gCost + viaBase)) < g) {
                    g = via;
                    parent = cf.parent;
                    gF.put(nk, g);
                }
                openF.add(new PathNode(n, g, this.heuristic(n, goal, task.isWeightedHeuristic()), parent));
            }
            PathNode cb = (PathNode)openB.poll();
            long kb = cb.pos.m_121878_();
            if (cb.gCost > gB.get(kb)) continue;
            closedB.add(kb);
            if (gF.containsKey(kb)) {
                meetB = cb;
                break;
            }
            for (BlockPos n : this.getStepNeighbors(cb.pos, world)) {
                double viaExpected;
                double viaBase;
                double via;
                double expected;
                double baseMove;
                double g;
                long nk;
                if (!world.isValidPosition(n) || !this.isPassable(n, world) || closedB.contains(nk = n.m_121878_()) || !((g = cb.gCost + (baseMove = this.getBaseMovementCost(cb.pos, n, world)) + ReservationGrid.softPenalty(n, expected = cb.gCost + baseMove)) < gB.get(nk))) continue;
                gB.put(nk, g);
                PathNode parent = cb;
                if (cb.parent != null && this.hasLineOfSight(cb.parent.pos, n, world) && (via = cb.parent.gCost + (viaBase = this.getBaseMovementCost(cb.parent.pos, n, world)) + ReservationGrid.softPenalty(n, viaExpected = cb.parent.gCost + viaBase)) < g) {
                    g = via;
                    parent = cb.parent;
                    gB.put(nk, g);
                }
                openB.add(new PathNode(n, g, this.heuristic(n, start, task.isWeightedHeuristic()), parent));
            }
        }
        if (meetF == null && meetB == null) {
            return null;
        }
        BlockPos meetPos = meetF != null ? meetF.pos : meetB.pos;
        PathNode fEnd = meetF;
        if (fEnd == null) {
            fEnd = sNode;
        }
        PathNode bEnd = null;
        if (closedB.contains(meetPos.m_121878_())) {
            for (PathNode pn : openB) {
                if (!pn.pos.equals((Object)meetPos)) continue;
                bEnd = pn;
                break;
            }
        }
        if (bEnd == null) {
            bEnd = tNode;
        }
        ArrayList<BlockPos> fList = new ArrayList<BlockPos>();
        PathNode cur = fEnd;
        while (cur != null) {
            fList.add(cur.pos);
            cur = cur.parent;
        }
        Collections.reverse(fList);
        ArrayList<BlockPos> bList = new ArrayList<BlockPos>();
        cur = bEnd;
        while (cur != null) {
            bList.add(cur.pos);
            cur = cur.parent;
        }
        if (!bList.isEmpty()) {
            bList.remove(0);
        }
        ArrayList<BlockPos> total = new ArrayList<BlockPos>(fList);
        total.addAll(bList);
        if (total.isEmpty()) {
            return null;
        }
        ArrayList<Node> nodes = new ArrayList<Node>(total.size());
        for (BlockPos p : total) {
            nodes.add(new Node(p.m_123341_(), p.m_123342_(), p.m_123343_()));
        }
        return new Path(nodes, goal, true);
    }

    private boolean isPassable(BlockPos pos, WorldSnapshot world) {
        return world.isPassable(pos);
    }

    private double getMovementCost(BlockPos from, BlockPos to, WorldSnapshot world) {
        int dx = Math.abs(from.m_123341_() - to.m_123341_());
        int dz = Math.abs(from.m_123343_() - to.m_123343_());
        int dy = Math.abs(from.m_123342_() - to.m_123342_());
        double base = dx > 0 && dz > 0 ? 1.414 : 1.0;
        base += (double)dy * 0.5;
        return base += world.getMovementCost(from, to);
    }

    private double getBaseMovementCost(BlockPos from, BlockPos to, WorldSnapshot world) {
        int dx = Math.abs(from.m_123341_() - to.m_123341_());
        int dz = Math.abs(from.m_123343_() - to.m_123343_());
        int dy = Math.abs(from.m_123342_() - to.m_123342_());
        double base = dx > 0 && dz > 0 ? 1.414 : 1.0;
        base += (double)dy * 0.5;
        base += world.getMovementCost(from, to);
        return base += this.riverbankBias(world, to);
    }

    private List<BlockPos> getStepNeighbors(BlockPos pos, WorldSnapshot world) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        int baseY = pos.m_123342_();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos candidate;
                if (dx == 0 && dz == 0 || (candidate = this.findStandable(pos.m_7918_(dx, 0, dz), baseY, world)) == null) continue;
                if (dx != 0 && dz != 0) {
                    BlockPos xStep = this.findStandable(pos.m_7918_(dx, 0, 0), baseY, world);
                    BlockPos zStep = this.findStandable(pos.m_7918_(0, 0, dz), baseY, world);
                    if (xStep == null || zStep == null) continue;
                }
                if (world.isLiquid(candidate) && !world.canEntitySwim() && !world.canEntityFly()) continue;
                neighbors.add(candidate);
            }
        }
        return neighbors;
    }

    private BlockPos findStandable(BlockPos target, int originY, WorldSnapshot world) {
        if (world.isValidPosition(target) && this.isPassable(target, world)) {
            return target;
        }
        BlockPos up = target.m_7494_();
        if (Math.abs(up.m_123342_() - originY) <= 1 && world.isValidPosition(up) && this.isPassable(up, world) && (!world.isLiquid(up) || world.canEntitySwim() || world.canEntityFly())) {
            return up;
        }
        BlockPos down = target.m_7495_();
        if (Math.abs(down.m_123342_() - originY) <= 1 && world.isValidPosition(down) && this.isPassable(down, world) && (!world.isLiquid(down) || world.canEntitySwim() || world.canEntityFly())) {
            return down;
        }
        return null;
    }

    private boolean isOpenTerrainAround3D(BlockPos pos, WorldSnapshot world) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos p;
                    if (dx == 0 && dy == 0 && dz == 0 || world.isValidPosition(p = pos.m_7918_(dx, dy, dz)) && this.isPassable(p, world)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private int[][] getPrunedDirectionsForJps(PathNode current) {
        if (current.parent == null) {
            int[][] dirs = new int[26][3];
            int k = 0;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        dirs[k][0] = dx;
                        dirs[k][1] = dy;
                        dirs[k][2] = dz;
                        ++k;
                    }
                }
            }
            return dirs;
        }
        int dx = Integer.compare(current.pos.m_123341_(), current.parent.pos.m_123341_());
        int dy = Integer.compare(current.pos.m_123342_(), current.parent.pos.m_123342_());
        int dz = Integer.compare(current.pos.m_123343_(), current.parent.pos.m_123343_());
        return new int[][]{{dx, dy, dz}};
    }

    private BlockPos jump(BlockPos from, int dx, int dy, int dz, WorldSnapshot world, BlockPos goal) {
        BlockPos cur = from;
        while (true) {
            if (!world.isValidPosition(cur = cur.m_7918_(dx, dy, dz)) || !this.isPassable(cur, world)) {
                return null;
            }
            if (cur.equals((Object)goal)) {
                return cur;
            }
            if (dx != 0 && dy == 0 && dz == 0) {
                if (!this.isPassable(cur.m_7918_(0, 0, 1), world) && this.isPassable(cur.m_7918_(-dx, 0, 1), world)) {
                    return cur;
                }
                if (!this.isPassable(cur.m_7918_(0, 0, -1), world) && this.isPassable(cur.m_7918_(-dx, 0, -1), world)) {
                    return cur;
                }
                if (!this.isPassable(cur.m_7918_(0, 1, 0), world) && this.isPassable(cur.m_7918_(-dx, 1, 0), world)) {
                    return cur;
                }
                if (this.isPassable(cur.m_7918_(0, -1, 0), world) || !this.isPassable(cur.m_7918_(-dx, -1, 0), world)) continue;
                return cur;
            }
            if (dz != 0 && dx == 0 && dy == 0) {
                if (!this.isPassable(cur.m_7918_(1, 0, 0), world) && this.isPassable(cur.m_7918_(1, 0, -dz), world)) {
                    return cur;
                }
                if (!this.isPassable(cur.m_7918_(-1, 0, 0), world) && this.isPassable(cur.m_7918_(-1, 0, -dz), world)) {
                    return cur;
                }
                if (!this.isPassable(cur.m_7918_(0, 1, 0), world) && this.isPassable(cur.m_7918_(0, 1, -dz), world)) {
                    return cur;
                }
                if (this.isPassable(cur.m_7918_(0, -1, 0), world) || !this.isPassable(cur.m_7918_(0, -1, -dz), world)) continue;
                return cur;
            }
            if (dy != 0 && dx == 0 && dz == 0) {
                if (!this.isPassable(cur.m_7918_(1, -dy, 0), world) && this.isPassable(cur.m_7918_(1, 0, 0), world)) {
                    return cur;
                }
                if (!this.isPassable(cur.m_7918_(-1, -dy, 0), world) && this.isPassable(cur.m_7918_(-1, 0, 0), world)) {
                    return cur;
                }
                if (!this.isPassable(cur.m_7918_(0, -dy, 1), world) && this.isPassable(cur.m_7918_(0, 0, 1), world)) {
                    return cur;
                }
                if (this.isPassable(cur.m_7918_(0, -dy, -1), world) || !this.isPassable(cur.m_7918_(0, 0, -1), world)) continue;
                return cur;
            }
            if (dx != 0 && !this.isPassable(cur.m_7918_(-dx, 0, 0), world) || dy != 0 && !this.isPassable(cur.m_7918_(0, -dy, 0), world) || dz != 0 && !this.isPassable(cur.m_7918_(0, 0, -dz), world)) break;
        }
        return cur;
    }

    private double getJumpCost(BlockPos a, BlockPos b, WorldSnapshot world) {
        int dx = Math.abs(a.m_123341_() - b.m_123341_());
        int dy = Math.abs(a.m_123342_() - b.m_123342_());
        int dz = Math.abs(a.m_123343_() - b.m_123343_());
        int diagonal = Math.min(dx, dz);
        int straight = Math.abs(dx - dz);
        double base = (double)diagonal * 1.414 + (double)straight * 1.0 + (double)dy * 0.5;
        base += world.getMovementCost(a, b);
        return base += this.riverbankBias(world, b);
    }

    private double riverbankBias(WorldSnapshot world, BlockPos pos) {
        if (world.isLiquid(pos)) {
            return 2.7;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0) continue;
                BlockPos p0 = pos.m_7918_(dx, 0, dz);
                BlockPos p1 = pos.m_7918_(dx, -1, dz);
                if ((!world.isValidPosition(p0) || !world.isLiquid(p0)) && (!world.isValidPosition(p1) || !world.isLiquid(p1))) continue;
                return 0.9;
            }
        }
        return 0.0;
    }

    private double heuristic(BlockPos from, BlockPos to, boolean weighted) {
        int dx = Math.abs(from.m_123341_() - to.m_123341_());
        int dy = Math.abs(from.m_123342_() - to.m_123342_());
        int dz = Math.abs(from.m_123343_() - to.m_123343_());
        int diagonalXZ = Math.min(dx, dz);
        int straightXZ = Math.abs(dx - dz);
        double base = 1.414 * (double)diagonalXZ + 1.0 * (double)straightXZ + 0.5 * (double)dy;
        double weight = weighted ? 1.2 : 1.0;
        double h = base * weight;
        return h + h * 0.001;
    }

    private boolean isAtGoal(BlockPos current, BlockPos goal, int reachRange) {
        return current.m_123331_((Vec3i)goal) <= (double)(reachRange * reachRange);
    }

    private Path constructPath(PathNode goalNode, WorldSnapshot world) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        PathNode current = goalNode;
        while (current != null) {
            positions.add(current.pos);
            current = current.parent;
        }
        Collections.reverse(positions);
        if (positions.isEmpty()) {
            return null;
        }
        List<BlockPos> smoothed = this.smoothPath(positions, world);
        ArrayList<Node> nodes = new ArrayList<Node>(smoothed.size());
        for (BlockPos p : smoothed) {
            nodes.add(new Node(p.m_123341_(), p.m_123342_(), p.m_123343_()));
        }
        return new Path(nodes, goalNode.pos, true);
    }

    private long computeTimeBudgetMs(WorldSnapshot world, BlockPos start, BlockPos goal) {
        int dist = start.m_123333_((Vec3i)goal);
        long budget = 12L;
        if (dist > 256) {
            budget += 8L;
        } else if (dist > 128) {
            budget += 4L;
        }
        if (this.hasLiquidNearby(world, start, 6) || this.hasLiquidNearby(world, goal, 6)) {
            budget += 8L;
        }
        return Math.min(36L, budget);
    }

    private boolean hasLiquidNearby(WorldSnapshot world, BlockPos center, int r) {
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                BlockPos p = center.m_7918_(dx, 0, dz);
                if (!world.isValidPosition(p) || !world.isLiquid(p)) continue;
                return true;
            }
        }
        return false;
    }

    private List<BlockPos> smoothPath(List<BlockPos> raw, WorldSnapshot world) {
        if (raw.size() <= 2) {
            return raw;
        }
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        int anchor = 0;
        result.add(raw.get(anchor));
        int look = 1;
        while (look < raw.size()) {
            int far;
            int i = far = look;
            while (i < raw.size() && this.hasLineOfSight(raw.get(anchor), raw.get(i), world)) {
                far = i++;
            }
            result.add(raw.get(far));
            anchor = far;
            look = far + 1;
        }
        return result;
    }

    private boolean hasLineOfSight(BlockPos a, BlockPos b, WorldSnapshot world) {
        int x0 = a.m_123341_();
        int y0 = a.m_123342_();
        int z0 = a.m_123343_();
        int x1 = b.m_123341_();
        int y1 = b.m_123342_();
        int z1 = b.m_123343_();
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int dz = Math.abs(z1 - z0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int sz = z0 < z1 ? 1 : -1;
        int x = x0;
        int y = y0;
        int z = z0;
        int dm = Math.max(dx, Math.max(dy, dz));
        for (int i = 0; i <= dm; ++i) {
            BlockPos p = new BlockPos(x, y, z);
            if (!world.isPassable(p)) {
                return false;
            }
            int err1 = 2 * dy - dx;
            int err2 = 2 * dz - dx;
            if (dx >= dy && dx >= dz) {
                if (err1 > 0) {
                    y += sy;
                    err1 -= 2 * dx;
                }
                if (err2 > 0) {
                    z += sz;
                    err2 -= 2 * dx;
                }
                err1 += 2 * dy;
                err2 += 2 * dz;
                x += sx;
                continue;
            }
            if (dy >= dx && dy >= dz) {
                err1 = 2 * dx - dy;
                err2 = 2 * dz - dy;
                if (err1 > 0) {
                    x += sx;
                    err1 -= 2 * dy;
                }
                if (err2 > 0) {
                    z += sz;
                    err2 -= 2 * dy;
                }
                err1 += 2 * dx;
                err2 += 2 * dz;
                y += sy;
                continue;
            }
            err1 = 2 * dx - dz;
            err2 = 2 * dy - dz;
            if (err1 > 0) {
                x += sx;
                err1 -= 2 * dz;
            }
            if (err2 > 0) {
                y += sy;
                err2 -= 2 * dz;
            }
            err1 += 2 * dx;
            err2 += 2 * dy;
            z += sz;
        }
        return true;
    }

    public PathfindingStats getStats() {
        return new PathfindingStats(this.maxIterations, this.maxNodes);
    }

    public static class PathfindingStats {
        public final int maxIterations;
        public final int maxNodes;

        public PathfindingStats(int maxIterations, int maxNodes) {
            this.maxIterations = maxIterations;
            this.maxNodes = maxNodes;
        }

        public String toString() {
            return String.format("PathfindingStats{maxIterations=%d, maxNodes=%d}", this.maxIterations, this.maxNodes);
        }
    }
}

