/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;

public final class CoarseWaypointPlanner {
    private CoarseWaypointPlanner() {
    }

    public static List<BlockPos> planLRoute(BlockPos start, BlockPos goal, int sectorSize) {
        ArrayList<BlockPos> waypoints = new ArrayList<BlockPos>();
        if (sectorSize <= 0) {
            return waypoints;
        }
        int sx = CoarseWaypointPlanner.floorDiv(start.m_123341_(), sectorSize);
        int sz = CoarseWaypointPlanner.floorDiv(start.m_123343_(), sectorSize);
        int gx = CoarseWaypointPlanner.floorDiv(goal.m_123341_(), sectorSize);
        int gz = CoarseWaypointPlanner.floorDiv(goal.m_123343_(), sectorSize);
        int y = start.m_123342_();
        int stepX = Integer.compare(gx, sx);
        int cx = sx;
        int cz = sz;
        while (cx != gx) {
            waypoints.add(CoarseWaypointPlanner.centerOf(cx += stepX, cz, y, sectorSize));
        }
        int stepZ = Integer.compare(gz, cz);
        while (cz != gz) {
            waypoints.add(CoarseWaypointPlanner.centerOf(cx, cz += stepZ, y, sectorSize));
        }
        return waypoints;
    }

    private static BlockPos centerOf(int sx, int sz, int y, int size) {
        int x = sx * size + size / 2;
        int z = sz * size + size / 2;
        return new BlockPos(x, y, z);
    }

    private static int floorDiv(int a, int b) {
        int q = a / b;
        int r = a % b;
        if (r != 0 && (a ^ b) < 0) {
            --q;
        }
        return q;
    }
}

