/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.pathfinding.TerrainDestruction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class EntitySnapshot {
    private final int entityId;
    private final BlockPos position;
    private final String entityType;
    private final String ownerName;
    private final boolean canFly;
    private final boolean canSwim;
    private final boolean canDestroyTerrain;
    private final boolean canClimbLadders;
    private final double movementSpeed;
    private final double maxHealth;
    private final double currentHealth;
    private final boolean isAlive;
    private final String mobTypeName;

    private EntitySnapshot(int entityId, BlockPos position, String entityType, String ownerName, boolean canFly, boolean canSwim, boolean canDestroyTerrain, boolean canClimbLadders, double movementSpeed, double maxHealth, double currentHealth, boolean isAlive, String mobTypeName) {
        this.entityId = entityId;
        this.position = position;
        this.entityType = entityType;
        this.ownerName = ownerName;
        this.canFly = canFly;
        this.canSwim = canSwim;
        this.canDestroyTerrain = canDestroyTerrain;
        this.canClimbLadders = canClimbLadders;
        this.movementSpeed = movementSpeed;
        this.maxHealth = maxHealth;
        this.currentHealth = currentHealth;
        this.isAlive = isAlive;
        this.mobTypeName = mobTypeName;
    }

    public static EntitySnapshot create(Mob mob) {
        if (mob.m_9236_().m_5776_()) {
            throw new IllegalStateException("EntitySnapshot should only be created on the server side");
        }
        BlockPos position = mob.m_20097_();
        String entityType = mob.m_6095_().m_20675_();
        String mobTypeName = entityType.toLowerCase();
        String ownerName = "";
        boolean canDestroyTerrain = false;
        boolean canClimbLadders = false;
        if (mob instanceof Unit) {
            Unit unit = (Unit)mob;
            ownerName = unit.getOwnerName();
            try {
                canDestroyTerrain = TerrainDestruction.canUnitDestroy(mob);
                canClimbLadders = TerrainDestruction.canUnitClimbLadders(mob);
            }
            catch (Exception e) {
                canDestroyTerrain = false;
                canClimbLadders = false;
            }
        }
        boolean canFly = mobTypeName.contains("ghast") || mobTypeName.contains("blaze") || mobTypeName.contains("wither") || mobTypeName.contains("vex");
        boolean canSwim = !mobTypeName.contains("enderman");
        double movementSpeed = 0.25;
        double maxHealth = 20.0;
        double currentHealth = 20.0;
        try {
            AttributeInstance healthAttribute;
            AttributeInstance speedAttribute = mob.m_21051_(Attributes.f_22279_);
            if (speedAttribute != null) {
                movementSpeed = speedAttribute.m_22135_();
            }
            if ((healthAttribute = mob.m_21051_(Attributes.f_22276_)) != null) {
                maxHealth = healthAttribute.m_22135_();
            }
            currentHealth = mob.m_21223_();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new EntitySnapshot(mob.m_19879_(), position, entityType, ownerName, canFly, canSwim, canDestroyTerrain, canClimbLadders, movementSpeed, maxHealth, currentHealth, mob.m_6084_(), mobTypeName);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean canFly() {
        return this.canFly;
    }

    public boolean canSwim() {
        return this.canSwim;
    }

    public boolean canDestroyTerrain() {
        return this.canDestroyTerrain;
    }

    public boolean canClimbLadders() {
        return this.canClimbLadders;
    }

    public double getMovementSpeed() {
        return this.movementSpeed;
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public double getCurrentHealth() {
        return this.currentHealth;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public String getMobTypeName() {
        return this.mobTypeName;
    }

    public boolean canTraverseLava() {
        return this.mobTypeName.contains("blaze") || this.mobTypeName.contains("ghast") || this.mobTypeName.contains("magma") || this.mobTypeName.contains("wither") || this.mobTypeName.contains("strider");
    }

    public boolean canTraverseWater() {
        return this.canSwim && !this.mobTypeName.contains("enderman");
    }

    public boolean prefersWater() {
        return this.mobTypeName.contains("drowned");
    }

    public double getTerrainPenalty(String terrainType) {
        switch (terrainType.toLowerCase()) {
            case "sand": 
            case "gravel": {
                return 1.5;
            }
            case "soul_sand": {
                return 2.0;
            }
            case "water": {
                return this.canSwim() ? 1.2 : 3.0;
            }
            case "lava": {
                return this.canTraverseLava() ? 0.8 : 999.0;
            }
        }
        return 1.0;
    }

    public String toString() {
        return String.format("EntitySnapshot{id=%d, type=%s, pos=%s, owner=%s, alive=%s}", this.entityId, this.entityType, this.position, this.ownerName, this.isAlive);
    }
}

