/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import com.solegendary.reignofnether.unit.pathfinding.async.WorldSnapshot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public final class HPAPlanner {
    private HPAPlanner() {
    }

    public static List<BlockPos> planGatewayRoute(Level level, Mob mob, BlockPos start, BlockPos goal, int sectorSize) {
        ArrayList<BlockPos> waypoints = new ArrayList<BlockPos>();
        if (sectorSize <= 0) {
            return waypoints;
        }
        int sx = HPAPlanner.floorDiv(start.m_123341_(), sectorSize);
        int sz = HPAPlanner.floorDiv(start.m_123343_(), sectorSize);
        int gx = HPAPlanner.floorDiv(goal.m_123341_(), sectorSize);
        int gz = HPAPlanner.floorDiv(goal.m_123343_(), sectorSize);
        int dx = Integer.compare(gx, sx);
        int dz = Integer.compare(gz, sz);
        int cx = sx;
        int cz = sz;
        while (cx != gx || cz != gz) {
            BlockPos gw;
            if (cx != gx) {
                int nx = cx + dx;
                gw = HPAPlanner.findGatewayOnBoundaryX(level, mob, cx, cz, nx, sectorSize);
                if (gw != null) {
                    waypoints.add(gw);
                }
                cx = nx;
                continue;
            }
            if (cz == gz) continue;
            int nz = cz + dz;
            gw = HPAPlanner.findGatewayOnBoundaryZ(level, mob, cx, cz, nz, sectorSize);
            if (gw != null) {
                waypoints.add(gw);
            }
            cz = nz;
        }
        return waypoints;
    }

    private static BlockPos findGatewayOnBoundaryX(Level level, Mob mob, int cx, int cz, int nx, int sector) {
        BlockPos bCenter;
        int minZ = Math.min(cz, cz) * sector;
        int maxZ = minZ + sector - 1;
        int boundaryX = Math.max(cx, nx) * sector;
        int baseY = mob.m_20183_().m_123342_();
        BlockPos aCenter = new BlockPos(cx * sector + sector / 2, baseY, cz * sector + sector / 2);
        WorldSnapshot snap = WorldSnapshot.create(level, mob, aCenter, bCenter = new BlockPos(nx * sector + sector / 2, baseY, cz * sector + sector / 2), sector + 32);
        if (snap == null || !snap.isValid(3000L)) {
            return null;
        }
        for (int z = minZ; z <= maxZ; ++z) {
            int stepX;
            BlockPos next;
            BlockPos base = new BlockPos(boundaryX, baseY, z);
            BlockPos cand = HPAPlanner.findPassableNearY(snap, base, 3);
            if (cand == null || !snap.isValidPosition(next = cand.m_7918_(stepX = nx > cx ? 1 : -1, 0, 0)) || !snap.isPassable(next) || snap.isLiquid(cand) || snap.isLiquid(next)) continue;
            return cand;
        }
        return null;
    }

    private static BlockPos findGatewayOnBoundaryZ(Level level, Mob mob, int cx, int cz, int nz, int sector) {
        BlockPos bCenter;
        int minX = Math.min(cx, cx) * sector;
        int maxX = minX + sector - 1;
        int boundaryZ = Math.max(cz, nz) * sector;
        int baseY = mob.m_20183_().m_123342_();
        BlockPos aCenter = new BlockPos(cx * sector + sector / 2, baseY, cz * sector + sector / 2);
        WorldSnapshot snap = WorldSnapshot.create(level, mob, aCenter, bCenter = new BlockPos(cx * sector + sector / 2, baseY, nz * sector + sector / 2), sector + 32);
        if (snap == null || !snap.isValid(3000L)) {
            return null;
        }
        for (int x = minX; x <= maxX; ++x) {
            int stepZ;
            BlockPos next;
            BlockPos base = new BlockPos(x, baseY, boundaryZ);
            BlockPos cand = HPAPlanner.findPassableNearY(snap, base, 3);
            if (cand == null || !snap.isValidPosition(next = cand.m_7918_(0, 0, stepZ = nz > cz ? 1 : -1)) || !snap.isPassable(next) || snap.isLiquid(cand) || snap.isLiquid(next)) continue;
            return cand;
        }
        return null;
    }

    private static BlockPos findPassableNearY(WorldSnapshot snap, BlockPos pos, int yRange) {
        int y0 = pos.m_123342_();
        for (int dy = -yRange; dy <= yRange; ++dy) {
            BlockPos p = pos.m_7918_(0, dy, 0);
            if (!snap.isValidPosition(p) || !snap.isPassable(p)) continue;
            return p;
        }
        return null;
    }

    private static int floorDiv(int a, int b) {
        int r = a / b;
        if ((a ^ b) < 0 && r * b != a) {
            --r;
        }
        return r;
    }
}

