/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import com.solegendary.reignofnether.unit.pathfinding.AStarPathfinder;
import com.solegendary.reignofnether.unit.pathfinding.PathfindingCache;
import com.solegendary.reignofnether.unit.pathfinding.async.CoarseWaypointPlanner;
import com.solegendary.reignofnether.unit.pathfinding.async.HPAPlanner;
import com.solegendary.reignofnether.unit.pathfinding.async.PathPostProcessor;
import com.solegendary.reignofnether.unit.pathfinding.async.PathSmoother;
import com.solegendary.reignofnether.unit.pathfinding.async.PathfindingCallback;
import com.solegendary.reignofnether.unit.pathfinding.async.PathfindingTask;
import com.solegendary.reignofnether.unit.pathfinding.async.PathfindingThreadPool;
import com.solegendary.reignofnether.unit.pathfinding.async.WorldSnapshot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class MultiThreadedPathfindingManager {
    private static MultiThreadedPathfindingManager INSTANCE;
    private static final long MAX_SNAPSHOT_AGE_MS = 3000L;
    private static final int DEFAULT_MAX_SEARCH_RADIUS = 200;
    private static final boolean ENABLE_FALLBACK = true;
    private static final int SECTOR_SIZE = 64;
    private final PathfindingThreadPool threadPool;
    private final AStarPathfinder fallbackPathfinder;
    private final MinecraftServer server;
    private volatile boolean enabled = true;
    private volatile long totalAsyncRequests = 0L;
    private volatile long totalSyncFallbacks = 0L;
    private volatile long totalFailures = 0L;

    private MultiThreadedPathfindingManager(MinecraftServer server) {
        this.server = server;
        this.threadPool = new PathfindingThreadPool(server);
        this.fallbackPathfinder = null;
    }

    public static synchronized void initialize(MinecraftServer server) {
        if (INSTANCE == null) {
            INSTANCE = new MultiThreadedPathfindingManager(server);
        }
    }

    public static MultiThreadedPathfindingManager getInstance() {
        return INSTANCE;
    }

    public static synchronized void shutdown() {
        if (INSTANCE != null) {
            MultiThreadedPathfindingManager.INSTANCE.threadPool.shutdown();
            INSTANCE = null;
        }
    }

    public CompletableFuture<Path> findPathAsync(final Mob mob, final BlockPos start, BlockPos goal, final int reachRange, final PathfindingTask.Priority priority, PathfindingCallback callback) {
        boolean useCorridor;
        ++this.totalAsyncRequests;
        if (!this.enabled || this.threadPool == null) {
            return this.fallbackToSync(mob, start, goal, reachRange, callback);
        }
        Path cachedPath = PathfindingCache.getPath(start, goal, reachRange);
        if (cachedPath != null) {
            CompletableFuture<Path> future = CompletableFuture.completedFuture(cachedPath);
            if (callback != null) {
                callback.onPathfindingComplete(mob.m_19879_(), start, goal, cachedPath, true, null);
            }
            return future;
        }
        WorldSnapshot snapshot = WorldSnapshot.create(mob.m_9236_(), mob, start, goal, 200);
        if (snapshot == null || !snapshot.isValid(3000L)) {
            return this.fallbackToSync(mob, start, goal, reachRange, callback);
        }
        List<Object> corridor = Collections.emptyList();
        boolean bl = useCorridor = start.m_123333_((Vec3i)goal) > 384;
        if (useCorridor) {
            List<BlockPos> hpa = HPAPlanner.planGatewayRoute(mob.m_9236_(), mob, start, goal, 64);
            corridor = hpa.isEmpty() ? CoarseWaypointPlanner.planLRoute(start, goal, 64) : hpa;
        }
        CompletableFuture<Path> future = new CompletableFuture<Path>();
        PathfindingCallback wrappedCallback = (entityId, startPos, goalPos, result, success, errorMessage) -> {
            if (success && result != null) {
                Entity entity = mob.m_9236_().m_6815_(entityId);
                if (entity == null || !entity.m_6084_()) {
                    future.complete(null);
                    return;
                }
                if (result != null && result.m_77398_() > 2) {
                    ArrayList<BlockPos> raw = new ArrayList<BlockPos>(result.m_77398_());
                    for (Node n : result.f_77362_) {
                        raw.add(new BlockPos(n.f_77271_, n.f_77272_, n.f_77273_));
                    }
                    List<BlockPos> smoothed = PathPostProcessor.funnelWithPortals(raw, 0.45);
                    if ((smoothed = PathSmoother.smoothWithSnapshot(smoothed, mob.m_9236_(), mob, 200)).size() != raw.size()) {
                        ArrayList<Node> nn = new ArrayList<Node>(smoothed.size());
                        for (BlockPos p : smoothed) {
                            nn.add(new Node(p.m_123341_(), p.m_123342_(), p.m_123343_()));
                        }
                        result = new Path(nn, goalPos, true);
                    }
                }
                future.complete(result);
                PathfindingCache.putPath(startPos, goalPos, reachRange, result);
            } else {
                future.complete(null);
            }
            if (callback != null) {
                callback.onPathfindingComplete(entityId, startPos, goalPos, result, success, errorMessage);
            }
        };
        boolean useWeighted = start.m_123333_((Vec3i)goal) > 256;
        PathfindingTask task = new PathfindingTask(mob.m_19879_(), start, goal, reachRange, snapshot, priority, wrappedCallback, 200, useWeighted);
        boolean queued = this.threadPool.submitTask(task);
        if (!queued) {
            return this.fallbackToSync(mob, start, goal, reachRange, callback);
        }
        if (!useCorridor || corridor.isEmpty()) {
            return future;
        }
        final CompletableFuture<Path> chained = new CompletableFuture<Path>();
        final ArrayList<Object> waypoints = new ArrayList<Object>(corridor);
        waypoints.add(goal);
        class SegmentRunner {
            BlockPos segStart;
            final List<Node> allNodes;
            int index;

            SegmentRunner() {
                this.segStart = start;
                this.allNodes = new ArrayList<Node>();
                this.index = 0;
            }

            void next() {
                if (this.index >= waypoints.size()) {
                    if (this.allNodes.isEmpty()) {
                        chained.complete(null);
                        return;
                    }
                    BlockPos tgt = (BlockPos)waypoints.get(waypoints.size() - 1);
                    Path finalPath = new Path(this.allNodes, tgt, true);
                    chained.complete(finalPath);
                    return;
                }
                BlockPos segGoal = (BlockPos)waypoints.get(this.index);
                WorldSnapshot snap = WorldSnapshot.create(mob.m_9236_(), mob, this.segStart, segGoal, 200);
                boolean weighted = this.segStart.m_123333_((Vec3i)segGoal) > 256;
                PathfindingTask segTask = new PathfindingTask(mob.m_19879_(), this.segStart, segGoal, reachRange, snap, priority, (id, s, g, res, ok, err) -> {
                    if (!ok || res == null) {
                        chained.complete(null);
                        return;
                    }
                    if (res != null && res.m_77398_() > 2) {
                        ArrayList<BlockPos> raw = new ArrayList<BlockPos>(res.m_77398_());
                        for (Node n : res.f_77362_) {
                            raw.add(new BlockPos(n.f_77271_, n.f_77272_, n.f_77273_));
                        }
                        List<BlockPos> smoothed = PathPostProcessor.funnelWithPortals(raw, 0.45);
                        smoothed = PathSmoother.smoothWithSnapshot(smoothed, mob.m_9236_(), mob, 200);
                        ArrayList<Node> nn = new ArrayList<Node>(smoothed.size());
                        for (BlockPos p : smoothed) {
                            nn.add(new Node(p.m_123341_(), p.m_123342_(), p.m_123343_()));
                        }
                        this.allNodes.addAll(nn);
                    } else if (res != null) {
                        this.allNodes.addAll(res.f_77362_);
                    }
                    this.segStart = segGoal;
                    ++this.index;
                    this.next();
                }, 200, weighted);
                if (!MultiThreadedPathfindingManager.this.threadPool.submitTask(segTask)) {
                    chained.complete(null);
                }
            }
        }
        new SegmentRunner().next();
        return chained;
    }

    public Path findPathSync(Mob mob, BlockPos start, BlockPos goal, int reachRange) {
        Path cachedPath = PathfindingCache.getPath(start, goal, reachRange);
        if (cachedPath != null) {
            return cachedPath;
        }
        AStarPathfinder pathfinder = new AStarPathfinder(mob.m_9236_(), mob);
        Path result = pathfinder.findPath(start, goal, reachRange);
        if (result != null) {
            PathfindingCache.putPath(start, goal, reachRange, result);
        }
        return result;
    }

    public boolean cancelPathfinding(int entityId) {
        if (this.threadPool != null) {
            return this.threadPool.cancelTasksForEntity(entityId);
        }
        return false;
    }

    public void invalidateArea(BlockPos center, int radius) {
        PathfindingCache.invalidateArea(center, radius);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public PathfindingStatistics getStatistics() {
        PathfindingThreadPool.ThreadPoolStatistics poolStats = null;
        if (this.threadPool != null) {
            poolStats = this.threadPool.getStatistics();
        }
        PathfindingCache.CacheStatistics cacheStats = PathfindingCache.getStatistics();
        return new PathfindingStatistics(this.enabled, this.totalAsyncRequests, this.totalSyncFallbacks, this.totalFailures, poolStats, cacheStats);
    }

    private CompletableFuture<Path> fallbackToSync(Mob mob, BlockPos start, BlockPos goal, int reachRange, PathfindingCallback callback) {
        ++this.totalSyncFallbacks;
        CompletableFuture<Path> future = new CompletableFuture<Path>();
        if (this.server != null && this.server.m_130010_()) {
            this.server.execute(() -> {
                block3: {
                    try {
                        Path result = this.findPathSync(mob, start, goal, reachRange);
                        future.complete(result);
                        if (callback != null) {
                            boolean success = result != null;
                            String errorMessage = success ? null : "Synchronous pathfinding failed";
                            callback.onPathfindingComplete(mob.m_19879_(), start, goal, result, success, errorMessage);
                        }
                    }
                    catch (Exception e) {
                        ++this.totalFailures;
                        future.complete(null);
                        if (callback == null) break block3;
                        callback.onPathfindingComplete(mob.m_19879_(), start, goal, null, false, "Synchronous fallback error: " + e.getMessage());
                    }
                }
            });
        } else {
            future.complete(null);
            ++this.totalFailures;
        }
        return future;
    }

    public static class PathfindingStatistics {
        public final boolean enabled;
        public final long totalAsyncRequests;
        public final long totalSyncFallbacks;
        public final long totalFailures;
        public final PathfindingThreadPool.ThreadPoolStatistics threadPoolStats;
        public final PathfindingCache.CacheStatistics cacheStats;

        public PathfindingStatistics(boolean enabled, long totalAsyncRequests, long totalSyncFallbacks, long totalFailures, PathfindingThreadPool.ThreadPoolStatistics threadPoolStats, PathfindingCache.CacheStatistics cacheStats) {
            this.enabled = enabled;
            this.totalAsyncRequests = totalAsyncRequests;
            this.totalSyncFallbacks = totalSyncFallbacks;
            this.totalFailures = totalFailures;
            this.threadPoolStats = threadPoolStats;
            this.cacheStats = cacheStats;
        }

        public double getFallbackRate() {
            return this.totalAsyncRequests > 0L ? (double)this.totalSyncFallbacks / (double)this.totalAsyncRequests : 0.0;
        }

        public double getFailureRate() {
            long total = this.totalAsyncRequests;
            return total > 0L ? (double)this.totalFailures / (double)total : 0.0;
        }

        public String toString() {
            return String.format("PathfindingStats{enabled=%s, async=%d, fallback=%d (%.1f%%), failures=%d (%.1f%%), %s, %s}", this.enabled, this.totalAsyncRequests, this.totalSyncFallbacks, this.getFallbackRate() * 100.0, this.totalFailures, this.getFailureRate() * 100.0, this.threadPoolStats != null ? this.threadPoolStats.toString() : "No ThreadPool", this.cacheStats != null ? this.cacheStats.toString() : "No Cache");
        }
    }
}

