/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;

public final class PathPostProcessor {
    private PathPostProcessor() {
    }

    public static List<BlockPos> funnelXZ(List<BlockPos> raw) {
        if (raw == null || raw.size() <= 2) {
            return raw;
        }
        ArrayList<double[]> pts = new ArrayList<double[]>(raw.size());
        for (BlockPos p : raw) {
            pts.add(new double[]{(double)p.m_123341_() + 0.5, (double)p.m_123343_() + 0.5, p.m_123342_()});
        }
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        int anchor = 0;
        out.add(raw.get(anchor));
        int i = 1;
        while (i < pts.size()) {
            int far = i;
            int j = i;
            while (j < pts.size() && PathPostProcessor.visibleXZ((double[])pts.get(anchor), (double[])pts.get(j))) {
                far = j++;
            }
            out.add(raw.get(far));
            anchor = far;
            i = far + 1;
        }
        return out;
    }

    private static boolean visibleXZ(double[] a, double[] b) {
        return true;
    }

    public static List<BlockPos> funnelWithPortals(List<BlockPos> raw, double portalHalfWidth) {
        if (raw == null || raw.size() <= 2) {
            return raw;
        }
        ArrayList<double[]> left = new ArrayList<double[]>();
        ArrayList<double[]> right = new ArrayList<double[]>();
        for (int i = 0; i < raw.size() - 1; ++i) {
            BlockPos a = raw.get(i);
            BlockPos b = raw.get(i + 1);
            double ax = (double)a.m_123341_() + 0.5;
            double az = (double)a.m_123343_() + 0.5;
            double bx = (double)b.m_123341_() + 0.5;
            double bz = (double)b.m_123343_() + 0.5;
            double mx = (ax + bx) * 0.5;
            double mz = (az + bz) * 0.5;
            double dx = bx - ax;
            double dz = bz - az;
            double len = Math.max(1.0E-6, Math.hypot(dx, dz));
            double px = -dz / len;
            double pz = dx / len;
            left.add(new double[]{mx + px * portalHalfWidth, mz + pz * portalHalfWidth});
            right.add(new double[]{mx - px * portalHalfWidth, mz - pz * portalHalfWidth});
        }
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        double[] apex = new double[]{(double)raw.get(0).m_123341_() + 0.5, (double)raw.get(0).m_123343_() + 0.5};
        double[] leftLeg = (double[])((double[])left.get(0)).clone();
        double[] rightLeg = (double[])((double[])right.get(0)).clone();
        out.add(raw.get(0));
        for (int i = 1; i < left.size(); ++i) {
            double[] nl = (double[])left.get(i);
            double[] nr = (double[])right.get(i);
            if (PathPostProcessor.triarea2(apex, leftLeg, nl) >= 0.0) {
                if (PathPostProcessor.triarea2(apex, rightLeg, nl) > 0.0) {
                    out.add(PathPostProcessor.toBlockPos(apex, raw.get(i).m_123342_()));
                    apex = rightLeg;
                    leftLeg = nl;
                    rightLeg = nr;
                    continue;
                }
                leftLeg = nl;
            }
            if (!(PathPostProcessor.triarea2(apex, rightLeg, nr) <= 0.0)) continue;
            if (PathPostProcessor.triarea2(apex, leftLeg, nr) < 0.0) {
                out.add(PathPostProcessor.toBlockPos(apex, raw.get(i).m_123342_()));
                apex = leftLeg;
                leftLeg = nl;
                rightLeg = nr;
                continue;
            }
            rightLeg = nr;
        }
        out.add(raw.get(raw.size() - 1));
        return out;
    }

    private static BlockPos toBlockPos(double[] apex, int y) {
        return new BlockPos((int)Math.floor(apex[0]), y, (int)Math.floor(apex[1]));
    }

    private static double triarea2(double[] a, double[] b, double[] c) {
        return (b[0] - a[0]) * (c[1] - a[1]) - (b[1] - a[1]) * (c[0] - a[0]);
    }
}

