/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import com.solegendary.reignofnether.unit.pathfinding.async.WorldSnapshot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public final class PathSmoother {
    private PathSmoother() {
    }

    public static List<BlockPos> smoothWithSnapshot(List<BlockPos> raw, Level level, Mob mob, int searchRadius) {
        BlockPos goal;
        if (raw == null || raw.size() <= 2) {
            return raw;
        }
        BlockPos start = raw.get(0);
        WorldSnapshot snapshot = WorldSnapshot.create(level, mob, start, goal = raw.get(raw.size() - 1), searchRadius);
        if (snapshot == null || !snapshot.isValid(3000L)) {
            return raw;
        }
        return PathSmoother.smoothPath(raw, snapshot);
    }

    private static List<BlockPos> smoothPath(List<BlockPos> raw, WorldSnapshot world) {
        if (raw.size() <= 2) {
            return raw;
        }
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        int anchor = 0;
        result.add(raw.get(anchor));
        int look = 1;
        while (look < raw.size()) {
            int far;
            int i = far = look;
            while (i < raw.size() && PathSmoother.hasLineOfSight(raw.get(anchor), raw.get(i), world)) {
                far = i++;
            }
            if (far == anchor) {
                far = Math.min(anchor + 1, raw.size() - 1);
            }
            result.add(raw.get(far));
            anchor = far;
            look = far + 1;
        }
        if (!((BlockPos)result.get(result.size() - 1)).equals((Object)raw.get(raw.size() - 1))) {
            result.add(raw.get(raw.size() - 1));
        }
        return result;
    }

    private static boolean hasLineOfSight(BlockPos a, BlockPos b, WorldSnapshot world) {
        int x0 = a.m_123341_();
        int y0 = a.m_123342_();
        int z0 = a.m_123343_();
        int x1 = b.m_123341_();
        int y1 = b.m_123342_();
        int z1 = b.m_123343_();
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int dz = Math.abs(z1 - z0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int sz = z0 < z1 ? 1 : -1;
        int x = x0;
        int y = y0;
        int z = z0;
        int dm = Math.max(dx, Math.max(dy, dz));
        for (int i = 0; i <= dm; ++i) {
            BlockPos p = new BlockPos(x, y, z);
            if (!world.isPassable(p)) {
                return false;
            }
            int err1 = 2 * dy - dx;
            int err2 = 2 * dz - dx;
            if (dx >= dy && dx >= dz) {
                if (err1 > 0) {
                    y += sy;
                    err1 -= 2 * dx;
                }
                if (err2 > 0) {
                    z += sz;
                    err2 -= 2 * dx;
                }
                err1 += 2 * dy;
                err2 += 2 * dz;
                x += sx;
                continue;
            }
            if (dy >= dx && dy >= dz) {
                err1 = 2 * dx - dy;
                err2 = 2 * dz - dy;
                if (err1 > 0) {
                    x += sx;
                    err1 -= 2 * dy;
                }
                if (err2 > 0) {
                    z += sz;
                    err2 -= 2 * dy;
                }
                err1 += 2 * dx;
                err2 += 2 * dz;
                y += sy;
                continue;
            }
            err1 = 2 * dx - dz;
            err2 = 2 * dy - dz;
            if (err1 > 0) {
                x += sx;
                err1 -= 2 * dz;
            }
            if (err2 > 0) {
                y += sy;
                err2 -= 2 * dz;
            }
            err1 += 2 * dx;
            err2 += 2 * dy;
            z += sz;
        }
        return true;
    }
}

