/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import com.solegendary.reignofnether.unit.pathfinding.async.PathfindingCallback;
import com.solegendary.reignofnether.unit.pathfinding.async.WorldSnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.pathfinder.Path;

public class PathfindingTask {
    private final int entityId;
    private final BlockPos startPos;
    private final BlockPos goalPos;
    private final int reachRange;
    private final WorldSnapshot worldSnapshot;
    private final Priority priority;
    private final long creationTime;
    private final PathfindingCallback callback;
    private final int maxSearchRadius;
    private final boolean weightedHeuristic;
    private volatile boolean cancelled = false;
    private volatile boolean started = false;
    private volatile boolean completed = false;

    public PathfindingTask(int entityId, BlockPos startPos, BlockPos goalPos, int reachRange, WorldSnapshot worldSnapshot, Priority priority, PathfindingCallback callback, int maxSearchRadius, boolean weightedHeuristic) {
        this.entityId = entityId;
        this.startPos = startPos;
        this.goalPos = goalPos;
        this.reachRange = reachRange;
        this.worldSnapshot = worldSnapshot;
        this.priority = priority;
        this.callback = callback;
        this.maxSearchRadius = maxSearchRadius;
        this.creationTime = System.currentTimeMillis();
        this.weightedHeuristic = weightedHeuristic;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public BlockPos getStartPos() {
        return this.startPos;
    }

    public BlockPos getGoalPos() {
        return this.goalPos;
    }

    public int getReachRange() {
        return this.reachRange;
    }

    public WorldSnapshot getWorldSnapshot() {
        return this.worldSnapshot;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public PathfindingCallback getCallback() {
        return this.callback;
    }

    public int getMaxSearchRadius() {
        return this.maxSearchRadius;
    }

    public boolean isWeightedHeuristic() {
        return this.weightedHeuristic;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void markStarted() {
        this.started = true;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void markCompleted() {
        this.completed = true;
    }

    public long getAge() {
        return System.currentTimeMillis() - this.creationTime;
    }

    public boolean isStale(long maxAgeMs) {
        return this.getAge() > maxAgeMs;
    }

    public boolean hasValidSnapshot(long maxSnapshotAgeMs) {
        return this.worldSnapshot != null && this.worldSnapshot.isValid(maxSnapshotAgeMs);
    }

    public void deliverResult(Path result, boolean success, String errorMessage) {
        if (this.callback != null && !this.cancelled) {
            try {
                this.callback.onPathfindingComplete(this.entityId, this.startPos, this.goalPos, result, success, errorMessage);
            }
            catch (Exception e) {
                System.err.println("Error in pathfinding callback for entity " + this.entityId + ": " + e.getMessage());
            }
        }
        this.markCompleted();
    }

    public int getPriorityValue() {
        return this.priority.getValue();
    }

    public double getUrgency() {
        double priorityWeight = this.priority.getValue();
        double ageWeight = (double)this.getAge() / 1000.0;
        return priorityWeight + ageWeight * 0.1;
    }

    public String toString() {
        return String.format("PathfindingTask{entity=%d, %s->%s, priority=%s, age=%dms, %s}", new Object[]{this.entityId, this.startPos, this.goalPos, this.priority, this.getAge(), this.cancelled ? "CANCELLED" : (this.started ? "STARTED" : "PENDING")});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathfindingTask)) {
            return false;
        }
        PathfindingTask other = (PathfindingTask)obj;
        return this.entityId == other.entityId && this.startPos.equals((Object)other.startPos) && this.goalPos.equals((Object)other.goalPos) && this.reachRange == other.reachRange;
    }

    public int hashCode() {
        int result = this.entityId;
        result = 31 * result + this.startPos.hashCode();
        result = 31 * result + this.goalPos.hashCode();
        result = 31 * result + this.reachRange;
        return result;
    }

    public static enum Priority {
        HIGH(0),
        NORMAL(1),
        LOW(2);

        private final int value;

        private Priority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

