/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import com.solegendary.reignofnether.unit.pathfinding.async.PathfindingTask;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class PathfindingTaskQueue {
    private static final long MAX_TASK_AGE_MS = 5000L;
    private static final long MAX_SNAPSHOT_AGE_MS = 3000L;
    private static final int MAX_QUEUE_SIZE = 1000;
    private static final int CLEANUP_INTERVAL = 100;
    private final PriorityBlockingQueue<PathfindingTask> taskQueue;
    private final Map<String, PathfindingTask> tasksByKey;
    private final Map<Integer, PathfindingTask> tasksByEntity;
    private final AtomicInteger totalTasksQueued = new AtomicInteger(0);
    private final AtomicInteger totalTasksCompleted = new AtomicInteger(0);
    private final AtomicInteger totalTasksCancelled = new AtomicInteger(0);
    private int operationCount = 0;

    public PathfindingTaskQueue() {
        this.taskQueue = new PriorityBlockingQueue<PathfindingTask>(16, Comparator.comparingDouble(PathfindingTask::getUrgency));
        this.tasksByKey = new ConcurrentHashMap<String, PathfindingTask>();
        this.tasksByEntity = new ConcurrentHashMap<Integer, PathfindingTask>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue(PathfindingTask task) {
        if (task == null) {
            return false;
        }
        if (this.taskQueue.size() >= 1000) {
            this.cleanupLowPriorityTasks();
            if (this.taskQueue.size() >= 1000) {
                return false;
            }
        }
        String taskKey = this.generateTaskKey(task);
        PathfindingTaskQueue pathfindingTaskQueue = this;
        synchronized (pathfindingTaskQueue) {
            PathfindingTask existingTask = this.tasksByEntity.get(task.getEntityId());
            if (existingTask != null) {
                existingTask.cancel();
                this.removeTaskFromTracking(existingTask);
            }
            this.taskQueue.offer(task);
            this.tasksByKey.put(taskKey, task);
            this.tasksByEntity.put(task.getEntityId(), task);
            this.totalTasksQueued.incrementAndGet();
            if (++this.operationCount % 100 == 0) {
                this.cleanupStaleTasks();
            }
        }
        return true;
    }

    public PathfindingTask dequeue() {
        try {
            PathfindingTask task;
            do {
                if ((task = this.taskQueue.take()).isCancelled()) {
                    this.removeTaskFromTracking(task);
                    this.totalTasksCancelled.incrementAndGet();
                    task = null;
                    continue;
                }
                if (task.isStale(5000L)) {
                    task.cancel();
                    this.removeTaskFromTracking(task);
                    this.totalTasksCancelled.incrementAndGet();
                    task = null;
                    continue;
                }
                if (!task.hasValidSnapshot(3000L)) {
                    task.cancel();
                    this.removeTaskFromTracking(task);
                    this.totalTasksCancelled.incrementAndGet();
                    task = null;
                    continue;
                }
                task.markStarted();
                this.removeTaskFromTracking(task);
            } while (task == null);
            return task;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public PathfindingTask poll() {
        PathfindingTask task;
        while ((task = this.taskQueue.poll()) != null) {
            if (task.isCancelled() || task.isStale(5000L) || !task.hasValidSnapshot(3000L)) {
                if (!task.isCancelled()) {
                    task.cancel();
                    this.totalTasksCancelled.incrementAndGet();
                }
                this.removeTaskFromTracking(task);
                continue;
            }
            task.markStarted();
            this.removeTaskFromTracking(task);
            return task;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelTasksForEntity(int entityId) {
        PathfindingTaskQueue pathfindingTaskQueue = this;
        synchronized (pathfindingTaskQueue) {
            PathfindingTask task = this.tasksByEntity.get(entityId);
            if (task != null) {
                task.cancel();
                this.removeTaskFromTracking(task);
                this.totalTasksCancelled.incrementAndGet();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllTasks() {
        PathfindingTaskQueue pathfindingTaskQueue = this;
        synchronized (pathfindingTaskQueue) {
            for (PathfindingTask task : this.taskQueue) {
                if (task.isCancelled()) continue;
                task.cancel();
                this.totalTasksCancelled.incrementAndGet();
            }
            this.taskQueue.clear();
            this.tasksByKey.clear();
            this.tasksByEntity.clear();
        }
    }

    public int size() {
        return this.taskQueue.size();
    }

    public boolean isEmpty() {
        return this.taskQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueStatistics getStatistics() {
        PathfindingTaskQueue pathfindingTaskQueue = this;
        synchronized (pathfindingTaskQueue) {
            return new QueueStatistics(this.taskQueue.size(), this.totalTasksQueued.get(), this.totalTasksCompleted.get(), this.totalTasksCancelled.get(), this.countTasksByPriority());
        }
    }

    private void cleanupStaleTasks() {
        ArrayList<PathfindingTask> staleTasks = new ArrayList<PathfindingTask>();
        for (PathfindingTask task : this.taskQueue) {
            if (!task.isCancelled() && !task.isStale(5000L) && task.hasValidSnapshot(3000L)) continue;
            staleTasks.add(task);
        }
        for (PathfindingTask staleTask : staleTasks) {
            if (!staleTask.isCancelled()) {
                staleTask.cancel();
                this.totalTasksCancelled.incrementAndGet();
            }
            this.taskQueue.remove(staleTask);
            this.removeTaskFromTracking(staleTask);
        }
    }

    private void cleanupLowPriorityTasks() {
        ArrayList<PathfindingTask> lowPriorityTasks = new ArrayList<PathfindingTask>();
        for (PathfindingTask task : this.taskQueue) {
            if (task.getPriority() != PathfindingTask.Priority.LOW) continue;
            lowPriorityTasks.add(task);
        }
        int toRemove = Math.min(lowPriorityTasks.size(), 250);
        for (int i = 0; i < toRemove; ++i) {
            PathfindingTask task = (PathfindingTask)lowPriorityTasks.get(i);
            task.cancel();
            this.taskQueue.remove(task);
            this.removeTaskFromTracking(task);
            this.totalTasksCancelled.incrementAndGet();
        }
    }

    private void removeTaskFromTracking(PathfindingTask task) {
        String taskKey = this.generateTaskKey(task);
        this.tasksByKey.remove(taskKey);
        this.tasksByEntity.remove(task.getEntityId());
    }

    private String generateTaskKey(PathfindingTask task) {
        return String.format("%d:%s:%s:%d", task.getEntityId(), task.getStartPos(), task.getGoalPos(), task.getReachRange());
    }

    private Map<PathfindingTask.Priority, Integer> countTasksByPriority() {
        EnumMap<PathfindingTask.Priority, Integer> counts = new EnumMap<PathfindingTask.Priority, Integer>(PathfindingTask.Priority.class);
        for (PathfindingTask.Priority priority : PathfindingTask.Priority.values()) {
            counts.put(priority, 0);
        }
        for (PathfindingTask task : this.taskQueue) {
            counts.merge(task.getPriority(), 1, Integer::sum);
        }
        return counts;
    }

    public void markTaskCompleted() {
        this.totalTasksCompleted.incrementAndGet();
    }

    public static class QueueStatistics {
        public final int currentSize;
        public final int totalQueued;
        public final int totalCompleted;
        public final int totalCancelled;
        public final Map<PathfindingTask.Priority, Integer> tasksByPriority;

        public QueueStatistics(int currentSize, int totalQueued, int totalCompleted, int totalCancelled, Map<PathfindingTask.Priority, Integer> tasksByPriority) {
            this.currentSize = currentSize;
            this.totalQueued = totalQueued;
            this.totalCompleted = totalCompleted;
            this.totalCancelled = totalCancelled;
            this.tasksByPriority = new EnumMap<PathfindingTask.Priority, Integer>(tasksByPriority);
        }

        public double getSuccessRate() {
            int total = this.totalCompleted + this.totalCancelled;
            return total > 0 ? (double)this.totalCompleted / (double)total : 0.0;
        }

        public String toString() {
            return String.format("QueueStats{size=%d, queued=%d, completed=%d, cancelled=%d, success=%.2f%%}", this.currentSize, this.totalQueued, this.totalCompleted, this.totalCancelled, this.getSuccessRate() * 100.0);
        }
    }
}

