/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;

public final class ReservationGrid {
    private static final ConcurrentHashMap<Long, AtomicInteger> occupancy = new ConcurrentHashMap();
    private static final double BASE_PENALTY = 0.15;
    private static final int MAX_HORIZON_TICKS = 20;
    private static final ConcurrentHashMap<Long, ConcurrentHashMap<Integer, AtomicInteger>> timeSlots = new ConcurrentHashMap();

    private ReservationGrid() {
    }

    public static double softPenalty(BlockPos pos, double expectedG) {
        AtomicInteger ts;
        long key = pos.m_121878_();
        AtomicInteger c = occupancy.get(key);
        int load = c == null ? 0 : Math.max(0, c.get());
        int curTick = (int)(System.currentTimeMillis() / 50L) % 20;
        ConcurrentHashMap<Integer, AtomicInteger> slots = timeSlots.get(key);
        if (slots != null && (ts = slots.get(curTick)) != null) {
            load += Math.max(0, ts.get());
        }
        if (load == 0) {
            return 0.0;
        }
        double scale = 1.0 + Math.min(0.5, expectedG * 5.0E-4);
        return 0.15 * (double)load * scale;
    }

    public static void reserve(BlockPos pos) {
        occupancy.computeIfAbsent(pos.m_121878_(), k -> new AtomicInteger()).incrementAndGet();
    }

    public static void reserveAt(BlockPos pos, int tickOffset) {
        long key = pos.m_121878_();
        int slot = Math.floorMod((int)(System.currentTimeMillis() / 50L) + tickOffset, 20);
        timeSlots.computeIfAbsent(key, k -> new ConcurrentHashMap()).computeIfAbsent(slot, k -> new AtomicInteger()).incrementAndGet();
    }

    public static void release(BlockPos pos) {
        AtomicInteger c = occupancy.get(pos.m_121878_());
        if (c == null) {
            return;
        }
        int v = c.decrementAndGet();
        if (v <= 0) {
            occupancy.remove(pos.m_121878_());
        }
    }

    public static void clearAll() {
        occupancy.clear();
        timeSlots.clear();
    }
}

