/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.monsters;

import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.sandbox.SandboxAction;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EntityType;

public class SpiderProd
extends ProductionItem {
    public static final String itemName = "Spider";
    public static final ResourceCost cost = ResourceCosts.SPIDER;

    public SpiderProd() {
        super(cost);
        this.onComplete = (level, placement) -> {
            if (!level.m_5776_()) {
                if (ResearchServerEvents.playerHasResearch(placement.ownerName, ProductionItems.RESEARCH_POISON_SPIDERS)) {
                    placement.produceUnit((ServerLevel)level, (EntityType<? extends Unit>)((EntityType)EntityRegistrar.POISON_SPIDER_UNIT.get()), placement.ownerName, true);
                } else {
                    placement.produceUnit((ServerLevel)level, (EntityType<? extends Unit>)((EntityType)EntityRegistrar.SPIDER_UNIT.get()), placement.ownerName, true);
                }
            }
        };
    }

    private static ResourceLocation getIcon() {
        if (ResearchClient.hasResearch(ProductionItems.RESEARCH_POISON_SPIDERS)) {
            return new ResourceLocation("reignofnether", "textures/mobheads/cave_spider.png");
        }
        return new ResourceLocation("reignofnether", "textures/mobheads/spider.png");
    }

    private static String getCancelName() {
        if (ResearchClient.hasResearch(ProductionItems.POISON_SPIDER)) {
            return "Poison Spider";
        }
        return itemName;
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    public AbilityButton getPlaceButton() {
        return new AbilityButton(itemName, new ResourceLocation("reignofnether", "textures/mobheads/spider.png"), null, () -> SandboxClientEvents.spawnUnitName.equals(itemName), () -> false, () -> true, () -> {
            CursorClientEvents.setLeftClickSandboxAction(SandboxAction.SPAWN_UNIT);
            SandboxClientEvents.spawnUnitName = itemName;
        }, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.spider", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.spider.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.spider.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.spider.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    @Override
    public Button getStartButton(ProductionPlacement prodBuilding, Keybinding hotkey) {
        return new Button(itemName, 14, SpiderProd.getIcon(), hotkey, () -> false, () -> ResearchClient.hasResearch(ProductionItems.RESEARCH_POISON_SPIDERS), () -> true, () -> BuildingServerboundPacket.startProduction(prodBuilding.originPos, ProductionItems.SPIDER), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.spider", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedPopAndTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.spider.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.spider.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.spider.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    @Override
    public Button getCancelButton(ProductionPlacement prodBuilding, boolean first) {
        return new Button(ResearchClient.hasResearch(ProductionItems.RESEARCH_POISON_SPIDERS) ? "Poison Spider" : itemName, 14, SpiderProd.getIcon(), (Keybinding)null, () -> false, () -> false, () -> true, () -> BuildingServerboundPacket.cancelProduction(prodBuilding.originPos, ProductionItems.SPIDER, first), null, null);
    }
}

