/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.neutral;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientboundPacket;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.team.TeamClientEvents;
import com.solegendary.reignofnether.team.TeamStatsServer;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.pathfinding.PathfindingManager;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

public class CourierDonkeyUnit
extends Donkey
implements Unit {
    private static final EntityDataAccessor<Boolean> DATA_ID_CHEST = SynchedEntityData.m_135353_(CourierDonkeyUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int eatingTicksLeft = 0;
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private static final ResourceCost COURIER_COST = ResourceCost.Unit(0, 0, 0, 0, 0);
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    public static final EntityDataAccessor<String> ownerDataAccessor = SynchedEntityData.m_135353_(CourierDonkeyUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int payloadAmount = 0;
    private ResourceName payloadResource = ResourceName.FOOD;
    private String receiverName = null;
    private BlockPos deliveryTarget = null;
    private int departDelayTicks = 0;

    @Override
    public void setEatingTicksLeft(int amount) {
        this.eatingTicksLeft = amount;
    }

    @Override
    public int getEatingTicksLeft() {
        return this.eatingTicksLeft;
    }

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public Faction getFaction() {
        return Faction.NONE;
    }

    @Override
    public List<AbilityButton> getAbilityButtons() {
        return List.of();
    }

    @Override
    public List<Ability> getAbilities() {
        return List.of();
    }

    @Override
    public List<ItemStack> getItems() {
        return List.of();
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return null;
    }

    @Override
    public boolean canGarrison() {
        return false;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return null;
    }

    @Override
    public int getMaxResources() {
        return 0;
    }

    @Override
    public float getMovementSpeed() {
        return 0.3f;
    }

    @Override
    public float getUnitMaxHealth() {
        return this.m_21233_();
    }

    @Override
    public ResourceCost getCost() {
        return COURIER_COST;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
        this.f_19804_.m_135372_(DATA_ID_CHEST, (Object)true);
    }

    public boolean m_30502_() {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22284_, 0.0);
    }

    public CourierDonkeyUnit(EntityType<? extends Donkey> entityType, Level level) {
        super(entityType, level);
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        Unit.tick(this);
        if (!this.m_9236_().m_5776_() && this.deliveryTarget != null) {
            if (this.departDelayTicks > 0) {
                --this.departDelayTicks;
                if (this.departDelayTicks == 0) {
                    this.getMoveGoal().setMoveTarget(this.deliveryTarget);
                }
                return;
            }
            if (this.getMoveGoal().getMoveTarget() == null) {
                this.getMoveGoal().setMoveTarget(this.deliveryTarget);
            }
            this.checkArrivalAndDeliver();
        }
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.moveGoal);
    }

    @Override
    public void initialiseGoals() {
        this.moveGoal = PathfindingManager.createGroundMovementGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, false, false);
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return null;
    }

    @Override
    public boolean canUsePortal() {
        return false;
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
        pCompound.m_128405_("payloadAmount", this.payloadAmount);
        pCompound.m_128359_("payloadResource", this.payloadResource.name());
        pCompound.m_128359_("receiverName", this.receiverName == null ? "" : this.receiverName);
        if (this.deliveryTarget != null) {
            pCompound.m_128405_("targetX", this.deliveryTarget.m_123341_());
            pCompound.m_128405_("targetY", this.deliveryTarget.m_123342_());
            pCompound.m_128405_("targetZ", this.deliveryTarget.m_123343_());
        }
        pCompound.m_128405_("departDelayTicks", this.departDelayTicks);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
        this.payloadAmount = pCompound.m_128451_("payloadAmount");
        try {
            this.payloadResource = ResourceName.valueOf(pCompound.m_128461_("payloadResource"));
        }
        catch (Exception ignore) {
            this.payloadResource = ResourceName.FOOD;
        }
        this.receiverName = pCompound.m_128461_("receiverName");
        if (pCompound.m_128441_("targetX")) {
            this.deliveryTarget = new BlockPos(pCompound.m_128451_("targetX"), pCompound.m_128451_("targetY"), pCompound.m_128451_("targetZ"));
        }
        this.departDelayTicks = pCompound.m_128451_("departDelayTicks");
    }

    public void setupDelivery(String receiverName, ResourceName resource, int amount, BlockPos targetPos) {
        this.setupDelivery(receiverName, resource, amount, targetPos, 0);
    }

    public void setupDelivery(String receiverName, ResourceName resource, int amount, BlockPos targetPos, int delayTicks) {
        if (this.moveGoal == null || this.getMoveGoal() == null || this.getTargetGoal() == null) {
            this.initialiseGoals();
        }
        this.receiverName = receiverName;
        this.payloadResource = resource;
        this.payloadAmount = amount;
        this.deliveryTarget = targetPos;
        this.departDelayTicks = Math.max(0, delayTicks);
        Unit.resetBehaviours(this);
        if (this.departDelayTicks <= 0) {
            this.getMoveGoal().setMoveTarget(targetPos);
        } else {
            this.getMoveGoal().setMoveTarget(null);
        }
    }

    private void checkArrivalAndDeliver() {
        if (this.deliveryTarget == null || this.receiverName == null) {
            return;
        }
        BuildingPlacement targetCapitol = CourierDonkeyUnit.getPlayerCapitol(this.receiverName);
        if (targetCapitol == null || !targetCapitol.isBuilt) {
            return;
        }
        BlockPos dropPos = targetCapitol.getClosestGroundPos(this.m_20097_(), 1);
        double dist = dropPos.m_123331_((Vec3i)this.m_20183_());
        if (dist <= 4.0) {
            Resources res = new Resources(this.receiverName, this.payloadResource == ResourceName.FOOD ? this.payloadAmount : 0, this.payloadResource == ResourceName.WOOD ? this.payloadAmount : 0, this.payloadResource == ResourceName.ORE ? this.payloadAmount : 0);
            ResourcesServerEvents.addSubtractResources(res);
            TeamClientEvents.incrementCourierDelivered(this.receiverName);
            ResourcesClientboundPacket.showFloatingText(res, dropPos);
            this.m_146870_();
        }
    }

    public void m_6667_(@NotNull DamageSource cause) {
        if (!this.m_9236_().m_5776_() && this.payloadAmount > 0 && this.getOwnerName() != null && !this.getOwnerName().isEmpty()) {
            TeamStatsServer.incrementCourierIntercepted(this.getOwnerName());
        }
        if (!this.m_9236_().m_5776_() && this.payloadAmount > 0) {
            Item itemToDrop = null;
            switch (this.payloadResource) {
                case FOOD: {
                    itemToDrop = Items.f_42501_;
                    break;
                }
                case WOOD: {
                    itemToDrop = Items.f_42398_;
                    break;
                }
                case ORE: {
                    itemToDrop = Items.f_41905_;
                    break;
                }
                default: {
                    itemToDrop = null;
                }
            }
            if (itemToDrop != null) {
                int count;
                for (int remaining = this.payloadAmount; remaining > 0; remaining -= count) {
                    count = Math.min(64, remaining);
                    this.m_19983_(new ItemStack((ItemLike)itemToDrop, count));
                }
            }
            this.payloadAmount = 0;
        }
        super.m_6667_(cause);
    }

    private static BuildingPlacement getPlayerCapitol(String ownerName) {
        for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
            if (!building.ownerName.equals(ownerName) || !building.isCapitol || !building.isBuilt) continue;
            return building;
        }
        return null;
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return pSpawnData;
    }
}

